<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Zapier_Core' ) ) :
	class WP_Travel_Zapier_Core {
		protected static $ABSPATH;

		protected static $PLUGIN_FILE;

		protected static $VERSION;

		const WP_TRAVEL_ZAPIER_HANDLE = 'wp_travel_zapier_';

		/**
		 * The single instance of the class.
		 *
		 * @var WP Travel Field Editor Core
		 * @since 1.0.0
		 */
		protected static $_instance = null;

		/**
		 * Main WP_Travel_Zapier_Core Instance.
		 * Ensures only one instance of WP_Travel_Zapier_Core is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 * @static
		 * @see WP_Travel_Zapier_Core()
		 * @return WP_Travel_Zapier_Core - Main instance.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Init core.
		 */
		public static function init() {
			self::$ABSPATH     = dirname( __FILE__ ) . '/';
			self::$PLUGIN_FILE = __FILE__;
			self::$VERSION     = '1.0.0';

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$enable_zapier = isset( $settings['show_wp_travel_zapier'] ) ? $settings['show_wp_travel_zapier'] : 'yes';

			add_filter( 'wp_travel_settings_fields', array( 'WP_Travel_Zapier_Core', 'settings_fields' ) );
			add_action( 'wp_travel_addons_setings_tab_fields', array( 'WP_Travel_Zapier_Core', 'plugin_action' ) );
			// if ( 'yes' !== $enable_zapier ) {
			// 	return;
			// }

			add_action( 'admin_enqueue_scripts', array( 'WP_Travel_Zapier_Core', 'wp_travel_zapier_admin_styles' ) );
			// add_action( 'wp_enqueue_scripts', array( 'WP_Travel_Zapier_Core', 'wp_travel_zapier_frontend_styles' ) );
			self::wp_travel_zapier_required_files();

		}


		/**
		 * Default settings fields.
		 *
		 * @param array $settings WP Travel Settings.
		 * @return array
		 */
		public static function settings_fields( $settings ) {
			$settings['show_wp_travel_zapier'] = 'yes';
			return $settings;
		}

		/**
		 * Plugin action to show / hide plugin settings and features.
		 */
		public static function plugin_action() {
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$field_name  = 'show_wp_travel_zapier';
			$field_label = __( 'WP Travel Zapier', 'wp-travel-pro' );

			$field_value = isset( $settings[ $field_name ] ) ? $settings[ $field_name ] : 'yes'; ?>
			<table class="form-table">
				<tr>
					<th>
						<label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html( $field_label ); ?></label>
					</th>
					<td>
						<span class="show-in-frontend checkbox-default-design">
							<label data-on="ON" data-off="OFF">
								<input value="no" name="<?php echo esc_attr( $field_name ); ?>" type="hidden" />
								<input <?php checked( $field_value, 'yes' ); ?> value="yes" name="<?php echo esc_attr( $field_name ); ?>" id="<?php echo esc_attr( $field_name ); ?>" type="checkbox" />
								<span class="switch"></span>
							</label>
						</span>
						<p class="description"><label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html__( 'Show all your "', 'wp-travel-pro' ) . esc_html( $field_label ) . esc_html__( '" settings and enable its feature.', 'wp-travel-pro' ); ?></label></p>
					</td>
				</tr>
			</table>
			<?php
		}

		/**
		 * Enqueue style and scripts for admin panel.
		 */
		public static function wp_travel_zapier_admin_styles() {

			/**
			 * @since 1.0.2
			 */
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}
			$switch_to_react = true; // force enable.
			if ( function_exists( 'wptravel_is_react_version_enabled' ) ) {
				$switch_to_react = wptravel_is_react_version_enabled();  // force enable but has filter to include backward compatibility for now.
			}
			$screen = get_current_screen();
			if (  method_exists( 'WP_Travel',  'is_page' )  ) { // @since WP Travel 4.4.2
				$is_settings_page = WP_Travel::is_page( 'settings', true );
			} else {
				$is_settings_page = 'itinerary-booking_page_settings' == $screen->id;
			}
			if ( $is_settings_page ) {
				$deps                   = include_once sprintf( '%s/app/build/wp-travel-settings.asset.php', plugin_dir_path( __FILE__ ) );
				$deps['dependencies'][] = 'jquery';
				wp_enqueue_script( self::WP_TRAVEL_ZAPIER_HANDLE . 'admin-settings', plugin_dir_url( __FILE__ ) . '/app/build/wp-travel-settings.js', $deps['dependencies'], $deps['version'], true );
			}
			if ( ! $switch_to_react ) {
				// Styles.
				wp_enqueue_style( self::WP_TRAVEL_ZAPIER_HANDLE . 'admin_styles', plugin_dir_url( __FILE__ ) . 'assets/admin-styles.css', array(), self::$VERSION );

				// Scripts.
				wp_register_script( self::WP_TRAVEL_ZAPIER_HANDLE . 'admin_scripts', plugin_dir_url( __FILE__ ) . 'assets/admin-scripts.js', array(), self::$VERSION, true );
				wp_enqueue_script( self::WP_TRAVEL_ZAPIER_HANDLE . 'admin_scripts' );
			}

		}

		/**
		 * Enqueues our external stylesheet for frontend
		 */
		public static function wp_travel_zapier_frontend_styles() {

			/**
			 * @since wp_travel@4.0.4
			 * Do not enqueue empty scripts/
			 */
			// Styles.
			// wp_enqueue_style( self::WP_TRAVEL_ZAPIER_HANDLE . 'frontend_styles', plugin_dir_url( __FILE__ ) . 'assets/frontend-styles.css', array(), self::$VERSION );

			// Scripts.
			// wp_enqueue_script( self::WP_TRAVEL_ZAPIER_HANDLE . 'frontend_scripts', plugin_dir_url( __FILE__ ) . 'assets/frontend-scripts.js', array(), self::$VERSION, true );
		}

		/**
		 * Function to include files after plugin loaded.
		 */
		public static function wp_travel_zapier_required_files() {
			include_once self::$ABSPATH . '/inc/functions.php';
			include_once self::$ABSPATH . '/inc/admin-settings-misc-options.php';
			include_once self::$ABSPATH . '/inc/enquiry/enquiry-automation.php';
			include_once self::$ABSPATH . '/inc/booking/booking-automation.php';
			include_once self::$ABSPATH . '/inc/wp-travel-zapier-ajax.php';
		}
	}
endif;
