<?php
/**
 * Handles all the ajax related tasks.
 *
 * @since 1.0.2
 */

/**
 * Exit if accessed directly.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$switch_to_react = true; // force enable.
if ( function_exists( 'wptravel_is_react_version_enabled' ) ) {
	$switch_to_react = wptravel_is_react_version_enabled();  // force enable but has filter to include backward compatibility for now.
}

if ( ! function_exists( 'wp_travel_zapier_send_webhook_tests' ) ) {

	/**
	 * Sends test responses
	 *
	 * @since 1.0.2
	 */
	function wp_travel_zapier_send_webhook_tests() {
		wp_send_json_success( $_POST );
	}
	if ( $switch_to_react ) {
		add_action( 'wp_ajax_wp_travel_zapier_send_webhook_tests', 'wp_travel_zapier_send_webhook_tests' );
	}
}
