<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Initialize the booking automation after the booking save.
 *
 * @param int    $booking_id Trip booking ID.
 * @param string $first_key  First Key of the array.
 * @return void
 */
function wp_travel_zapier_trigger_booking_automation( $booking_id, $first_key ) {
	if ( empty( $booking_id ) && empty( $first_key ) ) {
		return;
	}

	wp_travel_zapier_bookings_automation( false, $booking_id, $first_key );
}
add_action( 'wp_travel_after_frontend_booking_save', 'wp_travel_zapier_trigger_booking_automation', 12, 2 );
