<?php
/**
 * Wishlists assets.
 */

add_filter( 'wp_travel_settings_options', 'wp_travel_fontawesome_icons', 10, 2 );
/**
 * Function for making options of fa icon list on v4 settings.
 *
 * @param array $settings_options Options.
 * @param array $settings settings wp-travel.
 */
function wp_travel_fontawesome_icons( $settings_options, $settings ) {

	$fa_icons      = wptravel_fa_icons();
	$fa_icons_list = array();
	$i             = 0;
	if ( is_array( $fa_icons ) && count( $fa_icons ) > 0 ) {
		foreach ( $fa_icons as $key => $fa_icon ) {
			$fa_icons_list[ $i ]['label'] = $fa_icon;
			$fa_icons_list[ $i ]['value'] = $key;
			$i++;
		}
	}

	$settings_options['wp_travel_fontawesome_icons'] = $fa_icons_list;

	return $settings_options;
}

/**
 * Wishlists settings.
 *
 * @return array Settings.
 */
function wp_travel_wishlists_settings() {
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$defaults           = array(
		'add_icon'    => 'far fa-bookmark',
		'remove_icon' => 'fas fa-bookmark',
		'add_text'    => 'Add to wishlists',
		'remove_text' => 'Remove from wishlists',
		'icon_color'  => '#f83531',
	);
	$wishlists_settings = ! empty( $settings['wishlists'] ) ? $settings['wishlists'] : array();
	return wp_parse_args( $wishlists_settings, $defaults );
}

/**
 * Wishlists setting content.
 *
 * @param  string $tab  Current tab.
 * @param  array  $args Args.
 */
function wp_travel_wishlists_admin_settings_content( $tab, $args ) {
	if ( 'misc_options_global' !== $tab ) {
		return;
	}
	$settings = wp_travel_wishlists_settings();
	include 'templates/admin-settings.php';
}
add_action( 'wp_travel_tabs_content_settings_misc_options_global', 'wp_travel_wishlists_admin_settings_content', 20, 2 );

/**
 * Save wishlists settings.
 *
 * @param  array $settings Other settings.
 * @return array           Modified settings.
 */
function wp_travel_wishlists_save_settingsv4( $settings, $settings_data ) {

	if ( isset( $settings_data['wishlists']['add_icon'] ) && '' !== ( $settings_data['wishlists']['add_icon'] ) ) {
		$settings['wishlists']['add_icon'] = stripslashes_deep( $settings_data['wishlists']['add_icon'] );
	}
	if ( isset( $settings_data['wishlists']['remove_icon'] ) && '' !== ( $settings_data['wishlists']['remove_icon'] ) ) {
		$settings['wishlists']['remove_icon'] = stripslashes_deep( $settings_data['wishlists']['remove_icon'] );
	}
	if ( isset( $settings_data['wishlists']['add_text'] ) && '' !== ( $settings_data['wishlists']['add_text'] ) ) {
		$settings['wishlists']['add_text'] = stripslashes_deep( $settings_data['wishlists']['add_text'] );
	}
	if ( isset( $settings_data['wishlists']['remove_text'] ) && '' !== ( $settings_data['wishlists']['remove_text'] ) ) {
		$settings['wishlists']['remove_text'] = stripslashes_deep( $settings_data['wishlists']['remove_text'] );
	}
	if ( isset( $settings_data['wishlists']['icon_color'] ) && '' !== ( $settings_data['wishlists']['icon_color'] ) ) {
		$settings['wishlists']['icon_color'] = stripslashes_deep( $settings_data['wishlists']['icon_color'] );
	}

	return $settings;
}
add_action( 'wp_travel_block_before_save_settings', 'wp_travel_wishlists_save_settingsv4', 10, 2 );

/**
 * Save wishlists settings.
 *
 * @param  array $settings Other settings.
 * @return array           Modified settings.
 */
function wp_travel_wishlists_save_settings( $settings ) {
	if ( ! empty( $_POST['wp_travel_wishlists'] ) ) :
		$wishlists_settings                   = $_POST['wp_travel_wishlists'];
		$settings['wishlists']['add_icon']    = esc_attr( $wishlists_settings['add_icon'] );
		$settings['wishlists']['remove_icon'] = esc_attr( $wishlists_settings['remove_icon'] );
		$settings['wishlists']['add_text']    = esc_attr( $wishlists_settings['add_text'] );
		$settings['wishlists']['remove_text'] = esc_attr( $wishlists_settings['remove_text'] );
		$settings['wishlists']['icon_color']  = esc_attr( $wishlists_settings['icon_color'] );
  endif;

	return $settings;
}
add_action( 'wp_travel_before_save_settings', 'wp_travel_wishlists_save_settings' );

function wp_travel_wishlists_add_user_dashboard_menu( $menus ) {
	$menus['wishlists'] = array(
		'menu_title'      => __( 'Wishlists', 'wp-travel-pro' ),
		'menu_icon'       => 'wt-icon-regular wt-icon-bookmark',
		'menu_content_cb' => 'wp_travel_wishlists_tab_content',
		'priority'        => 21,
	);

	// $menus = array_slice( $menus, 0, 2, true ) + $menu + array_slice( $menus, 2, count( $menus ) - 1, true );
	return $menus;
}
add_filter( 'wp_travel_user_dashboard_menus', 'wp_travel_wishlists_add_user_dashboard_menu' );

/**
 * User dashboard wishlist content.
 */
function wp_travel_wishlists_tab_content() {
	wp_enqueue_script( 'wp-travel-list-wishlists' );
	include 'templates/content-wishlists.php';
}

/**
 * Wishlists icon color.
 */
function wp_travel_wishlists_styles() {
	$settings = wp_travel_wishlists_settings();
	$color    = $settings['icon_color'];
	?>
  <style>
  .wp-travel-add-to-wishlists,
  .wp-travel-add-to-wishlists:hover,
  .wp-travel-add-to-wishlists:active,
  .wp-travel-add-to-wishlists:focus{
	color: <?php echo esc_attr( $color ); ?>!important;
  }
  </style>
	<?php
}
add_action( 'wp_footer', 'wp_travel_wishlists_styles' );

/**
 * Display wishlist button.
 *
 * @param  int $post_id Post ID.
 */
function wp_travel_wishlists_show_button( $post_id ) {
	$layout_version = 'v1';
	if ( function_exists( 'wptravel_layout_version' ) ) {
		$layout_version = wptravel_layout_version();
	}
	$settings = wp_travel_wishlists_settings();
	$event    = 'add';
	$icon     = sprintf( '<i class="%s"></i>', $settings['add_icon'] );
	$title    = __( 'Please login to add your wishlists.', 'wp-travel-pro' );
	if ( is_user_logged_in() ) {
		$title     = $settings['add_text'];
		$user_id   = get_current_user_id();
		$wishlists = get_user_meta( $user_id, 'wp_travel_wishlists', true );
		$wishlists = empty( $wishlists ) ? array() : $wishlists;
		$key       = array_search( $post_id, $wishlists );
		if ( false !== $key ) {
			$event = 'remove';
			$icon  = sprintf( '<i class="%s"></i>', $settings['remove_icon'] );
			$title = $settings['remove_text'];
		}
	}
	if ( 'v1' === $layout_version || is_singular( WP_TRAVEL_POST_TYPE ) ) {
		printf( '<a href="javascript:void(0);" data-id="%d" data-event="%s" title="%s" class="wp-travel-add-to-wishlists">%s %s</a>', esc_html( $post_id ), esc_html( $event ),  esc_html( $title ), wp_kses_post( $icon ), esc_html( $title ) );
	} else {
		printf( '<div class="favourite"><a href="javascript:void(0);" data-id="%d" data-event="%s" title="%s" class="wp-travel-add-to-wishlists">%s %s</a></div>', esc_html( $post_id ), esc_html( $event ),  esc_html( $title ), wp_kses_post( $icon ), esc_html( $title ) );
	}
}
add_action( 'wp_travel_before_single_title', 'wp_travel_wishlists_show_button', 1 );
$layout_version = 'v1';
if ( function_exists( 'wptravel_layout_version' ) ) {
	$layout_version = wptravel_layout_version();
}
if ( 'v1' === $layout_version ) { // Legacy
	add_action( 'wp_travel_before_archive_content_title', 'wp_travel_wishlists_show_button', -1 );
	// FOR widgets in list view temp solution.
	add_action( 'wp_travel_before_item_title', 'wp_travel_wishlists_show_button', -1 );
} else {
	add_action( 'wp_travel_after_archive_title', 'wp_travel_wishlists_show_button', -1 );
}

/**
 * Save wishlist.
 */
function wp_travel_ajax_add_to_wishlists() {
	check_ajax_referer( 'wp_travel_frontend_security', 'security' );
	$post = file_get_contents( 'php://input' );
	$post = json_decode( $post );

	if ( ! is_user_logged_in() ) {
		wp_send_json_error(
			array(
				'message' => __( 'User not loggedin.', 'wp-travel-pro' ),
			)
		);
	}
	// Check post id.
	if ( empty( $post->post_id ) ) {
		wp_send_json_error(
			array(
				'message' => __( 'No post id found.', 'wp-travel-pro' ),
			)
		);
	}
	// Check event.
	if ( empty( $post->event ) ) {
		wp_send_json_error(
			array(
				'message' => __( 'No event found.', 'wp-travel-pro' ),
			)
		);
	}
	$user_id   = get_current_user_id();
	$wishlists = get_user_meta( $user_id, 'wp_travel_wishlists', true );
	$wishlists = empty( $wishlists ) ? array() : $wishlists;
	if ( 'add' === $post->event ) {
		$key = array_search( $post->post_id, $wishlists );
		if ( false === $key ) {
			$wishlists[] = absint( $post->post_id );
		}
	} else {
		$key = array_search( $post->post_id, $wishlists );
		if ( false !== $key ) {
			unset( $wishlists[ $key ] );
		}
	}

	update_user_meta( $user_id, 'wp_travel_wishlists', $wishlists );

	$settings = wp_travel_wishlists_settings();
	$icon     = 'add' === $post->event ? $settings['remove_icon'] : $settings['add_icon'];

	$response['event'] = 'add' === $post->event ? 'remove' : 'add';
	$response['icon']  = sprintf( '<i class="%s"></i>', $icon );
	$response['title'] = 'add' === $post->event ? $settings['remove_text'] : $settings['add_text'];

	wp_send_json_success( $response );
	die();
}
add_action( 'wp_ajax_nopriv_wp_travel_add_to_wishlists', 'wp_travel_ajax_add_to_wishlists' );
add_action( 'wp_ajax_wp_travel_add_to_wishlists', 'wp_travel_ajax_add_to_wishlists' );

/**
 * Ajax callback to get list of wishlists.
 */
function wp_travel_ajax_list_wishlists() {
	check_ajax_referer( 'wp_travel_frontend_security', 'security' );

	if ( ! is_user_logged_in() ) {
		wp_send_json_error(
			array(
				'message' => __( 'User not loggedin.', 'wp-travel-pro' ),
			)
		);
	}

	$user_id   = get_current_user_id();
	$wishlists = get_user_meta( $user_id, 'wp_travel_wishlists', true );
	$wishlists = empty( $wishlists ) ? array() : $wishlists;
	$posts     = array();

	if ( ! empty( $wishlists ) ) {
		$args['post__in']  = $wishlists;
		$args['post_type'] = 'itineraries';
		$posts             = get_posts( $args );
		if ( $posts ) {
			foreach ( $posts as $key => $post ) {
				$posts[ $key ]->post_thumbnail_url = wptravel_get_post_thumbnail_url( $post->ID );
			}
		}
	}
	$response['posts'] = $posts;
	wp_send_json_success( $response );
}
add_action( 'wp_ajax_nopriv_wp_travel_list_wishlists', 'wp_travel_ajax_list_wishlists' );
add_action( 'wp_ajax_wp_travel_list_wishlists', 'wp_travel_ajax_list_wishlists' );
