<?php
/**
 * Plugin Functions.
 *
 * @package WP_Travel_Utilities
 */

// add itinerary image in front end itinerary tab.
add_action( 'wp_travel_itineraries_after_title', 'wp_travel_utilities_itinerary_image' );
add_action( 'wp_travel_itinerary_list_template_before_description', 'wp_travel_itinerary_list_template_callback' );
add_action( 'wp_travel_itinerary_list_before_description', 'wp_travel_itinerary_list_callback', 10, 2 );
add_filter( 'wp_travel_booking_form_fields', 'wp_travel_utilities_price_unavailable_info' ); // @todo : Deprecated hook. Need to remove this.

// FAQ Hooks.
add_filter( 'wp_travel_itinerary_faq_questions', 'wp_travel_utils_override_faq_questions_array', 10, 2 );
add_filter( 'wp_travel_itinerary_faq_answers', 'wp_travel_utils_override_faq_answers_array', 10, 2 );
add_filter( 'wptravel_trip_faqs', 'wp_travel_utils_override_faqs_array', 10, 2 );

add_action( 'wp_travel_before_content_start', 'wp_travel_utilities_add_to_cart_success_message' );

add_action( 'wp_ajax_wp_travel_add_cusom_global__tabs_content_data', 'wp_travel_add_cusom_global__tabs_content_data' );
add_action( 'wp_ajax_nopriv_wp_travel_add_cusom_global__tabs_content_data', 'wp_travel_add_cusom_global__tabs_content_data' );

add_action( 'wp_travel_pricing_add_new_category_button', 'wp_travel_pricing_add_new_category_button_callback' );
add_action( 'wp_travel_pricing_add_new_category_button_repeator', 'wp_travel_pricing_add_new_category_button_callback' );

add_filter( 'wp_travel_checkout_fields', 'wp_travel_customize_booking_option' );

add_filter( 'wptravel_is_payment_enabled', 'wptravel_utilities_is_payment_enabled' );
if ( ! function_exists( 'wp_travel_add_cusom_global__tabs_content_data' ) ) {
	/**
	 * Admin Itineraries Data Content Tabs Load.
	 *
	 * @since 1.1.0
	 * @return Null
	 */
	function wp_travel_add_cusom_global__tabs_content_data() {

		$uid         = $_POST['unique_id'];
		$tab_label   = __( 'Tab Label', 'wp-travel-pro' );
		$tab_content = __( 'Tab Content', 'wp-travel-pro' );
		?>
		<div class="panel panel-default">
				<div class="panel-heading" role="tab" id="heading-<?php echo esc_attr( $uid ); ?>">
					<h4 class="panel-title">
						<div class="wp-travel-sorting-handle"></div>
						<a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion-global-custom-tab" href="#collapse-<?php echo esc_attr( $uid ); ?>" aria-expanded="true" aria-controls="collapse-<?php echo esc_attr( $uid ); ?>">

							<span bind="custom_global_tab_<?php echo esc_attr( $uid ); ?>" class="faq-label"><?php echo esc_html( $tab_label ); ?></span>

						<span class="collapse-icon"></span>
						</a>
						<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
					</h4>
				</div>
				<div id="collapse-<?php echo esc_attr( $uid ); ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-"<?php echo esc_attr( $uid ); ?>>
				<div class="panel-body">
					<div class="panel-wrap">
						<label><?php esc_html_e( 'Tab Label', 'wp-travel-pro' ); ?></label>
						<input bind="custom_global_tab_<?php echo esc_attr( $uid ); ?>" type="text" class="faq-question-text" name="wp_travel_custom_global_tabs[<?php echo esc_attr( $uid ); ?>][label]" placeholder="<?php esc_html_e( 'Tab Label', 'wp-travel-pro' ); ?>" value="<?php echo esc_html( $tab_label ); ?>">
					</div>
					<div>
						<span class="show-in-frontend checkbox-default-design"><label data-on="ON" data-off="OFF"><input name="wp_travel_custom_global_tabs[<?php echo esc_attr( $uid ); ?>][show_in_menu]" type="checkbox" value="yes" <?php checked( 'yes', $tab['show_in_menu'] ); ?> /><?php // esc_html_e( 'Display', 'wp-travel' ); ?>
						<span class="switch">
						</span>
						</label></span>
					</div>
				<?php

					$custom_tabs_settings = array(
						'quicktags'     => array( 'buttons' => 'em,strong,link' ),
						'quicktags'     => true,
						'tinymce'       => true,
						'textarea_rows' => 20,
						'editor_height' => 300,
						'textarea_name' => 'wp_travel_custom_global_tabs[' . $uid . '][content]',
					);
					?>
				<div class="wp_travel_admin_editor">
					<?php wp_editor( $tab_content, 'wp_travel_global_custom_tab_cnt_' . $uid, $custom_tabs_settings ); ?>
				</div>
				</div>
				</div>
			</div>
		<?php
		exit;
	}
}

function wp_travel_utilities_slugify_string( $str ) {
	// Convert to lowercase and remove whitespace
	$str = strtolower( trim( $str ) );

	// Replace high ascii characters
	$chars        = array( 'ä', 'ö', 'ü', 'ß' );
	$replacements = array( 'ae', 'oe', 'ue', 'ss' );
	$str          = str_replace( $chars, $replacements, $str );
	$pattern      = array( '/(é|è|ë|ê)/', '/(ó|ò|ö|ô)/', '/(ú|ù|ü|û)/' );
	$replacements = array( 'e', 'o', 'u' );
	$str          = preg_replace( $pattern, $replacements, $str );

	// Remove puncuation
	$pattern = array( ': ', '!', '?', '.', '/', "'" );
	$str     = str_replace( $pattern, '', $str );

	// Hyphenate any non alphanumeric characters
	$pattern = array( '/[^a-z0-9-]/', '/-+/' );
	$str     = preg_replace( $pattern, '-', $str );

	return $str;
}

/**
 * Get Inquiry Link. [Need To depricate]
 */
function wp_travel_utilities__get_inquiry_link() {

	ob_start();

	?>

		<a id="wp-travel-send-enquiries" class="wp-travel-send-enquiries" data-effect="mfp-move-from-top" href="#wp-travel-enquiries">
			<span class="wp-travel-booking-enquiry">
				<span class="dashicons dashicons-editor-help"></span>
				<span>
					<?php esc_html_e( 'Trip Enquiry', 'wp-travel-pro' ); ?>
				</span>
			</span>
		</a>

	<?php

	$data = ob_get_clean();

	return $data;

}

/**
 * Override Itinerary FAQ Questions.
 *
 * @param array $questions All Faq of trip.
 */
function wp_travel_utils_override_faq_questions_array( $questions, $post_id ) {

	if ( ! $post_id ) {
		global $post;
		$post_id = $post->ID;
	}
	$use_global_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_global_faq_for_trip', true );
	$use_global_faqs = ( $use_global_faqs ) ? $use_global_faqs : 'no';

	$use_trip_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_trip_faq_for_trip', true );
	$use_trip_faqs = ( $use_trip_faqs ) ? $use_trip_faqs : 'no';

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$global_questions = isset( $settings['wp_travel_utils_global_faq_question'] ) ? $settings['wp_travel_utils_global_faq_question'] : array();

	// Changes as per wp travel 5.2.3.
	if ( function_exists( 'wptravel_get_global_faqs' ) ) {
		$global_faqs      = wptravel_get_global_faqs();
		$global_questions = array_column( $global_faqs, 'question' );
	}
	// End of Changes as per wp travel 5.2.3.

	// Merging Global faq with trip faq.
	if ( ( is_array( $global_questions ) && ! empty( $global_questions ) ) && is_array( $questions ) ) {
		$questions = array_merge( $questions, $global_questions );
		$questions = array_unique( $questions );
	}

	return $questions;

}

/**
 * Override Itinerary FAQ Answers.
 */
function wp_travel_utils_override_faq_answers_array( $answers, $post_id ) {

	if ( ! $post_id ) {
		global $post;
		$post_id = $post->ID;
	}
	$use_global_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_global_faq_for_trip', true );
	$use_global_faqs = ( $use_global_faqs ) ? $use_global_faqs : 'no';

	$use_trip_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_trip_faq_for_trip', true );
	$use_trip_faqs = ( $use_trip_faqs ) ? $use_trip_faqs : 'no';

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$global_answers = isset( $settings['wp_travel_utils_global_faq_answer'] ) ? $settings['wp_travel_utils_global_faq_answer'] : array();
	// Changes as per wp travel 5.2.3.
	if ( function_exists( 'wptravel_get_global_faqs' ) ) {
		$global_faqs    = wptravel_get_global_faqs();
		$global_answers = array_column( $global_faqs, 'answer' );
	}
	// End of Changes as per wp travel 5.2.3.

	// Merging Global faq with trip faq.
	if ( ( is_array( $global_answers ) && ! empty( $global_answers ) ) && is_array( $answers ) ) {
		$answers = array_merge( $answers, $global_answers );
		$answers = array_unique( $answers );
	}

	return $answers;
}

/**
 * New faqs since WP Travel 5.2.3. This will add newly added global faqs in trip faqs to show global faqs.
 */
function wp_travel_utils_override_faqs_array( $faqs, $post_id ) {

	if ( ! $post_id ) {
		global $post;
		$post_id = $post->ID;
	}
	$use_global_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_global_faq_for_trip', true );
	$use_global_faqs = ( $use_global_faqs ) ? $use_global_faqs : 'no';

	$use_trip_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_trip_faq_for_trip', true );
	$use_trip_faqs = ( $use_trip_faqs ) ? $use_trip_faqs : 'no';

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$global_faqs      = array();
	$global_answers   = isset( $settings['wp_travel_utils_global_faq_answer'] ) ? $settings['wp_travel_utils_global_faq_answer'] : array();
	$global_questions = isset( $settings['wp_travel_utils_global_faq_question'] ) ? $settings['wp_travel_utils_global_faq_question'] : array();
	if ( is_array( $global_questions ) && count( $global_questions ) > 0 ) {
		foreach ( $global_questions as $index => $question ) {
			$global_faqs[] = array(
				'question'      => $question,
				'answer'        => $global_answers[ $index ],
				'global'        => 'yes',
				'global_faq_id' => $index,
			);
		}
	}
	// Changes as per wp travel 5.2.3.
	if ( function_exists( 'wptravel_get_global_faqs' ) ) {
		$global_faqs = wptravel_get_global_faqs();
	}
	// End of Changes as per wp travel 5.2.3.

	// Adding newly added global faqs in the trip faqs.
	if ( ( is_array( $global_faqs ) && ! empty( $global_faqs ) ) && is_array( $faqs ) ) {
		$temp_global_faq_ids = array_column( $faqs, 'global_faq_id' );

		if ( is_array( $temp_global_faq_ids ) && count( $temp_global_faq_ids ) > 0 ) {
			foreach ( $global_faqs as $faq_id => $global_faq ) {
				// Do not add third param as true.
				if ( ! in_array( $faq_id, $temp_global_faq_ids ) ) { // phpcs:ignore
					$global_faq['global']        = 'yes';
					$global_faq['global_faq_id'] = $faq_id;
					$faqs[]                      = $global_faq;
				}
			}
		}
	}
	return $faqs;
}

/**
 * Show Add to Cart Success message to the trip page.
 */
function wp_travel_utilities_add_to_cart_success_message() {

	if ( ! is_singular( WP_TRAVEL_POST_TYPE ) ) {
		return;
	}
	if ( isset( $_GET['add_to_cart'] ) && 'true' === $_GET['add_to_cart'] ) :
		?>
		<script>
			history.replaceState({},null,window.location.pathname);
		</script>
		<?php
		// Print Errors / Notices.
		WP_Travel()->notices->print_notices( 'error', true );
		WP_Travel()->notices->print_notices( 'success', true );
		?>
		<p class="col-xs-12 wp-travel-notice-success wp-travel-notice">
			<span><?php esc_html_e( 'Trip added to cart successfully !', 'wp-travel-pro' ); ?></span>
			<a class="view_cart_btn" href="<?php echo esc_url( wptravel_get_cart_url() ); ?>"><?php esc_html_e( 'View Cart', 'wp-travel-pro' ); ?></a>
		</p>
		<?php
	endif;

}

function wp_travel_utilities_price_unavailable_info( $fields ) {
	$trip_id = $fields['post_id']['default'];

	if ( ! $trip_id ) {
		global $post;
		if ( ! isset( $post->ID ) ) {
			return;
		}
		$trip_id = $post->ID;
	}
	if ( method_exists( 'WP_Travel_Helpers_Pricings', 'get_price' ) ) {
		$args       = array(
			'trip_id' => $trip_id,
		);
		$trip_price = WP_Travel_Helpers_Pricings::get_price( $args );
	} else {
		// Legacy & deprecated. Need to remove in future
		$trip_price = wp_travel_get_trip_price( $trip_id );
	}
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$no_price_text = isset( $settings['price_unavailable_text'] ) && '' !== $settings['price_unavailable_text'] ? $settings['price_unavailable_text'] : '';
	if ( ! $trip_price ) {
		$fields['price-unavailable'] = array(
			'type'          => 'text_info',
			'label'         => 'Price :',
			'name'          => 'price_unavailable_text',
			'id'            => 'price-unavailable',
			'wrapper_class' => 'full-width wp-travel-price-unavailable',
			'default'       => $no_price_text,
		);
	}
	return $fields;
}

function wp_travel_itinerary_list_callback( $cnt, $itinerary ) {

	$image_id  = ( isset( $itinerary['image'] ) && '' !== $itinerary['image'] ) ? $itinerary['image'] : '';
	$image_url = '';
	if ( $image_id ) {
		$image     = wp_get_attachment_image_src( $image_id, 'thumbnail' );
		$image_url = $image[0];
	}
	if ( '' === $image_url ) {
		$image_url = wptravel_get_post_placeholder_image_url();
	}

	$button_text = __( 'Select', 'wp-travel-pro' );
	if ( $image_id ) :
		$button_text = __( 'Change', 'wp-travel-pro' );
	endif;
	?>
	<div class="panel-wrap panel-wrap-itinerary">
		<label><?php esc_html_e( 'Image', 'wp-travel-pro' ); ?></label>
		<div class="media-preview">
			<img class="img-preview" src="<?php echo esc_url( $image_url ); ?>" style="max-width:100%">
			<input class="wp-travel-custom-media-id" type="hidden" name="wp_travel_trip_itinerary_data[<?php echo esc_attr( $cnt ); ?>][image]" value="<?php echo esc_html( $image_id ); ?>">
		</div>
		<a data-button-change-text="<?php echo esc_attr( 'Change', 'wp-travel' ); ?>" data-uploader-title="<?php echo esc_attr( 'Select Image', 'wp-travel' ); ?>" data-uploader-button-text="<?php echo esc_attr( 'Choose', 'wp-travel' ); ?>" class="wp-travel-custom-media button button-primary button-large " >
			<?php echo esc_html( $button_text ); ?>
		</a>
	</div>
	<?php
}

function wp_travel_itinerary_list_template_callback( $cnt ) {

	$image_id    = '';
	$image_url   = wptravel_get_post_placeholder_image_url();
	$button_text = __( 'Select', 'wp-travel-pro' );
	?>
	<div class="panel-wrap panel-wrap-itinerary">
		<label><?php esc_html_e( 'Image', 'wp-travel-pro' ); ?></label>
		<div class="media-preview">
			<img class="img-preview" src="<?php echo esc_url( $image_url ); ?>" style="max-width:100%">
			<input class="wp-travel-custom-media-id" type="hidden" name="wp_travel_trip_itinerary_data[<?php echo esc_attr( $cnt ); ?>][image]" value="<?php echo esc_html( $image_id ); ?>">
		</div>
		<a data-button-change-text="<?php echo esc_attr( 'Change', 'wp-travel' ); ?>" data-uploader-title="<?php echo esc_attr( 'Select Image', 'wp-travel' ); ?>" data-uploader-button-text="<?php echo esc_attr( 'Choose', 'wp-travel' ); ?>" class="wp-travel-custom-media button button-primary button-large " >
			<?php echo esc_html( $button_text ); ?>
		</a>
	</div>
	<?php
}

/**
 * Return template.
 *
 * @param  String $template_name Path of template.
 * @param  array  $args arguments.
 * @return Mixed
 */
function wp_travel_cart_checkout_addon_get_template( $template_name, $args = array() ) {
	$template_path = apply_filters( 'wp_travel_cart_checkout_addon_template_path', 'wp-travel/' );
	$default_path  = sprintf( '%s/templates/', plugin_dir_path( dirname( __FILE__ ) ) );

	// Look templates in theme first.
	$template = locate_template(
		array(
			trailingslashit( $template_path ) . $template_name,
			$template_name,
		)
	);
	if ( ! $template ) {
		$template = $default_path . $template_name;
	}
	if ( file_exists( $template ) ) {
		return $template;
	}
	return false;
}

/**
 * Like wp_travel_cart_checkout_addon_get_template, but returns the HTML instead of outputting.
 *
 * @see wp_travel_cart_checkout_addon_get_template
 * @since 1.3.7
 * @param string $template_name Template name.
 * @param array  $args          Arguments. (default: array).
 *
 * @return string
 */
function wp_travel_cart_checkout_addon_get_template_html( $template_name, $args = array() ) {
	ob_start();
	if ( ! empty( $args ) && is_array( $args ) ) {
		extract( $args ); // @codingStandardsIgnoreLine
	}
	include wp_travel_cart_checkout_addon_get_template( $template_name );
	return ob_get_clean();
}
/**
 * Get Template Part.
 *
 * @param  String $slug Name of slug.
 * @param  string $name Name of file / template.
 */
function wp_travel_cart_checkout_addon_get_template_part( $slug, $name = '' ) {
	$template  = '';
	$file_name = ( $name ) ? "{$slug}-{$name}.php" : "{$slug}.php";
	if ( $name ) {
		$template = wp_travel_cart_checkout_addon_get_template( $file_name );
	}
	if ( $template ) {
		load_template( $template, false );
	}
}

/**
 * Load Template
 *
 * @param  String $path Path of template.
 * @param  array  $args Template arguments.
 */
function wp_travel_cart_checkout_addon_load_template( $path, $args = array() ) {
	$template = wp_travel_cart_checkout_addon_get_template( $path, $args );
	if ( $template ) {
		include $template;
	}
}

if ( ! function_exists( 'wp_travel_utilities_is_multiple_cart_enabled' ) ) {
	/**
	 * Is multiple cart / checkout allowed ?
	 *
	 * @return bool
	 */
	function wp_travel_utilities_is_multiple_cart_enabled( $allow = false ) {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		if ( isset( $settings['enable_multiple_checkout'] ) ) {
			$allow = 'yes' === $settings['enable_multiple_checkout'] ? true : false;
		}

		return $allow;

	}
}

function wp_travel_utilities_itinerary_image( $itinerary ) {
	if ( isset( $itinerary['image'] ) && '' !== $itinerary['image'] ) {
		$image_id   = $itinerary['image'];
		$image_data = wp_get_attachment_image_src( $image_id, 'medium' );
		if ( is_array( $image_data ) && count( $image_data ) > 0 ) {
			echo '<img src="' . esc_url( $image_data[0] ) . '">';
		}
		return;
	}
}

function wp_travel_pricing_add_new_category_button_callback() {
	?>
	<input type="button" value="<?php esc_html_e( 'Add New', 'wp-travel-pro' ); ?>" class="button button-primary wp-travel-add-new-pricing-category" title="<?php esc_html_e( 'Add New Category', 'wp-travel-pro' ); ?>" style="float:right" />

	<?php
}

if ( ! function_exists( 'wp_travel_customize_booking_option' ) ) {
	/**
	 * Display booking option as per selection on backend.
	 *
	 * @param array $fields List of fields.
	 */
	function wp_travel_customize_booking_option( $fields ) {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		$selected_booking_option = ! empty( $settings['selected_booking_option'] ) ? ( $settings['selected_booking_option'] ) : array();

		if ( class_exists( 'WpTravel_Helpers_Strings' ) ) {
			$strings = WpTravel_Helpers_Strings::get();
		} else {
			if ( function_exists( 'wptravel_get_strings' ) ) {
				$strings = wptravel_get_strings();
			} else {
				$strings = wp_travel_get_strings();
			}
		}
		$label_booking_with_payment = isset( $strings['bookings']['booking_with_payment'] ) ? $strings['bookings']['booking_with_payment'] : __( 'Booking with payment', 'wp-travel-pro' );
		$label_booking_only         = isset( $strings['bookings']['booking_only'] ) ? $strings['bookings']['booking_only'] : __( 'Booking only', 'wp-travel-pro' );

		if ( in_array( 'booking-only', $selected_booking_option, true ) && in_array( 'booking-with-payment', $selected_booking_option, true ) ) {
			$fields['payment_fields']['booking_option']['options'] = array(
				'booking_with_payment' => $label_booking_with_payment,
				'booking_only'         => $label_booking_only,
			);
		} elseif ( ! in_array( 'booking-only', $selected_booking_option, true ) && in_array( 'booking-with-payment', $selected_booking_option, true ) ) {
			$fields['payment_fields']['booking_option']['type']    = 'hidden';
			$fields['payment_fields']['booking_option']['default'] = 'booking_with_payment';

			$fields['payment_fields']['booking_option']['options'] = array(
				'booking_with_payment' => $label_booking_with_payment,
			);
		} elseif ( in_array( 'booking-only', $selected_booking_option, true ) && ! in_array( 'booking-with-payment', $selected_booking_option, true ) ) {
			$fields['payment_fields']['booking_option']['type']    = 'hidden';
			$fields['payment_fields']['booking_option']['default'] = 'booking_only';

			$fields['payment_fields']['booking_option']['options'] = array(
				'booking_only' => $label_booking_only,
			);
		} else {
			$fields['payment_fields']['booking_option']['options'] = array();
			$fields['payment_fields']['booking_option']['default'] = 'booking_only';
		}

		return $fields;
	}
}

if ( ! function_exists( 'wptravel_utilities_is_payment_enabled' ) ) {
	/**
	 * Display booking option as per selection on backend.
	 *
	 * @param array $payment_enabled List of fields.
	 */
	function wptravel_utilities_is_payment_enabled( $payment_enabled ) {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		$selected_booking_option = ! empty( $settings['selected_booking_option'] ) ? ( $settings['selected_booking_option'] ) : array();
		if ( in_array( 'booking-only', $selected_booking_option, true ) && ! in_array( 'booking-with-payment', $selected_booking_option, true ) ) {
			return false;
		}
		return $payment_enabled;
	}
}
