<?php
/**
 * WP Travel Utils Shortcodes.
 */

add_shortcode( 'wp_travel_utils_global_faq', 'wp_travel_utilities_global_faq_shortcode_callback' );

// Thank You page order shortcode.
// depricated since 1.8.6 use  wp_travel_thankyou instead
add_shortcode( 'wp_travel_booking_details', 'wp_travel_utilities_booking_thank_you_callback' );
add_shortcode( 'wp_travel_thankyou', 'wp_travel_utilities_booking_thank_you_callback' );


/**
 * Global FAQ Shortcode Callback
 */
function wp_travel_utilities_global_faq_shortcode_callback() {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$wp_travel_utils_global_faq_question = isset( $settings['global_faqs'] ) ? $settings['global_faqs'] : array();

	$custom_global_utils_faq = isset( $settings['wp_travel_utils_global_faq_answer'] ) ? $settings['wp_travel_utils_global_faq_answer'] : array();

	ob_start();

	if ( is_array( $wp_travel_utils_global_faq_question ) && 0 !== count( $wp_travel_utils_global_faq_question ) ) :

		?>
	
	<div class="global-faq-shortcode tab-list-content">
		<div class="panel-group" id="accordion">

		<div class="wp-collapse-open clearfix">
			<a href="#" class="open-all-link"><span class="open-all" id="open-all"><?php esc_html_e( 'Open All', 'wp-travel-pro' ); ?></span></a>
			<a href="#" class="close-all-link" style="display:none"><span class="close-all" id="close-all"><?php esc_html_e( 'Close All', 'wp-travel-pro' ); ?></span></a>
		</div>
		
		<?php foreach ( $wp_travel_utils_global_faq_question as $key => $question ) : ?>
			
		<div class="panel panel-default">
			<div class="panel-heading">
				<h4 class="panel-title">
				<a class="accordion-toggle collapsed" data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo esc_attr( $key + 1 ); ?>">
					<?php echo isset( $question['question'] ) ? esc_html( $question['question'] ) : ''; ?>
					<span class="collapse-icon"></span>
				</a>
				</h4>
			</div>
			<div id="collapse<?php echo esc_attr( $key + 1 ); ?>" class="panel-collapse collapse">
				<div class="panel-body">
				<?php echo isset( $question['answer'] ) ? wp_kses_post( wpautop( $question['answer'] ) ) : ''; ?>
				</div>
			</div>
		</div>

		<?php endforeach; ?>

		</div>
	</div>

		<?php
	endif;

	$data = ob_get_clean();

	return $data;

}

/**
 * Booking recieved Thank You page.
 */
function wp_travel_utilities_booking_thank_you_callback() {

	if( isset( $_REQUEST['code'] ) && $_REQUEST['code'] == '1' && $_REQUEST['description'] == 'Transaction is approved' ){
		$order_id     = (int)str_replace( 'Booking-', '', $_REQUEST['order'] );
	}else{
		$order_id = isset( $_GET['order_id'] ) ? $_GET['order_id'] : '';
	}

	if ( empty( $order_id ) ) {
		
		if( has_action( 'wp_travel_thankyou_page_empty_message' ) ){
			return 	apply_filters( 'wp_travel_thankyou_page_empty_message', '' );
		}else{
			$url = get_post_type_archive_link( WP_TRAVEL_POST_TYPE );
			return __( 'No active orders found. Please ', 'wp-travel-pro' ) . '<a href="'. $url.'"> ' . __( 'click here', 'wp-travel-pro' ) . '</a>' . __( ' to book some trips first.', 'wp-travel-pro' );
		}
		
	}
	if ( class_exists( 'WpTravel_Helpers_Strings' ) ) {
		$strings = WpTravel_Helpers_Strings::get();
	}
	$booking_id = $order_id;
	ob_start();
		do_action( 'wptravel_before_thankyou_page_content_start', $order_id ); // @since 4.0.2
		$payment    = false;
		$payment_id = false;

	if ( isset( $_GET['payment_id'] ) && ! empty( $_GET['payment_id'] ) ) {

		$payment    = true;
		$payment_id = isset( $_GET['payment_id'] ) && ! empty( $_GET['payment_id'] ) ? $_GET['payment_id'] : false;

	}

	if ( isset( $_GET['booked'] ) && 1 == $_GET['booked'] ) :
		?>
			<script>
				history.replaceState({},null,window.location.pathname);
			</script>
			<p class="col-xs-12 wp-travel-notice-success wp-travel-notice"><?php echo esc_html( apply_filters( 'wp_travel_booked_message', __( "Thank you for booking! We'll reach out to you soon.", 'wp-travel-pro' ) ) ); ?></p>

		<?php elseif ( isset( $_GET['booked'] ) && 0 == $_GET['booked'] ) : ?>
			<script>
				history.replaceState({},null,window.location.pathname);
			</script>
			<?php
				$err_msg = __( 'Your Item has been added but the email could not be sent.', 'wp-travel-pro' ) . "<br />\n" . __( 'Possible reason: your host may have disabled the mail() function.', 'wp-travel-pro' );
			?>
			
			<p class="col-xs-12 wp-travel-notice-danger wp-travel-notice"><?php echo esc_html( apply_filters( 'wp_travel_booked_message', $err_msg ) ); ?></p>
		<?php endif; ?>

			<?php
			$items = get_post_meta( $order_id, 'order_items_data', true );
			if ( ! $items ) {
				return;
			}

			
			
			?>

			<h2 class="wp-travel-order-heading"><?php esc_html_e( 'Booking Details', 'wp-travel-pro' ); ?></h2>

			<table id="newBookingDetails" cellpadding="0" cellspacing="0" height="100%" width="100%" style="text-align: left;">
				<thead>
					<tr>
						<th><?php esc_html_e( 'Itinerary', 'wp-travel-pro' ); ?></th>
						<th><?php echo $strings['bookings']['pax'] ? esc_html( strtoupper( $strings['bookings']['pax'] ) ) : esc_html__( 'PAX', 'wp-travel-pro' ); ?></th>
						<!-- <th><?php esc_html_e( 'Scheduled Date', 'wp-travel-pro' ); ?></th> -->
						<th><?php echo esc_html( apply_filters( 'wp_travel_booking_mail_departure', __( 'Departure Date', 'wp-travel-pro' ), $booking_id ) ); ?></th>
						<th><?php echo esc_html( apply_filters( 'wp_travel_booking_mail_arrival', __( 'Arrival Date', 'wp-travel-pro' ), $booking_id ) ); ?></th>
					</tr>
				</thead>
				<tbody>
				<?php


				global $wpdb;
					// Order Details.
				foreach ( $items as $item_key => $trip ) {
					
					$trip_id = $trip['trip_id'];
					$trip_data = WpTravel_Helpers_Trips::get_trip($trip_id)['trip'];

					// Values
					$coupon_applied = '';
					if( isset( $trip['discount_type'] ) ){
						$coupon_applied = true;
						$coupon_type = $trip['discount_type'];
						$coupon_code = $trip['coupon_code'];
						$coupon_value = $trip['discount'];
					}
					
					$pax_counts = 0;
					$title          = get_the_title( $trip_id );
					$pax            = isset( $trip['pax'] ) ? $trip['pax'] : '';
					$arrival_date   = isset( $trip['arrival_date'] ) && ! empty( $trip['arrival_date'] ) ? $trip['arrival_date'] : '';
					$departure_date = isset( $trip['departure_date'] ) && ! empty( $trip['departure_date'] ) ? wptravel_format_date( $trip['departure_date'] ) : '';
					$end_date = isset( $trip['departure_date'] ) && ! empty( $trip['departure_date'] ) ? wptravel_format_date( $wpdb->get_row( $wpdb->prepare("SELECT * FROM {$wpdb->prefix}wt_dates WHERE id=%s;", $trip['date_id'] ) )->end_date ) : '';

					if( date_create( $arrival_date ) && $trip_data['trip_duration']['days'] ){
						$departure_date = date_create( $arrival_date );
						date_add( $departure_date,date_interval_create_from_date_string( ( (int) $trip_data['trip_duration']['days'] - 1 )." days" ) );
						$departure_date = date_format($departure_date,"F j, Y");
					}
					
	
					$pricing_id   = $trip['pricing_id'];
					$pricing_data = WP_Travel_Helpers_Pricings::get_pricings( $trip_id, $pricing_id );

					$pricing_title = '';
					if ( ! is_wp_error( $pricing_data ) && isset( $pricing_data['code'] ) && 'WP_TRAVEL_TRIP_PRICINGS' === $pricing_data['code'] ) {
						$pricing       = $pricing_data['pricings'];
						$pricing_title = is_array( $pricing ) && isset( $pricing ) ? $pricing['title'] : '';
					}

					$pax_price_total = 0;
					$extras_price_total = 0;
					?>

						<tr>
							<td>
								<a href="<?php echo esc_url( get_permalink( $trip_id ) ); ?>"><strong><?php echo esc_html( $title ); ?></strong></a>
								<br>
								<span class="my-order-pricing"><?php echo esc_html( $pricing_title ); ?></span>
								<span class="my-order-tail">
								<?php if ( ! empty( $trip['trip'] ) ) : ?>
										<?php
										foreach ( $trip['trip'] as $category_id => $t ) :
											if ( $t['pax'] < 1 ) {
												continue;
											}
											$pax_counts = $pax_counts + $t['pax'];
											$pax_price_total = $pax_price_total + ( $t['pax'] * $t['price'] );
											if( $t['price_per'] == 'group' ):
											?>
												<span class="my-order-price-detail">(<?php echo esc_html( $t['pax'] ) . ' ' . $t['custom_label'] . ' ' ; ?>) <?php echo wptravel_get_formated_price_currency( $t['price'], false, '', $booking_id ); //@phpcs:ignore ?></span>
		
												<?php else: ?>
												<span class="my-order-price-detail">(<?php echo esc_html( $t['pax'] ) . ' ' . $t['custom_label'] . ' x ' . wptravel_get_formated_price_currency( $t['price'], false, '', $booking_id ); ?>) <?php echo wptravel_get_formated_price_currency( $t['pax'] * $t['price'], false, '', $booking_id ); //@phpcs:ignore ?></span>
											<?php 
											endif;  
										endforeach; 
									endif; 
									?>
								</span>
								<?php
								if ( isset( $trip['trip_extras'] ) && isset( $trip['trip_extras']['id'] ) && count( $trip['trip_extras']['id'] ) > 0 ) :
										$extras = $trip['trip_extras'];
									?>
										<div class="my-order-price-breakdown-additional-service">
											<span><strong><?php esc_html_e( 'Additional Services', 'wp-travel-pro' ); ?></strong></span>
											<?php
											foreach ( $trip['trip_extras']['id'] as $k => $extra_id ) :

												$trip_extras_data = get_post_meta( $extra_id, 'wp_travel_tour_extras_metas', true );

												$price      = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
												$sale_price = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;

												if ( $sale_price ) {
													$price = $sale_price;
												}
												$price = WpTravel_Helpers_Trip_Pricing_Categories::get_converted_price( $price );

												$qty = isset( $extras['qty'][ $k ] ) && $extras['qty'][ $k ] ? $extras['qty'][ $k ] : 1;

												$total = $price * $qty;
												$extras_price_total = $extras_price_total + ( $price * $qty );
												?>
												<div class="my-order-price-breakdown-additional-service-item clearfix">
													<span class="my-order-head"><?php echo esc_html( get_the_title( $extra_id ) ); ?> (<?php echo esc_attr( $qty ) . ' x ' . wp_kses_post( wptravel_get_formated_price_currency( $price, false, '', $order_id ) ); ?>)</span>
													<span class="my-order-tail my-order-right"><?php echo wp_kses_post( wptravel_get_formated_price_currency( $total, false, '', $order_id ) ); //@phpcs:ignore ?></span>
												</div>
											<?php endforeach; ?>

										</div>

										<?php
									endif;
								?>
							</td>

							<td><?php echo isset( $pax_counts ) ? esc_html( $pax_counts ) : esc_html( $pax ); ?></td>
							<!-- <td><?php echo esc_html__( 'N/A', 'wp-travel-pro' ); ?></td> -->
							<?php if( !$trip_data['is_fixed_departure'] ): ?>
								<?php if( isset($trip_data['trip_duration']["duration_format"]) && $trip_data['trip_duration']["duration_format"] == 'hour_minute' ): ?>
									<td><?php echo esc_html( wptravel_format_date( $arrival_date ) ); ?></td>
									<td><?php echo esc_html( wptravel_format_date( $arrival_date ) ); ?></td>
									
									<?php else: ?>
									<td><?php echo esc_html( wptravel_format_date( $arrival_date ) ); ?></td>
									<td><?php echo esc_html( wptravel_format_date( $departure_date ) ); ?></td>
								<?php endif; ?>
								<?php else: ?>
									<td>
										<?php echo esc_html( wptravel_format_date( $arrival_date ) ); ?>
										<br>
										<?php if( isset( $trip['trip_time'] ) ){
											$date_format = '';
											foreach( $trip_data['dates'] as $date ){
												if( $trip['date_id'] == $date['id'] ){
													$date_format = $date['twentyfour_time_format'];
												}
											}
											echo wp_travel_get_converted_time_format( $trip['trip_time'], $date_format );
										}
										?>
									</td>
									<?php if( isset( $trip_data['dates'] ) && $trip_data['dates'][0]['is_recurring'] == false ): ?>
										<td><?php echo esc_html($end_date ); ?></td>
										<?php else: ?>
										<td>
											<?php if( $trip_data['trip_duration']['days'] ): ?>
												<?php echo esc_html( wptravel_format_date( $departure_date ) ); ?>
												<?php else: ?>
													<?php echo esc_html__( 'N\A', 'wp-travel-pro' ); ?>
											<?php endif; ?>
										</td>
									<?php endif; ?>
							<?php endif; ?>
						</tr>
							
						<?php
					
				}

				$settings = wptravel_get_settings();
				if( $settings['enable_woo_checkout'] == 'no' ){
					if( $coupon_applied ):
						?>
						<tr class="wp_travel_payment_detail_show_on_frontend">
							<th colspan="4"><?php esc_html_e( 'Coupon Applied', 'wp-travel-pro' ); ?></th>
						</tr>
						<tr>
							<td colspan="2">
								<p><b><?php esc_html_e( 'Coupon Code:', 'wp-travel-pro' ); ?></b> <?php echo esc_html($coupon_code); ?></p>
							</td>
							<td colspan="2">
								<p><b><?php esc_html_e( 'Discount:', 'wp-travel-pro' ); ?></b> <?php echo wptravel_get_formated_price_currency( $coupon_value, false, '', $booking_id ); //@phpcs:ignore ?></p>
							</td>
						</tr>
						<?php endif; ?>
						<tr class="wp_travel_payment_detail_show_on_frontend">
							<th colspan="4"><?php esc_html_e( 'Payment details', 'wp-travel-pro' ); ?></th>
						</tr>
						<tr>
							<td colspan="4">
								<?php
								$booking_option = get_post_meta( $booking_id, 'wp_travel_booking_option', true );
								if ( 'booking_only' == $booking_option ) {
									echo wp_kses_post( apply_filters( 'wp_travel_booked_message_after_text', '<div>' . esc_html__( 'Booking Option : ', 'wp-travel-pro' ) . __( 'Booking Only', 'wp-travel-pro' ) . '</div>', 'wp-travel-pro' ) );
								} elseif ( 'booking_with_payment' == $booking_option ) {
									$payment_method = get_post_meta( $booking_id, 'wp_travel_payment_gateway', true );
									if ( 'bank_deposit' == $payment_method ) {
										?>
											<div>
												<?php esc_html_e( 'Booking Option', 'wp-travel-pro' ); ?> : <?php esc_html_e( 'Booking with payment', 'wp-travel-pro' ); ?> 
											</div>
											<div>
												<?php esc_html_e( 'Payment Method', 'wp-travel-pro' ); ?> : <?php esc_html_e( 'Bank deposit', 'wp-travel-pro' ); ?> 
											</div>
											<div>
												<?php esc_html_e( 'Payment Status : Waiting for Voucher. Please', 'wp-travel-pro' ); ?> <a href="<?php echo esc_url( apply_filters( 'wp_travel_bank_deposit_link', 'https://wptravel.io/docs/wp-travel-user-documentation/settings/payment/#h-bank-deposit' ) ); ?>" target="_blank" class="wp_travel_bank_deposit_link" ><?php esc_html_e( 'submit', 'wp-travel-pro' ); ?></a><?php esc_html_e( ' your voucher', 'wp-travel-pro' ); ?>.
											</div>
										<?php
									} else {
										$payment_status = get_post_meta( $booking_id, 'wp_travel_booking_status', true );
										$texts = '<div>' . __( 'Booking Option', 'wp-travel-pro' ) . ' : ' .  __( 'Booking with payment', 'wp-travel-pro' ) . '<br>' . __( 'Payment Method', 'wp-travel-pro' ) . ' : ' .  esc_html( ucfirst( $payment_method ) ) . '<br>' . __( 'Payment Status', 'wp-travel-pro' ) . ' : ' .  __( 'Booked', 'wp-travel-pro' ) . '</div>';
										// echo apply_filters( 'wp_travel_booked_message_after_text', __( '<div> Booking Option : Booking with payment <br> Payment Method : '
										// . ucfirst( $payment_method ) .
										// '<br> Payment Status : ' . _e( 'Booked', 'wp-travel-pro' ) . 
										//    '.</div>' ), 'wp-travel-pro' );
										echo wp_kses_post( apply_filters( 'wp_travel_booked_message_after_text', $texts ) );
									}
								}
								?>
							</td>
						</tr> <?php
				}
				?>
				</tbody>
			</table>

			<?php
			if ( $payment ) :

				if ( ! $payment_id ) {
					return;
				}

				$wp_travel_payment_status = get_post_meta( $payment_id, 'wp_travel_payment_status', true );
				$wp_travel_payment_mode   = get_post_meta( $payment_id, 'wp_travel_payment_mode', true );
				$payment_amount           = get_post_meta( $payment_id, 'wp_travel_payment_amount', true );

				?>
				<h2 class="wp-travel-order-heading"><?php esc_html_e( 'Payment Details', 'wp-travel-pro' ); ?></h2>
				
				<table class="wp-travel-paymet-details">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Payment Status', 'wp-travel-pro' ); ?></th>
							<th><?php esc_html_e( 'Payment Mode', 'wp-travel-pro' ); ?></th>
							<th><?php esc_html_e( 'Payment Amount', 'wp-travel-pro' ); ?></th>
						</tr>
						<tr>
							<td><?php echo esc_html( $wp_travel_payment_status ); ?></td>
							<td><?php echo esc_html( $wp_travel_payment_mode ); ?></td>
							<td><?php echo wp_kses_post( wptravel_get_formated_price( $payment_amount ) ); ?></td>
						</tr>
					</thead>
					<tbody>

					</tbody>
				</table>
				
			<?php endif; ?>
	<?php
	do_action( 'wptravel_after_thankyou_page_content', $order_id ); // @since 4.0.2
	$data = ob_get_clean();

	return $data;

}
