<?php
/**
 * Admin Settings Tabs / Contents.
 *
 * @package WP_Travel
 */

// Add tab.
add_filter( 'wp_travel_settings_tabs', 'wp_travel_add_utilities_cart_checkout_addon_settings_tabs' );
// Add tab content callback.
add_action( 'wp_travel_tabs_content_settings_cart_checkout_settings_global', 'wp_travel_utilities_cart_checkout_settings_tab_callback', 12, 2 );

/**
 * Wp_travel_add_utilities_cart_checkout_addon_settings_tabs Add Additional Tabs in settings.
 *
 * @param array $tabs_array Tabs.
 */
function wp_travel_add_utilities_cart_checkout_addon_settings_tabs( $tabs_array ) {
	if ( ! isset( $tabs_array['cart_checkout_settings_global'] ) ) {
		$tabs_array['cart_checkout_settings_global'] = array(
			'tab_label'     => __( 'Cart & Checkout', 'wp-travel-pro' ),
			'content_title' => __( 'Cart & Checkout Process Options', 'wp-travel-pro' ),
			'priority'      => 86,
		);
	}

	return $tabs_array;

}
/**
 * Account Settings tab Callback.
 *
 * @param  Array $tab  List of tabs.
 * @param  Array $args Settings arg list.
 */
function wp_travel_utilities_cart_checkout_settings_tab_callback( $tab, $args ) {

	$force_cart_checkout_process_for_trips = isset( $args['settings']['force_cart_checkout_process_for_trips'] ) ? $args['settings']['force_cart_checkout_process_for_trips'] : 'no';

	$skip_cart_page_booking = isset( $args['settings']['skip_cart_page_booking'] ) ? $args['settings']['skip_cart_page_booking'] : 'no';

	$price_unavailable_text = isset( $args['settings']['price_unavailable_text'] ) && ! empty( $args['settings']['price_unavailable_text'] ) ? $args['settings']['price_unavailable_text'] : __( 'Contact Us', 'wp-travel-pro' );
	?>
	<table class="form-table">
		<?php do_action( 'wp_travel_settings_tab_before_cart_content', $tab, $args ); ?>
		
		<tr>
			<th>
				<label for="force_cart_checkout_process_for_trips"> <?php echo esc_html__( 'Force Cart / Checkout', 'wp-travel-pro' ); ?> </label>
			</th>
			<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input <?php echo checked( $force_cart_checkout_process_for_trips, 'yes', false ); ?>  value="yes" name="force_cart_checkout_process_for_trips" id="force_cart_checkout_process_for_trips" type="checkbox" />
						<span class="switch">
						</span>
					</label>
				</span>
				<p class="description"><label for="force_cart_checkout_process_for_trips"> <?php echo esc_html__( 'Force Cart / Checkout Process for Bookings, even when no payment gateways are enabled', 'wp-travel-pro' ); ?> </label></p>
			</td>
		</tr>

		<tr>
			<th>
				<label for="skip_cart_page_booking"> <?php echo esc_html__( 'Skip Cart Page', 'wp-travel-pro' ); ?> </label>
			</th>
			<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input <?php echo checked( $skip_cart_page_booking, 'yes', false ); ?>  value="yes" name="skip_cart_page_booking" id="skip_cart_page_booking" type="checkbox" />
						<span class="switch">
						</span>
					</label>
				</span>
				<p class="description"><label for="skip_cart_page_booking"> <?php echo esc_html__( 'Skip Cart Page and take users directly to checkout on bookings', 'wp-travel-pro' ); ?> </label></p>
			</td>
		</tr>

		<tr>
			<th>
				<label for="price_unavailable_text"> <?php echo esc_html__( 'Price Unavailable Text', 'wp-travel-pro' ); ?> </label>
			</th>
			<td>
				<input type="text" value=" <?php echo esc_attr( $price_unavailable_text ); ?> " name="price_unavailable_text" id="price_unavailable_text"/>
				<p class="description"><label for="price_unavailable_text"> <?php echo esc_html__( 'Price unavailable text for trips with empty or 0 prices', 'wp-travel-pro' ); ?> </label></p>
			</td>
		</tr>

		<?php
			$booking_options = array(
				'booking-only'         => 'Booking only',
				'booking-with-payment' => 'Booking with payment',
			);

			$booking_options = apply_filters( 'wp_travel_checkout_booking_options', $booking_options );

			$selected_booking_options = ! empty( $args['settings']['selected_booking_option'] ) && isset( $args['settings']['selected_booking_option'] ) ? $args['settings']['selected_booking_option'] : array();

			?>
		<tr>
			<th>
				<label for="booking_option"> <?php echo esc_html__( 'Select Booking Option', 'wp-travel-pro' ); ?> </label>
			</th>
			<td>
				<select name="selected_booking_option[]" id="booking-option-selection" class="booking_option_selection wp-travel-select2" multiple="multiple">
					<?php
					if ( is_array( $booking_options ) && count( $booking_options ) > 0 ) {
						foreach ( $booking_options as $option_value => $option_label ) {
							$selected = in_array( $option_value, $selected_booking_options, true ) ? 'selected' : '';
							?>
								<option <?php echo esc_attr( $selected ); ?> value="<?php echo esc_attr( $option_value ); ?>"><?php echo esc_html( $option_label ); ?></option>
							<?php
						}
					}
					?>
				</select>
				<p class="description"><?php esc_html_e( 'Note: Any payment gateway must be enable inorder to work this options. If payment is not enabled then \'Booking only\' option will work.', 'wp-travel-pro' ); ?></p>
			</td>
		</tr>
		<?php do_action( 'wp_travel_settings_tab_after_cart_content', $tab, $args ); ?>
	</table>
	<?php
}

// Add settings to the save settings Array.
add_filter( 'wp_travel_before_save_settings', 'wp_travel_utilities_save_settings' );

/**
 * Save Additional Settings.
 *
 * @param array $settings_array settings array.
 */
function wp_travel_utilities_save_settings( $settings_array ) {

	$force_cart_checkout_process_for_trips                   = ( isset( $_POST['force_cart_checkout_process_for_trips'] ) && '' !== $_POST['force_cart_checkout_process_for_trips'] ) ? 'yes' : 'no';
	$settings_array['force_cart_checkout_process_for_trips'] = $force_cart_checkout_process_for_trips;

	$skip_cart_page_booking                   = ( isset( $_POST['skip_cart_page_booking'] ) && '' !== $_POST['skip_cart_page_booking'] ) ? 'yes' : 'no';
	$settings_array['skip_cart_page_booking'] = $skip_cart_page_booking;

	if ( isset( $_POST['thank_you_page_id'] ) ) {
		$thank_you_page                      = absint( $_POST['thank_you_page_id'] );
		$settings_array['thank_you_page_id'] = $thank_you_page;
	}

	if ( isset( $_POST['price_unavailable_text'] ) ) {
		$price_unavailable_text                   = sanitize_text_field( $_POST['price_unavailable_text'] );
		$settings_array['price_unavailable_text'] = $price_unavailable_text;
	}

	if ( isset( $_POST['selected_booking_option'] ) ) {
		$booking_option_selected                   = $_POST['selected_booking_option'];
		$settings_array['selected_booking_option'] = $booking_option_selected;
	}

	return $settings_array;
}
