<?php
/**
 * Backend metabox tab for cart / checkout.
 */
class WP_Travel_Cart_Checkout_Addon_Backend_Meta_tabs {

	/**
	 * Constructor.
	 */
	public function __construct() {

		add_filter( 'wp_travel_tabs', array( $this, 'filter_metabox_tabs' ) );

		add_action( 'wp_travel_tabs_content_' . WP_TRAVEL_POST_TYPE . '_cart_checkout', array( $this, 'cart_checkout_tab_cb' ), 10, 2 );

		add_action( 'wp_travel_itinerary_extra_meta_save', array( $this, 'save_meta_data' ) );

	}

	/**
	 * Filter Metabox tabs.
	 */
	public function filter_metabox_tabs( $tabs ) {
		if ( ! isset( $tabs[ WP_TRAVEL_POST_TYPE ]['cart_checkout'] ) ) {
			$tabs[ WP_TRAVEL_POST_TYPE ]['cart_checkout'] = array(
				'tab_label'     => __( 'Cart & Checkout', 'wp-travel-pro' ),
				'content_title' => __( 'Cart & Checkout Options', 'wp-travel-pro' ),
			);
		}

		return $tabs;

	}

	/**
	 * Cart / Checkout tabs callback.
	 */
	public function cart_checkout_tab_cb( $tab ) {

		global $post;

		$checkout_info_label = get_post_meta( $post->ID, 'wp_travel_trip_checkout_page_info_label', true );
		$checkout_info       = get_post_meta( $post->ID, 'wp_travel_trip_checkout_page_info', true );

		?>

			<table class="form-table">
				<tr>
					<td>
						<h4>
							<label for="wp_travel_trip_checkout_page_info_label"><?php esc_html_e( 'Checkout Information', 'wp-travel-pro' ); ?></label>
						</h4>
						<p class="description"><?php esc_html_e( 'Label for Trip Specific info content to display in checkout page.( Leave Blank to remove label )', 'wp-travel-pro' ); ?>
						</p>
					<input type="text" name ="wp_travel_trip_checkout_page_info_label" id="wp_travel_trip_checkout_page_info_label" value="<?php echo esc_html( $checkout_info_label ); ?>" >
					</td>
				</tr>
				<tr>
					<td>
						<h4>
							<label for="wp_travel_trip_checkout_page_info"><?php esc_html_e( 'Checkout Information', 'wp-travel-pro' ); ?></label>
						</h4>
						<p class="description"><?php esc_html_e( 'Trip Specific info content to display in checkout page.( Below form )', 'wp-travel-pro' ); ?>
						</p>
				  <div class="wp_travel_admin_editor">
					<?php wp_editor( $checkout_info, 'wp_travel_trip_checkout_page_info' ); ?>
				  </div>
					</td>
				</tr>
			</table>

		<?php
	}

	/**
	 * Save Meta data.
	 */
	public function save_meta_data() {

		global $post;

		if ( ! $post ) {
			return;
		}

		$post_id = $post->ID;

		if ( isset( $_POST['wp_travel_trip_checkout_page_info'] ) ) {
			$wp_travel_trip_checkout_page_info = $_POST['wp_travel_trip_checkout_page_info'];
			update_post_meta( $post_id, 'wp_travel_trip_checkout_page_info', $wp_travel_trip_checkout_page_info );
		}

		if ( isset( $_POST['wp_travel_trip_checkout_page_info_label'] ) ) {
			$wp_travel_trip_checkout_page_info_label = $_POST['wp_travel_trip_checkout_page_info_label'];
			update_post_meta( $post_id, 'wp_travel_trip_checkout_page_info_label', $wp_travel_trip_checkout_page_info_label );
		}

	}

}

new WP_Travel_Cart_Checkout_Addon_Backend_Meta_tabs();
