<?php
/**
 * Settings Helper.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Default settings keys. This will automatically save for normal input key value pair.
 *
 * @param array $fields All settings fields.
 * @since WP Travel 4.0.7
 */
function wp_travel_utilities_settings_fields( $fields ) {
	if ( function_exists( 'wptravel_get_page_id' ) ) {
		$thankyou_page_id = wptravel_get_page_id( 'booking-thank-you' );
	} else {
		$thankyou_page_id = wp_travel_get_page_id( 'booking-thank-you' );
	}

	$fields['thank_you_page_id']                     = $thankyou_page_id;
	$fields['enable_custom_trip_code_option']        = 'yes';
	$fields['disable_email_powered_by_text']         = 'no';
	$fields['email_template_powered_by_text']        = __( '{sitename} - Powered By: ', 'wp-travel-pro' ) . '<a href="http://wptravel.io/" target="_blank" style="color: #5a418b;text-decoration: none;">WP Travel.</a>' ;
	$fields['wp_travel_booking_notif_emails']        = array();
	$fields['wp_travel_payment_notif_emails']        = array();
	$fields['wp_travel_enquiry_notif_emails']        = array();
	$fields['global_faqs']        = array();
	$fields['force_cart_checkout_process_for_trips'] = 'no';
	$fields['skip_cart_page_booking']                = 'no';
	$fields['price_unavailable_text']                = '';

	// Addons Settings.
	$fields['show_wp_travel_utilities'] = 'yes'; // moved from utilities-core.php.
	$fields['selected_booking_option']  = array( 'booking-only', 'booking-with-payment' );
	$fields['enable_multiple_checkout'] = 'no';

	// if ( wp travel version >=5.2.4 ) {
	// register new default value.
	// }

	return $fields;
}
add_filter( 'wp_travel_settings_fields', 'wp_travel_utilities_settings_fields', 15 );

/**
 * Mapped settings values for React Block. [get settings]
 *
 * @param array $settings All settings.
 * @since WP Travel 4.0.7
 */
function wp_travel_utilities_settings_vlaues( $settings ) {

	// Custom Tabs.
	$mapped_custom_global_tabs = array();

	$tabs = isset( $settings['wp_travel_custom_global_tabs'] ) ? $settings['wp_travel_custom_global_tabs'] : array();
	if ( is_array( $tabs ) && count( $tabs ) > 0 ) {
		foreach ( $tabs as $tab_key => $tab ) {
			$tab_data = array(
				'key'          => $tab_key,
				'label'        => $tab['label'],
				'content'      => $tab['content'],
				'show_in_menu' => 'yes',
				'global'       => 'yes',
				'custom'       => 'yes',
			);

			$mapped_custom_global_tabs[] = $tab_data;
		}
		$settings['wp_travel_custom_global_tabs'] = $mapped_custom_global_tabs;
	}

	// Global FAQs.
	$faqs = array();
	if ( ! isset( $settings['global_faqs'] ) ) { // Legacy value since WP Travel 5.2.3
		if ( isset( $settings['wp_travel_utils_global_faq_answer'] ) && ! empty( $settings['wp_travel_utils_global_faq_answer'] ) ) {
			$answers   = $settings['wp_travel_utils_global_faq_answer'];
			$questions = $settings['wp_travel_utils_global_faq_question'];

			foreach ( $questions as $index => $question ) {
				$faq    = array(
					'question' => $question,
					'answer'   => $answers[ $index ],
				);
				$faqs[] = $faq;
			}
			unset( $settings['wp_travel_utils_global_faq_question'], $settings['wp_travel_utils_global_faq_answer'] );
		}
		$settings['faqs'] = $faqs;
	}
	/**
	 * @since 5.6
	 */
	$itinerary_pdf_send = get_option( 'itinerary_pdf_send_booking_mail' );
	$settings['itinerary_pdf_send_booking_mail'] = $itinerary_pdf_send ? $itinerary_pdf_send : false;
	/**
	 * Default value of one page booking
	 * @since 5.9
	 */
	// $settings['enable_ane_page_booking'] = isset( $settings['enable_ane_page_booking'] ) ? $settings['enable_ane_page_booking'] : false;

	return $settings;
}
add_filter( 'wp_travel_settings_values', 'wp_travel_utilities_settings_vlaues', 15 );

/**
 * Save Mapped settings values for React Block. [update settings]
 *
 * @param array $settings All settings.
 * @param array $settings_data All post datas.
 * @since WP Travel 4.0.7
 */
function wp_travel_utilities_save_settings_vlaues( $settings, $settings_data ) {

	$custom_global_tabs = array();
	if ( isset( $settings_data['wp_travel_custom_global_tabs'] ) && is_array( $settings_data['wp_travel_custom_global_tabs'] ) && count( $settings_data['wp_travel_custom_global_tabs'] ) > 0 ) {
		foreach ( $settings_data['wp_travel_custom_global_tabs'] as $k => $tab ) {
			$key = str_replace( ' ', '_', $tab['label'] );

			$tab_data                   = array(
				'label'        => $tab['label'],
				'content'      => $tab['content'],
				'show_in_menu' => 'yes',
				'global'       => 'yes',
				'custom'       => 'yes',
			);
			$custom_global_tabs[ $key ] = $tab_data;
		}
	}
	$settings['wp_travel_custom_global_tabs'] = $custom_global_tabs;

	// Global Faqs.
	$questions = array();
	$answers   = array();
	if ( isset( $settings_data['faqs'] ) && is_array( $settings_data['faqs'] ) && count( $settings_data['faqs'] ) > 0 ) {
		foreach ( $settings_data['faqs'] as $faq ) {
			$questions[] = $faq['question'];
			$answers[]   = $faq['answer'];
		}
	}
	$settings['wp_travel_utils_global_faq_question'] = $questions;
	$settings['wp_travel_utils_global_faq_answer']   = $answers;

	// New Global Faqs.
	$global_faqs             = isset( $settings_data['global_faqs'] ) && is_array( $settings_data['global_faqs'] ) ? $settings_data['global_faqs'] : array();
	$settings['global_faqs'] = $global_faqs;

	if ( isset( $settings_data['selected_booking_option'] ) ) {
		$settings['selected_booking_option'] = $settings_data['selected_booking_option'];
	}
	/**
	 * Set for enable and disable itinerary pdf send to cliend attached with email while booking time
	 * @since 5.6
	 * 
	 */
	$itinerary_pdf = isset( $settings_data['itinerary_pdf_send_booking_mail'] ) ? $settings_data['itinerary_pdf_send_booking_mail'] : false;
	update_option( 'itinerary_pdf_send_booking_mail', $itinerary_pdf );
	/**
	 * Register setting for one page booking
	 * @since 5.9
	 * 
	 */
	// $settings['enable_ane_page_booking'] = isset( $settings_data['enable_ane_page_booking'] ) ? $settings_data['enable_ane_page_booking'] : false;
	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_utilities_save_settings_vlaues', 15, 20 );
