var wp_travel_utilities_frame;

(function( $ ) {
	'use strict';

	 $(function() {

	 	jQuery(document).on('click', 'a.wp-travel-custom-media', function( event ){	 		
		   var $this = $(this);
		   var button_text = $this.data( 'button-change-text' );
	 	  event.preventDefault();

	 	  // Create the media frame.
	 	  wp_travel_utilities_frame = wp.media.frames.wp_travel_utilities_frame = wp.media({
	 	    title: jQuery( this ).data( 'uploader-title' ),
	 	    button: {
	 	      text: jQuery( this ).data( 'uploader-button-text' ),
	 	    },
	 	    multiple: false 
	 	  });

	 	  // When an image is selected, run a callback.
			wp_travel_utilities_frame.on( 'select', function() {
				// We set multiple to false so only get one image from the uploader
				var attachment = wp_travel_utilities_frame.state().get('selection').first().toJSON();	 
				
				var image_field = $this.siblings('.media-preview').children('.wp-travel-custom-media-id');
				image_field.val(attachment.id);

				var imgurl = attachment.url;
				if( 'undefined' != typeof attachment.sizes.thumbnail ) {
					imgurl = attachment.sizes.thumbnail.url;
				}
				var image_preview_wrap = $this.siblings('.media-preview');
				image_preview_wrap.show();
				image_preview_wrap.find('.img-preview').attr('src',imgurl);

				$this.html( button_text );
				// Hide upload button
				// $this.hide();
				return;
			});

			// Finally, open the modal
			wp_travel_utilities_frame.open();
	 	});
 	 });

})( jQuery );

