<?php
/**
 * Adds WP_Travel_Trip_Weather_Forecast_Widget widget.
 */
class WP_Travel_Trip_Weather_Forecast_Widget extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'wp_travel_trip_weather_forecast_widget_id', // Base ID
			esc_html__( 'WP Travel Trip Weather Forecast (Deprecated)', 'wp-travel-pro' ), // Name
			array( 'description' => esc_html__( 'WP Travel Trip Weather Forecast', 'wp-travel-pro' ), ) // Args
		);
	}

	/**
	 * =======================================================================================================================================================
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {
		$title     = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Weather Report', 'wp-travel-pro' );
		$city      = ! empty( $instance['city'] ) ? $instance['city'] : '';
		$country   = ! empty( $instance['country'] ) ? $instance['country'] : '';
		$temp_unit = ! empty( $instance['temp_unit'] ) ? $instance['temp_unit'] : '';
		$cnt       = ! empty( $instance['cnt'] ) ? $instance['cnt'] : 40;

		// Pass the widget data for other template functions.
		$widget_data = array(
			'instance'  => $instance,
			'city'      => $city,
			'country'   => $country,
			'temp_unit' => $temp_unit,
			'cnt'       => $cnt,
		);

		// Create global varible $widget_data.
		$GLOBALS['widget_data'] = $widget_data;

		$api_data          = wp_travel_trip_weather_forecast_templates_api( $city, $country, $temp_unit, $cnt );
		$frontend_template = wp_travel_trip_weather_forecast_templates_frontend( $widget_data );

		// Frontend rendering starts here.
		echo $args['before_widget'];

			echo $args['before_title'] . apply_filters( 'widget_title', $title ) . $args['after_title'];
			echo $frontend_template;

		echo $args['after_widget'];
	}

	/**
	 * =======================================================================================================================================================
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		$api_key  = ! empty( $settings['wp_travel_trip_weather_forecast_api_key'] ) ? $settings['wp_travel_trip_weather_forecast_api_key'] : '';
		$title    = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Weather Report', 'wp-travel-pro' );
		$city     = ! empty( $instance['city'] ) ? $instance['city'] : '';
		$country  = ! empty( $instance['country'] ) ? $instance['country'] : '';
		$cnt      = ! empty( $instance['cnt'] ) ? $instance['cnt'] : '';

		// For generating and displaying error message if api key is invalid or empty.
		$api_data      = wp_travel_trip_weather_forecast_templates_api( $city, $country, '', '' );
		$error_code    = ! empty( $api_data['cod'] ) && is_numeric( $api_data['cod'] ) ? $api_data['cod'] : '';
		$error_message = ! empty( $api_data['message'] ) && ! is_numeric( $api_data['message'] ) ? ucwords( $api_data['message'] ) : '';
		$highlight_err = ! empty( $error_message ) ? 'style="border: 1.5px solid #ff0000;"' : '';
		?>
		<p> 
			<?php echo __( 'This widget will be removed from v9.0.0. Please use "[wp_travel_trip_weather_forecast]" shortcode in replace of this widget.', 'wp-travel-pro' ); ?>
		</p>
		<?php
		if ( ! empty( $error_message ) && 401 === $error_code ) {
			echo '<p class="wp-travel-notification notification-warning notice notice-error" style="color:#ff0000;">' . esc_html( $error_message ) . '</p>';
		} else {
			?>
			<!-- Title -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'wp-travel-pro' ); ?></label>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
			</p>

			<!-- City -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'city' ) ); ?>"><?php esc_attr_e( 'City:', 'wp-travel-pro' ); ?></label>
				<input <?php echo $highlight_err; ?> placeholder="<?php echo esc_html( 'ex: Kathmandu' ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'city' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'city' ) ); ?>" type="text" value="<?php echo esc_attr( $city ); ?>" required />
			</p>

			<!-- Country -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'country' ) ); ?>"><?php esc_attr_e( 'Country:', 'wp-travel-pro' ); ?></label>
				<input placeholder="<?php echo esc_html( 'ex: NP for Nepal, GB for Britain e.t.c.' ); ?>" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'country' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'country' ) ); ?>" type="text" value="<?php echo esc_attr( $country ); ?>" required />
			</p>

			<!-- Temperature Unit: metric/imperial -->
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'temp_unit' ) ); ?>">
					<?php esc_attr_e( 'Temperature Unit:', 'wp-travel-pro' ); ?>
				</label>
				<select name=<?php echo $this->get_field_name( 'temp_unit' ); ?> id="temp_unit">
					<option <?php selected( isset( $instance['temp_unit'] ) ? $instance['temp_unit'] : '', 'metric' ); ?> value="metric">Metric ( Celcius )</option>
					<option <?php selected( isset( $instance['temp_unit'] ) ? $instance['temp_unit'] : '', 'imperial' ); ?> value="imperial">Imperial ( Fahrenheit )</option>
				</select>
			</p>

			<!-- Error message -->
			<?php
			if( ! empty( $error_message ) ) {
				echo '<p class="wp-travel-notification notification-warning notice notice-error" style="color:#ff0000;">' . esc_html( $error_message ) . '</p>';
			}
			?>

			<!-- cnt: Number of results -->
			<!-- removed/hidden as it seems unnecessary -->
			<div style="display:none;">
				<p>
					<label for="<?php echo esc_attr( $this->get_field_id( 'cnt' ) ); ?>"><?php esc_attr_e( 'Number of results:', 'wp-travel-pro' ); ?></label>
					<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'cnt' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cnt' ) ); ?>" type="number" min="1" max="40" value="<?php echo esc_attr( $cnt ); ?>">
					<p class="description"><?php echo __( 'Leave empty for default', 'wp-travel-pro' ) ?></p>
				</p>
			</div>
			<?php
		}
	}

	/**
	 * =======================================================================================================================================================
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title']     = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['city']      = ( ! empty( $new_instance['city'] ) ) ? sanitize_text_field( $new_instance['city'] ) : '';
		$instance['country']   = ( ! empty( $new_instance['country'] ) ) ? sanitize_text_field( $new_instance['country'] ) : '';
		$instance['temp_unit'] = ( ! empty( $new_instance['temp_unit'] ) ) ? ( $new_instance['temp_unit'] ) : '';
		$instance['cnt']       = ( ! empty( $new_instance['cnt'] ) ) ? ( $new_instance['cnt'] ) : '';

		return $instance;
	}

} // class WP_Travel_Trip_Weather_Forecast_Widget

// register WP_Travel_Trip_Weather_Forecast_Widget widget
function wp_travel_trip_weather_forecast_register_widget() {
	register_widget( 'WP_Travel_Trip_Weather_Forecast_Widget' );
}
add_action( 'widgets_init', 'wp_travel_trip_weather_forecast_register_widget' );