<?php
/**
 * API template function.
 *
 * @param string $city
 * @param string $country
 * @param string $temp_unit
 * @param int    $cnt
 * @return void
 */
function wp_travel_trip_weather_forecast_templates_api( $city, $country, $temp_unit, $cnt ) {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$api_key  = ! empty( $settings['wp_travel_trip_weather_forecast_api_key'] ) ? $settings['wp_travel_trip_weather_forecast_api_key'] : '';

	if ( ! empty( $api_key ) ) {
		$city      = ! empty( $city ) ? $city : 'kathmandu';
		$country   = ! empty( $country ) ? $country : 'NP';
		$temp_unit = ! empty( $temp_unit ) ? $temp_unit : 'metric';
	}

	$api_link      = 'http://api.openweathermap.org/data/2.5/forecast?q=' . $city . ',' . $country . '&appid=' . $api_key . '&units=' . $temp_unit . '&cnt=' . $cnt . '';
	$api_link_data = curl_init( $api_link );
	curl_setopt( $api_link_data, CURLOPT_RETURNTRANSFER, true );
	$json = curl_exec( $api_link_data );
	curl_close( $api_link_data );
	$api_data = json_decode( $json, true );

	return $api_data;
}

/**
 * Function to convert degrees into compass directions for winds.
 *
 * @param  string $deg numerical degree from api link.
 * @return string $cardinal Returns the directions as E W N S etc.
 */
function wp_travel_trip_weather_forecast_wind_direction( $deg ) {
	$cardinal_directions = array(
		'N'   => array( 348.75, 360 ),
		'N'   => array( 0, 11.25 ),
		'NNE' => array( 11.25, 33.75 ),
		'NE'  => array( 33.75, 56.25 ),
		'ENE' => array( 56.25, 78.75 ),
		'E'   => array( 78.75, 101.25 ),
		'ESE' => array( 101.25, 123.75 ),
		'SE'  => array( 123.75, 146.25 ),
		'SSE' => array( 146.25, 168.75 ),
		'S'   => array( 168.75, 191.25 ),
		'SSW' => array( 191.25, 213.75 ),
		'SW'  => array( 213.75, 236.25 ),
		'WSW' => array( 236.25, 258.75 ),
		'W'   => array( 258.75, 281.25 ),
		'WNW' => array( 281.25, 303.75 ),
		'NW'  => array( 303.75, 326.25 ),
		'NNW' => array( 326.25, 348.75 ),
	);
	foreach ( $cardinal_directions as $dir => $angles ) {
		if ( $deg >= $angles[0] && $deg < $angles[1] ) {
			$cardinal = $dir;
		}
	}
	$cardinal = ! empty( $cardinal ) ? $cardinal : '';
	return $cardinal;
}

/**
 * Frontend Template
 *
 * Templates function for widgets and shortcode.
 *
 * @param array $widget_data All the widget arguments passed from function widget at widgets.php.
 */
function wp_travel_trip_weather_forecast_templates_frontend( $widget_data = array() ) {
	$date_options       = '';
	$html_block         = '';
	$cel_or_fah         = '';
	$formated_time      = '';
	$formated_date      = '';
	$admin_date_format  = '';
	$wind_speed         = '';
	$weather_data_array = array();
	$dates              = array();
	$new_date_arrays    = array();

	$city          = ! empty( $widget_data['city'] ) ? $widget_data['city'] : 'kathmandu';
	$country       = ! empty( $widget_data['country'] ) ? $widget_data['country'] : 'nepal';
	$temp_unit     = ! empty( $widget_data['temp_unit'] ) ? $widget_data['temp_unit'] : 'metric';
	$cnt           = ! empty( $widget_data['cnt'] ) ? $widget_data['cnt'] : 40;
	$api_data      = wp_travel_trip_weather_forecast_templates_api( $city, $country, $temp_unit, $cnt );
	$error_message = ! empty( $api_data['message'] ) && ! is_numeric( $api_data['message'] ) ? '<p style="color: #ff0000; padding: 10px; background: #fff; border-left:4px solid #fff; border-left-color: #dc3232;"> Err: ' . ucwords( $api_data['message'] ) . '</p>' : '';

	$admin_date_format = get_option( 'date_format' );
	$api_data_list     = isset( $api_data['list'] ) ? $api_data['list'] : array();
	$city_name         = isset( $api_data['city']['name'] ) ? $api_data['city']['name'] : '';
	$country           = isset( $api_data['city']['country'] ) ? $api_data['city']['country'] : ''; // Returns Nepal as NP.

	if ( empty( $error_message ) ) {
		// Create the new array of API data according to the its date.
		foreach ( $api_data_list as $api_data_list_key => $api_data_list_value ) {
			$date_time_array            = explode( ' ', $api_data_list_value['dt_txt'] );
			$date                       = $date_time_array[0];
			$new_date_arrays[ $date ][] = $api_data_list_value;
		}

		// Create new html block according to the date wrapper div for the slider.
		foreach ( $new_date_arrays as $api_data_dates => $new_api_data_list ) {

			$html_block .= '<div id="wp_travel_trip_weather_forecast_slick_wrapper_' . $api_data_dates . '" class="wp-travel-trip-weather-forecast-slick-wrapper ' . $api_data_dates . '">';
			foreach ( $new_api_data_list as $api_data_list_value ) {
				$weather_data_array = isset( $api_data_list_value['weather'][0] ) ? $api_data_list_value['weather'][0] : array();
				$temperature_array  = isset( $api_data_list_value['main'] ) ? $api_data_list_value['main'] : array();
				$wind_speed         = ! empty( $api_data_list_value['wind']['speed'] ) ? $api_data_list_value['wind']['speed'] : 'N/A';
				$wind_deg           = ! empty( $api_data_list_value['wind']['deg'] ) ? $api_data_list_value['wind']['deg'] : '';
				$temperature        = ! empty( $temperature_array['temp'] ) ? ceil( $temperature_array['temp'] ) : 'N/A'; // Celcius (Metric) or Fahrenheit (Imperial).
				$temperature_min    = ! empty( $temperature_array['temp_min'] ) ? ceil( $temperature_array['temp_min'] ) : 'N/A'; // Celcius (Metric) or Fahrenheit (Imperial).
				$temperature_max    = ! empty( $temperature_array['temp_max'] ) ? ceil( $temperature_array['temp_max'] ) : 'N/A'; // Celcius (Metric) or Fahrenheit (Imperial).
				$temp_humidity      = ! empty( $temperature_array['humidity'] ) ? $temperature_array['humidity'] : 'N/A'; // In percent.
				$weather_data_main  = ! empty( $weather_data_array['main'] ) ? $weather_data_array['main'] : 'N/A';
				$weather_data_desc  = ! empty( $weather_data_array['description'] ) ? ucwords( $weather_data_array['description'] ) : 'N/A';
				$weather_data_icon  = ! empty( $weather_data_array['icon'] ) ? $weather_data_array['icon'] : '';
				$wind_direction     = wp_travel_trip_weather_forecast_wind_direction( $wind_deg );

				if ( 'N/A' !== $temperature || 'N/A' !== $wind_speed ) {
					$cel_or_fah      = ( 'metric' === $temp_unit ) ? '°C' : '°F';
					$wind_speed_unit = ( 'metric' === $temp_unit ) ? 'm/s' : 'mph';
				}
				$wind_direction = ( 'N/A' !== $wind_speed ) ? $wind_direction : '';

				$date_time_array = explode( ' ', $api_data_list_value['dt_txt'] );

				$date          = $date_time_array[0];
				$formated_date = strtotime( $date );
				$formated_date = date( $admin_date_format, $formated_date );
				$time          = $date_time_array[1];
				$formated_time = strtotime( $time );
				$formated_time = date( 'h:i A', $formated_time );
				$timestamp     = strtotime( $time ) + 10800; // 3 hours = 10800 secs.
				$added_time    = date( 'h:i A', $timestamp );
				if ( ! in_array( $date, $dates, true ) ) {
					$date_options .= '<option value="' . $date . '">' . $formated_date . '</option>';
					$dates[]       = $date;
				}

				// Html block that is repeated according to the results.
				$html_block .=
				'<div class="wp-travel-trip-weather-forecast-weather-wrapper ' . $date . '" data-attribute-date="' . $date . '">
					<div class="wp-travel-trip-weather-forecast-city">
						<strong>' . $city_name . ',' . $country . '</strong>
						<div class="wp-travel-trip-weather-forecast-main-time">' . $formated_time . '</div>
					</div>
					<div class="wp-travel-trip-weather-forecast-icon-temp-block-wrapper">
						<div class="wp-travel-trip-weather-forecast-temperature">
							<strong>' . $temperature . ' ' . $cel_or_fah . '</strong>
							<div class="wp-travel-trip-weather-forecast-time">' . $formated_time . ' - ' . $added_time . '</div>
						<div class="wp-travel-trip-weather-forecast-date">' . $formated_date . '</div>
						</div>
						<div class="wp-travel-trip-weather-forecast-weather-icon" title="' . $weather_data_desc . '">
							<img src="http://openweathermap.org/img/w/' . $weather_data_icon . '.png" alt="' . $weather_data_desc . '">
						</div>
						<div class="wp-travel-trip-weather-forecast-info-block">
							<div class="wp-travel-trip-weather-forecast-weather-description">' . $weather_data_desc . '</div>
							<div class="wp-travel-trip-weather-forecast-wind">Wind: ' . $wind_speed . ' ' . $wind_speed_unit . ' ' . $wind_direction . '</div>
							<div class="wp-travel-trip-weather-forecast-temperature-humidity">Humidity: ' . $temp_humidity . '%</div>
							<div class="wp-travel-trip-weather-forecast-temperature-min">Min Temp: ' . $temperature_min . ' ' . $cel_or_fah . '</div>
							<div class="wp-travel-trip-weather-forecast-temperature-max">Max Temp: ' . $temperature_max . ' ' . $cel_or_fah . '</div>
						</div>
					</div>
				</div>';
			}
			$html_block .= '</div>'; // Div closed for class wp-travel-trip-weather-forecast-slick-wrapper.
		}

		ob_start();
		?>
		<div class="wp-travel-trip-weather-forecast-main-content-wrapper">
			<div class="wp-travel-trip-weather-forecast-date-select">
				<select name="wp_travel_trip_weather_forecast_date_select" class="wp_travel_trip_weather_forecast_date_select">
					<?php echo $date_options; ?>
				</select>
			</div>
			<?php echo  $html_block; ?>
		</div>
		<?php
		$contents = ob_get_contents();
		ob_end_clean();
	} else {
		$contents = $error_message;
	}
	return $contents;
}

