<?php
/**
 * Function for shortcode.
 *
 * Primary shortcode [wp_travel_trip_weather_forecast]
 *
 * Shortcode with all important attrs [wp_travel_trip_weather_forecast title="title" city="city_name" country="country_name" temp_unit="metric_or_imperial"]
 */
function wp_travel_trip_weather_forecast_shortcode( $atts = [], $content = null, $tag = '' ) {
	$shortcode_content = '';
	$api_data          = '';
	$city              = '';
	$country           = '';
	$api_key           = '';
	$temp_unit         = '';
	$cnt               = '';
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$api_key           = ! empty( $settings['wp_travel_trip_weather_forecast_api_key'] ) ? $settings['wp_travel_trip_weather_forecast_api_key'] : '';

	// normalize attribute keys, lowercase.
	$atts = array_change_key_case( (array) $atts, CASE_LOWER );

	// override default attributes with user attributes.
	$shortcode_atts = shortcode_atts(
		array(
			'title'     => 'Weather Report',
			'city'      => 'Kathmandu',
			'country'   => 'nepal',
			'temp_unit' => 'metric',
			'cnt'       => 40,
		),
		$atts, $tag
	);

	$title      = ! empty( $shortcode_atts['title'] ) ? $shortcode_atts['title'] : 'Weather Report'; // Fallback title "Weather Report".
	// $city      = $shortcode_atts['city'];
	// $country   = $shortcode_atts['country'];
	// $temp_unit = $shortcode_atts['temp_unit'];
	// $cnt       = $shortcode_atts['cnt'];
	// $api_data  = wp_travel_trip_weather_forecast_templates_api( $city, $country, $temp_unit, $cnt );

	$shortcode_content  = '<div class="wp-travel-trip-weather-forecast-shortcode-wrapper">';
	$shortcode_content .= '<h2 class="wp-travel-trip-weather-forecast-shortcode-h2">' . esc_html( $title ) . '</h2>';
	$shortcode_content .= wp_travel_trip_weather_forecast_templates_frontend( $shortcode_atts );
	$shortcode_content .= '</div>';

	return $shortcode_content;
}
add_shortcode( 'wp_travel_trip_weather_forecast', 'wp_travel_trip_weather_forecast_shortcode' );
