<?php
/**
 * @package wp-travel-travel-guide
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Travel_Guide_Core' ) ) :

	class WP_Travel_Travel_Guide_Core {

		public static $abspath;

		public static function init() {
			/**
			 * Defining Plugin Directory Url
			 */
			define( 'WP_Travel_Travel_Guide_Core_URL', plugin_dir_url( __FILE__ ) );

			self::$abspath = dirname( __FILE__ ) . '/';

			/**
			 * Defining files in array
			 */
			$files = array(
				'inc/role.php',
				'inc/database.php',
				'inc/api/base.php',
				'inc/api/api.php',
				'inc/script.php',
				'inc/core.php',
				'inc/guide-template/guide-controller.php',
			);

			/**
			 * Includes all files from array
			 */
			foreach ( $files as $file ) {
				include sprintf( '%s' . $file, self::$abspath );
			}

		}
	}

endif;
