<?php 
/**
 * Handle all the scripts and styles here
 * 
 * @see https://developer.wordpress.org/reference/hooks/admin_enqueue_scripts/
 * @since WP Travel Travel Guide 1.0
 */

if( ! class_exists( 'WP_Travel_Travel_Guide_Script' ) ){

	class WP_Travel_Travel_Guide_Script{


		/**
		 * The single instance of the class.
		 *
		 * @var string $_instance
		 */
		protected static $instance = null;


		/**
		 * Module Name.
		 *
		 * @var string
		 */
		protected $menu_slug = 'travel-guide';


		/**
		 * Main WP_Travel_travel_guide Instance.
		 * Ensures only one instance of WP_Travel_travel_guide is loaded or can be loaded.
		 *
		 * @return WP_Travel_travel_guide - Main instance.
		 */
		public static function get_instance() {
		    if ( ! self::$instance ) {
		        self::$instance = new self();
		    }
		    return self::$instance;
		}


		/**
		 * Constructor.
		 */
		public function __construct(){
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'front_scripts' ) );
		}


		/**
		 * Enqueue Admin Script 
		 */
		public function admin_scripts( ){

			require_once( ABSPATH . 'wp-admin/includes/screen.php' );
			$screen = get_current_screen();

			if ( 'dashboard' !== $screen->id ) {
				wp_enqueue_media();

				$this->enqueue(array(
					'handle' => 'wp-travel-travel-guide',
					'script' => 'app/build/wp-travel-travel-guide.js',
					'deps'   => array( 'wp-i18n', 'wp-dom-ready', 'wp-data', 'wp-element', 'wp-editor', 'wp-travel-admin-script', 'wp-travel-admin-trip-options' )
				));

				$this->enqueue(array(
					'handle' => 'wp-travel-travel-guide',
					'style'  => 'app/build/wp-travel-travel-guide.css',
				));


				$trip_list = array();

				$args = array(
		            'post_type' => 'itineraries',
		            'numberposts' => -1, 
		        );
		         

				$all_trip = get_posts( $args );

				foreach ( $all_trip as $trip ) {
					$trip_data['value']    = $trip->ID;
	                $trip_data['label']    = $trip->post_title;
	                
	                // Push to the main array.
	                array_push( $trip_list, $trip_data );

				}

				wp_localize_script( 'wp-travel-travel-guide', 'WTTG', array(
					'rest_url' => get_rest_url(),
					'nonce'    => wp_create_nonce( 'wp_rest' ),
					'trip_list'	=> $trip_list,
					'plugin_url' => WP_Travel_Travel_Guide_Core_URL
				));
			}
							
		}


		/**
		 * Enqueue Front Script 
		 */
		public function front_scripts( ){ 

			$this->enqueue(array(
				'handle' => 'wp-travel-travel-guide-front-js',
				'script' => 'js/front-script.js',
				'deps'   => array( 'jquery' ),
			));

			global $post;
			$post_id = isset( $post->ID ) ? $post->ID : '';	

			$this->enqueue(array(
				'handle' => 'wp-travel-travel-guide-single-trip-js',
				'script' => 'app/build/wp-travel-travel-guide-front.js',
				'deps'   => array( 'wp-i18n', 'wp-dom-ready', 'wp-data', 'wp-element' )
				// 'deps'   => array( 'wp-i18n', 'wp-dom-ready', 'wp-data', 'wp-element', 'wp-editor' )
			));

			wp_localize_script( 'wp-travel-travel-guide-single-trip-js', 'WTTGF', array(
				'trip_id'	=> $post_id,
			));

			$this->enqueue(array(
				'handle' => 'wp-travel-travel-guide-front-style',
				'style'  => 'css/front-style.css',
			));
		}


		/**
		 * Script enqueue  controller
		 */
		public function enqueue( $args ){


			$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

			if( isset( $args[ "style" ] ) ){
				wp_enqueue_style(
					$args[ 'handle' ],
					WP_Travel_Travel_Guide_Core_URL . $args[ 'style' ]
				);
			}else{
				wp_enqueue_script(
					$args[ 'handle' ],
					WP_Travel_Travel_Guide_Core_URL . $args[ 'script' ],
					$args[ 'deps' ], 
					'7.4.0',
					false
				);
			}
		}
	}
	
	WP_Travel_Travel_Guide_Script::get_instance();
}


