<?php
/**
 * Front End Output Class for Tour Extras.
 *
 * @package WP_Travel_Tour_Extras
 */
class Wp_Travel_Tour_Extras_Frontend {

	public function __construct() {
		// Init Class.
		$this->init();

	}
	/**
	 * Init Hooks
	 *
	 * @return void
	 */
	public function init() {

		add_action( 'wp_travel_extras_pro_extras_layout', array( $this, 'tour_extras_frontend' ), 10, 4 );
		add_action( 'wp_travel_tour_extras_cart_block', array( $this, 'wp_travel_tour_extras_cart_block' ), 10, 3 );
		add_action( 'wp_travel_tour_extras_mini_cart_block', array( $this, 'wp_travel_tour_extras_mini_cart_block' ), 10, 4 );
		// Only for standard paypal.
		add_action( 'wp_travel_tour_extra_paypal_args', array( $this, 'standard_paypal_args' ), 10, 4 );

	}
	/**
	 * Layout for frontend tour extras ( pro ) options.
	 *
	 * @param array $trip_extras
	 * @return void
	 */
	public function tour_extras_frontend( $trip_extras, $price_key, $trip_date = false, $trip_id = '' ) {
		/**
		 * Tour Extras Front End extras HTML
		 */
		?>
		<div class="wp_travel_tour_extras">
			<h3>
			<?php
				$trip_extras_heading = apply_filters( 'wp_travel_trip_extras_heading', __( 'Trip Extras:', 'wp-travel-pro' ) );
				echo esc_html( $trip_extras_heading );
			?>
			</h3>
			<div class="wp_travel_tour_extras_content">
				<?php
				foreach ( $trip_extras as $key => $extra ) :

					$trip_extras_data = get_post_meta( $extra, 'wp_travel_tour_extras_metas', true );

					$description = isset( $trip_extras_data['extras_item_description'] ) && ! empty( $trip_extras_data['extras_item_description'] ) ? $trip_extras_data['extras_item_description'] : false;
					$image       = has_post_thumbnail( $extra ) ? get_the_post_thumbnail_url( $extra, 'thumbnail' ) : false;

					$price            = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
					$sale_price       = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;
					$item_is_required = isset( $trip_extras_data['extras_is_required'] ) && ! empty( $trip_extras_data['extras_is_required'] ) ? $trip_extras_data['extras_is_required'] : ''; // @since 1.1.2
					$unit             = isset( $trip_extras_data['extras_item_unit'] ) && ! empty( $trip_extras_data['extras_item_unit'] ) ? $trip_extras_data['extras_item_unit'] : false;

					// Filters for custom price and sales prices according to trips.
					$price = apply_filters( 'wp_travel_trip_extras_custom_prices', $price, $extra, $trip_id );
					$price = isset( $price ) && ! empty( $price ) ? $price : false;

					$sale_price = apply_filters( 'wp_travel_trip_extras_custom_sale_prices', $sale_price, $extra, $trip_id );
					$sale_price = isset( $sale_price ) && ! empty( $sale_price ) ? $sale_price : false;
					// Filters for custom price and sales prices according to trips.
					$parent_id = sprintf( 'trip_extra_%s_%s_%s', esc_attr( $extra ), esc_attr( $price_key ), esc_attr( $trip_date ) );

					/**
					 * Modification for the label and checkbox attrs if the extras item is required.
					 *
					 * @since 1.1.2
					 */
					$checked       = ! empty( $item_is_required ) ? 'checked' : '';
					$parent_id     = ( 'checked' === $checked ) ? '' : $parent_id;
					$item_required = ! empty( $item_is_required ) ? __( '*', 'wp-travel-pro' ) : '';
					?>
					<div class="wp_travel_tour_extras_option_single" id="wp_travel_tour_extras_option_single_<?php echo esc_attr( $extra ); ?>">
					<div class="wp_travel_tour_extras_option_single_content">
						<div class="wp_travel_tour_extras_option_top">
							<input data-multiple="true" <?php echo esc_attr( $checked ); ?> name="wp_travel_trip_extras[id]" id="<?php echo esc_attr( $parent_id ); ?>" type="checkbox" value="<?php echo esc_attr( $extra ); ?>" >
							<label for="<?php echo esc_attr( $parent_id ); ?>" class="check_icon"></label>
							<div class="wp_travel_tour_extras_option_label">
								<div class="wp_travel_tour_extras_title">
									<h5><?php echo esc_html( get_the_title( $extra ) ); ?><?php echo esc_html( $item_required ); ?></h5>
								</div>
								<?php if ( $price || $sale_price ) : ?>
									<div class="wp_travel_tour_extras_price">
										<?php
										if ( $sale_price ) :
											?>
											<del>
											<?php echo esc_html( wp_travel_tour_extras_formated_price( $price ) ); ?>
											</del>
											<ins>
											<?php echo esc_html( wp_travel_tour_extras_formated_price( $sale_price ) ); ?> / <?php echo esc_html( $unit ); ?>
											</ins>
										<?php else : ?>
											<ins>
												<?php echo esc_html( wp_travel_tour_extras_formated_price( $price ) ); ?> / <?php echo esc_html( $unit ); ?>
											</ins>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if ( $description ) : ?>
									<i class="wt-icon wt-icon-angle-down wp_travel_tour_extras_toggler"></i>
								<?php endif; ?>
							</div>
						</div>
						<div class="wp_travel_tour_extras_option_bottom">
							<div class="d-flex">
								<?php if ( $image ) : ?>
									<figure class="wp_travel_tour_extras_image"><img src="<?php echo esc_url( $image ); ?>"></figure>
								<?php endif; ?>
								<div class="wp_travel_tour_extras_option_bottom_right">
									<?php if ( $description ) : ?>
										<div class="wp_travel_tour_extras_description">
											<p><?php echo esc_html( $description ); ?></p>
										</div>
									<?php endif; ?>
									<div class="wp_travel_tour_extras_quantity">
										<input data-dependent="true" data-multiple="true" data-parent="<?php echo esc_attr( $parent_id ); ?>" name="wp_travel_trip_extras[qty]" min="1" placeholder="<?php printf( '%s(s)', esc_attr( $unit ) ); ?>" type="number">
									</div>
									<a href="<?php echo esc_url( get_the_permalink( $extra ) ); ?>" class="btn btn-primary"><?php esc_html_e( 'Learn More', 'wp-travel-pro' ); ?></a>
								</div>

							</div>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
			</div>
		</div>
		<?php

	}

	/**
	 * Cart Block Layout for trip extras
	 *
	 * @param array $trip_extras
	 * @return void
	*/
	public function wp_travel_tour_extras_cart_block( $trip_extras, $cart_id, $trip_id ) {
		if ( ! isset( $trip_extras['id'] ) ) {
			return;
		}

		if ( ! is_array( $trip_extras['id'] ) || empty( $trip_extras['id'] ) ) {
			return;
		}

		/**
		 * Tour Extras Front End extras HTML
		 */
		?>
		<div class="wp_travel_tour_extras">
			<h3><?php esc_html_e( 'Extras:', 'wp-travel-pro' ); ?></h3>
			<div class="wp_travel_tour_extras_content">
				<?php
				foreach ( $trip_extras['id'] as $key => $id ) :

					$trip_extras_data = get_post_meta( $id, 'wp_travel_tour_extras_metas', true );

					$price      = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
					$sale_price = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;
					$unit       = isset( $trip_extras_data['extras_item_unit'] ) && ! empty( $trip_extras_data['extras_item_unit'] ) ? $trip_extras_data['extras_item_unit'] : false;

					// Filters for custom price and sales prices according to trips.
					$price = apply_filters( 'wp_travel_trip_extras_custom_prices', $price, $id, $trip_id );
					$price = isset( $price ) && ! empty( $price ) ? $price : false;
					$sale_price = apply_filters( 'wp_travel_trip_extras_custom_sale_prices', $sale_price, $id, $trip_id );
					$sale_price = isset( $sale_price ) && ! empty( $sale_price ) ? $sale_price : false;
					// Filters for custom price and sales prices according to trips.

					if ( $sale_price ) {
						$price = $sale_price;
					}

					$qty = isset( $trip_extras['qty'][ $key ] ) && ! empty( $trip_extras['qty'][ $key ] ) ? $trip_extras['qty'][ $key ] : 1;

					$total = $price * $qty;

					?>
					<div class="wp_travel_tour_extras_option_single"><!-- Loop This -->
						<div class="wp_travel_tour_extras_option_single_content">
							<div class="wp_travel_tour_extras_option_top">
								<a data-extra-id="<?php echo esc_attr( $id ); ?>" data-cart-id="<?php echo esc_attr( $cart_id ); ?>" class="wp-travel-remove-cart-extra check_icon" href="#"></a>
								<div class="wp_travel_tour_extras_option_label">
									<div class="wp_travel_tour_extras_title">
										<h5><?php echo esc_html( get_the_title( $id ) ); ?></h5>
									</div>
									<div class="wp_travel_tour_extras_price">
										<span><?php esc_html_e( 'Price:', 'wp-travel-pro' ); ?></span>
										<ins><?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $price ) ); ?></ins>
									</div>
									<div class="wp_travel_tour_extras_quantity">
										<span><?php esc_html_e( 'Qty:', 'wp-travel-pro' ); ?></span>
										<input class="wp-travel-tour-extras-qty" min="1" step="1" name="extra_qty" value="<?php echo esc_attr( $qty ); ?>" type="number">
										<input type="hidden" name="extra_id" value="<?php echo esc_attr( $id ); ?>">
									</div>
									<div class="wp_travel_tour_extras_total_price">
										<span><?php esc_html_e( 'Total:', 'wp-travel-pro' ); ?></span>
										<strong><?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $total ) ); ?></strong>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<?php

	}

	/**
	 * Cart Block Layout for trip extras
	 *
	 * @param array $trip_extras
	 * @return void
	 */
	public function wp_travel_tour_extras_mini_cart_block( $trip_extras, $cart_id, $trip_id, $price_key ) {
		$trip_extras = (array) $trip_extras;
		if ( ! isset( $trip_extras['id'] ) ) {
			return;
		}

		if ( ! is_array( $trip_extras['id'] ) || empty( $trip_extras['id'] ) ) {
			return;
		}

			/**
			 * Tour Extras Front End Mini Cart HTML
			 */
		?>
					<?php
					foreach ( $trip_extras['id'] as $key => $id ) :

						$trip_extras_data = get_post_meta( $id, 'wp_travel_tour_extras_metas', true );

						$price      = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
						$sale_price = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;
						$unit       = isset( $trip_extras_data['extras_item_unit'] ) && ! empty( $trip_extras_data['extras_item_unit'] ) ? $trip_extras_data['extras_item_unit'] : false;

						// Filter to add the custom price for the tour extras.
						$price      = apply_filters( 'wp_travel_trip_extras_custom_prices', $price, $id, $trip_id );
						$price      = isset( $price ) && ! empty( $price ) ? $price : false;
						$sale_price = apply_filters( 'wp_travel_trip_extras_custom_sale_prices', $sale_price, $id, $trip_id );
						$sale_price = isset( $sale_price ) && ! empty( $sale_price ) ? $sale_price : false;
						// Filter to add the custom price for the tour extras.

						if ( $sale_price ) {
							$price = $sale_price;
						}

						$qty = isset( $trip_extras['qty'][ $key ] ) && ! empty( $trip_extras['qty'][ $key ] ) ? $trip_extras['qty'][ $key ] : 1;

						$total         = $price * $qty;
						$total_partial = $total;

						// Trip extra partial calculation.
						if ( function_exists( 'wp_travel_tour_extras_enable_partial' ) && wp_travel_tour_extras_enable_partial( $trip_id, $price_key ) ) {
							$payout_percent = wptravel_get_payout_percent( $trip_id );
							if ( $payout_percent > 0 && $total > 0 ) {
								$total_partial = ( $total * $payout_percent ) / 100;
							}
						}
						?>

						<tr class="cart_item">
							<td class="product-name">
								<?php echo esc_html( get_the_title( $id ) ); ?> <strong class="product-quantity">× <span class="wp-travel-cart-pax"><?php echo esc_attr( $qty ); ?></span> <?php echo esc_html( $unit ); ?> </strong>
							</td>
							<td class="product-total text-right">
								<span class="product-total-price amount"><?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $total ) ); ?></span>
							</td>
							<td style="display: none;" class="product-total text-right f-partial-payment">
								<span class="product-total-price amount"><?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $total_partial ) ); ?></span>
							</td>
						</tr>

					<?php endforeach; ?>
			<?php

	}

	/**
	 * Support for the standard paypal.
	 *
	 * @param array $args
	 * @param array $item
	 * @param string $cart_id
	 * @param int $agrs_index
	 * @return array $args
	 */
	public function standard_paypal_args( $args, $item, $cart_id, $agrs_index ) {

		$trip_extras = isset( $item['trip_extras'] ) ? $item['trip_extras'] : array();

		if ( is_array( $trip_extras ) && count( $trip_extras ) > 0 ) {

			if ( ! isset( $trip_extras['id'] ) ) {
				return;
			}

			if ( ! is_array( $trip_extras['id'] ) || empty( $trip_extras['id'] ) ) {
				return;
			}

			foreach ( $trip_extras['id'] as $key => $id ) :
				$trip_extras_data = get_post_meta( $id, 'wp_travel_tour_extras_metas', true );

				$price      = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
				$sale_price = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;
				$unit       = isset( $trip_extras_data['extras_item_unit'] ) && ! empty( $trip_extras_data['extras_item_unit'] ) ? $trip_extras_data['extras_item_unit'] : false;

				if ( $sale_price ) {
					$price = $sale_price;
				}

				$qty = isset( $trip_extras['qty'][ $key ] ) && ! empty( $trip_extras['qty'][ $key ] ) ? $trip_extras['qty'][ $key ] : 1;

				if( isset( $item['partial_payout_figure'] ) && !empty( $item['partial_payout_figure'] ) && strpos($args['return'], 'payment=partial') ){
					$price = ($item['partial_payout_figure'] / 100) * $price;
				}

				/**
				 * If you want to modify or add args below.
				 * Use this filter: wp_travel_tour_extra_paypal_args OR
				 * WP Travel default filter: wp_travel_paypal_args
				 * These are present in: .\wp-content\plugins\wp-travel\inc\gateways\standard-paypal\class-wp-travel-gateway-paypal-request.php
				 */
				$agrs_index ++;

				$args[ 'item_name_' . $agrs_index ] = get_the_title( $id );

				$args[ 'quantity_' . $agrs_index ] = $qty;

				$args[ 'amount_' . $agrs_index ] = $price;
			endforeach;

		}
		return array( 
			'args' => $args,
			'count' => $agrs_index 
		);
	}


}

// Run the Class. | Construct.
new Wp_Travel_Tour_Extras_Frontend();
