<?php
/**
 * Tour Extras Post type Class
 * @package WP_Travel_Tour_Extras
 */
class WP_Travel_Tour_Extras_Post_Filters {

	/**
	 * Private var $post_type.
	 *
	 * @var string
	 */
	private static $post_type = 'tour-extras';

	public function __construct() {
		// Init class.
		$this->init();
	}

	/**
	 * Init.
	 *
	 * @return void
	 */
	public function init() {
		add_action( 'wp_travel_extras_pro_single_options', array( $this, 'wp_travel_extras_pro_option_fields' ) );
		// Filter tour extras tabs.
		// Add Content for gallery tab.
		add_action( 'wptravel_tour_extras_gallery_tab_content', array( $this, 'tour_extras_gallery_tab_callback' ) );

		add_action( 'save_post', array( $this, 'save_additional_metas' ) );
		add_filter( 'wp_travel_tour_extras_localize_gallery_data', array( $this, 'wp_travel_tour_extras_localize_gallery' ) );
	}

	/**
	 * Callback Function for Tour Extras Gallery tab.
	 *
	 * @param  string $tab tab name 'Gallery'.
	 * @return Mixed
	 */
	public function tour_extras_gallery_tab_callback() {
		global $post;
		$post_id = $post->ID;

		$trip_extras_data = get_post_meta( $post_id, 'wp_travel_extras_gallery_ids', true );
		?>
		<div class="wp-travel-post-tab-content-section">
			<?php
				WPTravel()->uploader->load(); ?>
					<script type="text/javascript">
						var post_id = <?php echo esc_html( $post->ID ); ?>, shortform = 3;
					</script>
				<div class="wp-travel-open-uploaded-images">
					<h3 class="wp-travel-post-tab-content-section-title"><?php esc_html_e( 'Gallery images', 'wp-travel-pro' ); ?></h3>
					<ul></ul>
				</div>
			<input type="hidden" name="wp_travel_extras_gallery_ids" id="wp_travel_tour_extras_gallery_ids" value="" />
			<?php wp_nonce_field( 'wp_travel_tour_extras_save_data_process', 'wp_travel_tour_extras_save_data' ); ?>
		</div>
	<?php
	}
	/**
	 * Save Additional Tour Extras Meta
	 *
	 * @param int $post_id
	 * @return void
	 */
	public function save_additional_metas( $post_id ) {

		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}
		// If this is just a revision, don't send the email.
		if ( wp_is_post_revision( $post_id ) ) {
			return;
		}

		$post_type = get_post_type( $post_id );


		// If this isn't a WP_TRAVEL_POST_TYPE post, don't update it.
		if ( 'tour-extras' !== $post_type ) {
			return;
		}

		remove_action( 'save_post', array( $this, 'save_additional_metas' ) );
		if ( ! isset( $_POST['wp_travel_tour_extras_save_data'] ) ) {
			return;
		}
		if ( ! wp_verify_nonce( $_POST['wp_travel_tour_extras_save_data'], 'wp_travel_tour_extras_save_data_process' ) ) {
			return;
		}

		$wp_travel_extras_gallery_ids = array();
		if ( isset( $_POST['wp_travel_extras_gallery_ids'] ) && ! empty( $_POST['wp_travel_extras_gallery_ids'] ) ) {
			$wp_travel_extras_gallery_ids = explode( ',', $_POST['wp_travel_extras_gallery_ids'] );
		}
		update_post_meta( $post_id, 'wp_travel_extras_gallery_ids', $wp_travel_extras_gallery_ids );

	}

	public function wp_travel_tour_extras_localize_gallery( $data ) {

		global $post;
		if ( ! $post ) {
			return;
		}
		$gallery_ids = get_post_meta( $post->ID, 'wp_travel_extras_gallery_ids', true );
		if ( false !== $gallery_ids && ! empty( $gallery_ids ) ) {
			$gallery_data = array();
			$i = 0;
			$_thumbnail_id = get_post_meta( $post->ID, '_thumbnail_id', true );
			foreach ( $gallery_ids as $id ) {
				if ( 0 === $i && '' === $_thumbnail_id ) {
					$_thumbnail_id = $id;
				}
				$gallery_data[ $i ]['id'] = $id;
				$gallery_data[ $i ]['url'] = wp_get_attachment_thumb_url( $id );
				$i++;
			}
			$data['gallery_data'] = $gallery_data;
			$data['_thumbnail_id'] = $_thumbnail_id;
		}
		return $data;

	}

	/**
	 * WP Travel Tour Extras Pro fields.
	 *
	 * @return void
	 */
	public function wp_travel_extras_pro_option_fields() {

	global $post;
	$post_id = $post->ID;

	$trip_extras_data = get_post_meta( $post_id, 'wp_travel_tour_extras_metas', true );

	if ( ! $trip_extras_data )
		$trip_extras_data = array();

	$item_price       = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price']  : '';
	$item_sale_price  = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price']  : '';
	$item_is_required = isset( $trip_extras_data['extras_is_required'] ) && ! empty( $trip_extras_data['extras_is_required'] ) ? $trip_extras_data['extras_is_required']  : ''; // @since 1.1.2
	$item_unit        = isset( $trip_extras_data['extras_item_unit'] ) && ! empty( $trip_extras_data['extras_item_unit'] ) ? $trip_extras_data['extras_item_unit']  : 'unit';
	
	if( !class_exists( 'WP_Travel_Trip_Extras_Inventory' ) ){
		$item_quantity        = isset( $trip_extras_data['extras_item_quantity'] ) && ! empty( $trip_extras_data['extras_item_quantity'] ) ? $trip_extras_data['extras_item_quantity']  : -1;
	}
	// $item_quantity_in_used        = isset( $trip_extras_data['extras_item_quantity_in_used'] ) && ! empty( $trip_extras_data['extras_item_quantity_in_used'] ) ? $trip_extras_data['extras_item_quantity_in_used']  : 0;

		?>
		<tr>
			<td><label for="extra-item-price"><?php esc_html_e( 'Price', 'wp-travel-pro' ); ?></label>
				<span class="tooltip-area" title="<?php esc_html_e( 'Item Price', 'wp-travel-pro' ); ?>">
					<i class="wt-icon wt-icon-question-circle" aria-hidden="true"></i>
				</span>
			</td>
			<td>
				<span id="coupon-currency-symbol" class="wp-travel-currency-symbol">
						<?php 
						if ( function_exists( 'wptravel_get_currency_symbol' ) ) {
							echo wptravel_get_currency_symbol(); // @phpcs:ignore
						} else {
							echo wp_travel_get_currency_symbol(); // @phpcs:ignore
						}
						?>
				</span>
				<input type="number" min="0" step="0.01" id="extra-item-price" name="wp_travel_extras[extras_item_price]" placeholder="<?php echo esc_attr__( 'Price', 'wp-travel-pro' ); ?>" value="<?php echo esc_attr( $item_price ); ?>">
			</td>
		</tr>
		<tr>
			<td><label for="extra-item-sale-price"><?php esc_html_e( 'Sale Price', 'wp-travel-pro' ); ?></label>
				<span class="tooltip-area" title="<?php esc_html_e( 'Sale Price(Leave Blank to disable sale)', 'wp-travel-pro' ); ?>">
					<i class="wt-icon wt-icon-question-circle" aria-hidden="true"></i>
				</span>
			</td>
			<td>
				<span id="coupon-currency-symbol" class="wp-travel-currency-symbol">
					<?php 
					if ( function_exists( 'wptravel_get_currency_symbol' ) ) {
						echo wptravel_get_currency_symbol(); // @phpcs:ignore
					} else {
						echo wp_travel_get_currency_symbol(); // @phpcs:ignore
					}
					?>
				</span>
				<input type="number" min="0" step="0.01" max="<?php echo esc_attr( $item_price ); ?>" id="extra-item-sale-price" name="wp_travel_extras[extras_item_sale_price]" placeholder="<?php echo esc_attr__( 'Sale Price', 'wp-travel-pro' ); ?>" value="<?php echo esc_attr( $item_sale_price ); ?>">
			</td>
		</tr>

		<!-- Added since v1.1.2 -->
		<tr>
			<td><label for="extra-item-is-required"><?php esc_html_e( 'Required?', 'wp-travel-pro' ); ?></label>
			</td>
			<td>
				<input type="checkbox" <?php echo ! empty( $item_is_required ) ? esc_attr('checked') : ''; ?> id="extra-item-is-required" name="wp_travel_extras[extras_is_required]" value="yes">
			</td>
		</tr>

		<tr>
			<td><label for="extra-item-is-required"><?php esc_html_e( 'Unit Label', 'wp-travel-pro' ); ?></label>
			</td>
			<td>
				<input type="text" name="wp_travel_extras[extras_item_unit]" value="<?php echo esc_attr( $item_unit   ); ?>">		
			</td>
		</tr>
		
		<?php if( !class_exists( 'WP_Travel_Trip_Extras_Inventory' ) ): ?>
		<tr>
			<td><label for="extra-item-is-required"><?php esc_html_e( 'Limit Quantity', 'wp-travel-pro' ); ?></label>
			</td>
			<td>
				<input type="text" name="wp_travel_extras[extras_item_quantity]" value="<?php echo esc_attr( $item_quantity ); ?>"><br>	<br>	
				<?php echo esc_html( 'Note: For unlimited, set value -1', 'wp-travel-pro' ); ?>
			</td>
		</tr>
		<?php endif; ?>


		<?php do_action( 'wp_travel_pro_extras_after_required_field', $post_id ); ?>


		<?php
	}
}

new WP_Travel_Tour_Extras_Post_Filters();
