# Merchants

```php
$merchantsApi = $client->getMerchantsApi();
```

## Class Name

`MerchantsApi`

## Methods

* [List Merchants](/doc/apis/merchants.md#list-merchants)
* [Retrieve Merchant](/doc/apis/merchants.md#retrieve-merchant)


# List Merchants

Returns `Merchant` information for a given access token.

If you don't know a `Merchant` ID, you can use this endpoint to retrieve the merchant ID for an access token.
You can specify your personal access token to get your own merchant information or specify an OAuth token
to get the information for the  merchant that granted you access.

If you know the merchant ID, you can also use the [RetrieveMerchant](/doc/apis/merchants.md#retrieve-merchant)
endpoint to get the merchant information.

```php
function listMerchants(?int $cursor = null): ApiResponse
```

## Parameters

| Parameter | Type | Tags | Description |
|  --- | --- | --- | --- |
| `cursor` | `?int` | Query, Optional | The cursor generated by the previous response. |

## Response Type

[`ListMerchantsResponse`](/doc/models/list-merchants-response.md)

## Example Usage

```php
$cursor = 210;

$apiResponse = $merchantsApi->listMerchants($cursor);

if ($apiResponse->isSuccess()) {
    $listMerchantsResponse = $apiResponse->getResult();
} else {
    $errors = $apiResponse->getErrors();
}

// Get more response info...
// $statusCode = $apiResponse->getStatusCode();
// $headers = $apiResponse->getHeaders();
```


# Retrieve Merchant

Retrieve a `Merchant` object for the given `merchant_id`.

```php
function retrieveMerchant(string $merchantId): ApiResponse
```

## Parameters

| Parameter | Type | Tags | Description |
|  --- | --- | --- | --- |
| `merchantId` | `string` | Template, Required | The ID of the merchant to retrieve. If the string "me" is supplied as the ID,<br>then retrieve the merchant that is currently accessible to this call. |

## Response Type

[`RetrieveMerchantResponse`](/doc/models/retrieve-merchant-response.md)

## Example Usage

```php
$merchantId = 'merchant_id0';

$apiResponse = $merchantsApi->retrieveMerchant($merchantId);

if ($apiResponse->isSuccess()) {
    $retrieveMerchantResponse = $apiResponse->getResult();
} else {
    $errors = $apiResponse->getErrors();
}

// Get more response info...
// $statusCode = $apiResponse->getStatusCode();
// $headers = $apiResponse->getHeaders();
```

