<?php
/**
 * Squareup Fucntions.
 *
 * @package wp-travel-squareup-checkout/inc/
 */


/**
 * Alter the booking travel message as payment has already been done.
 *
 * @param string $message Set trip booked message.
 * @return string
 */
function wptravel_square_booking_message( $message ) {

	unset( $_SESSION['used-wp-travel-squareup-checkout'] );

	$message = esc_html__( "We've received your booking and payment details. We'll contact you soon.", 'wp-travel-pro' );

	return $message;

}


/**
 * With decimal currencies like USD
 * $5 must be multiplied by 100
 * to give a cent amount of "500".
 * But for zero-decimal currencies (like JPY),
 * ¥500 is just ¥500.
 *
 * The following currencies should be excluded from multiplication:
 * BIF, CLP, DJF, GNF, JPY, KMF, KRW, MGA, PYG, RWF, VND, VUV, XAF, XOF, XPF
 *
 * @var int (total)
 * @return int (converted total)
 */
function wptravel_square_convert_amount( $total = null, $currency = null ) {

	if ( ! $currency ) {
		$currency = 'USD';
	}
	$zero_decimal_currencies = array( 'BIF', 'CLP', 'DJF', 'GNF', 'JPY', 'KMF', 'KRW', 'MGA', 'PYG', 'RWF', 'VND', 'VUV', 'XAF', 'XOF', 'XPF' );

	if ( in_array( $currency, $zero_decimal_currencies ) ) {
		$new_total = intval( $total );
	} else {
		$new_total = round( (float) $total, 2 ) * 100;
	}
	return $new_total;
}

/**
 * Response amount from square payment.
 * With decimal currencies like USD
 * $5 (500) must be divided by 100
 * to get actual $ value as $5.
 * But for zero-decimal currencies (like JPY),
 * ¥500 is just ¥500.
 *
 * The following currencies should be excluded from multiplication:
 * BIF, CLP, DJF, GNF, JPY, KMF, KRW, MGA, PYG, RWF, VND, VUV, XAF, XOF, XPF
 *
 * @var int (total)
 * @return int (converted total)
 */
function wptravel_square_revert_amount( $total = null, $currency = null ) {

	if ( ! $currency ) {
		$currency = 'USD';
	}
	$zero_decimal_currencies = array( 'BIF', 'CLP', 'DJF', 'GNF', 'JPY', 'KMF', 'KRW', 'MGA', 'PYG', 'RWF', 'VND', 'VUV', 'XAF', 'XOF', 'XPF' );

	if ( in_array( $currency, $zero_decimal_currencies ) ) {
		$new_total = intval( $total );
	} else {
		$new_total = round( (float) $total, 2 ) / 100;
	}
	return $new_total;
}
