<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 *
 * @since 5.4.0
 */
class WP_Travel_Pwa {
	public $settings;
	public function __construct() {
		$this->settings = wptravel_get_settings();
		if ( isset( $this->settings['enable_pwa'] ) ) {
			if ( $this->settings['enable_pwa'] == 'no' ) {
				if ( file_exists( WP_TRAVEL_ABSPATH . 'app/assets/manifest.json' ) || file_exists( ABSPATH . 'sw.js' ) ) {
					$this->wp_travel_disable_pwa();
				}
			} else {
				$this->wp_travel_generate_service_worker_file();
				$this->wp_travel_generate_manifest_file();
			}
		}
	}
	public function wp_travel_generate_service_worker_file() {
		$this->settings      = wptravel_get_settings();
		$app_name            = isset( $this->settings['pwa_app_name'] ) ? $this->settings['pwa_app_name'] : '';
		$app_sort_name       = isset( $this->settings['pwa_app_short_name'] ) ? $this->settings['pwa_app_short_name'] : '';
		$app_start_url       = isset( $this->settings['pwa_app_start_url'] ) ? $this->settings['pwa_app_start_url'] : '';
		$app_app_logo        = isset( $this->settings['pwa_app_logo'] ) ? $this->settings['pwa_app_logo'] : '';
		$manifestfile        = fopen( WP_TRAVEL_ABSPATH . 'app/assets/manifest.json', 'w' ) or die( 'Unable to open file!' );
		$manifestfilecontent = '{
            "name": "' . $app_name . '",
            "short_name": "' . $app_sort_name . '",
            "start_url": "' . $app_start_url . '",
            "display": "standalone",
            "background_color": "#FDFDFD",
            "theme_color": "#DB4938",
            "orientation": "portrait-primary",
            "icons": [
            {
                "src": "' . $app_app_logo . '",
                "type": "image/png",
                "sizes": "192x192"
            }
            ]
        }';
		fwrite( $manifestfile, $manifestfilecontent );
		fclose( $manifestfile );
	}
	public function wp_travel_generate_manifest_file() {
		$serviceworkerfile        = fopen( ABSPATH . 'sw.js', 'w' ) or die( 'Unable to open file!' );
		$serviceworkerfilecontent = 'const staticWPTravel = "wp-travel"
                const assets = [
                "/"
                ]
                self.addEventListener("install", installEvent => {
                installEvent.waitUntil(
                    caches.open(staticWPTravel).then(cache => {
                    cache.addAll(assets)
                    })
                )
                })
                self.addEventListener("fetch", fetchEvent => {
                fetchEvent.respondWith(
                    caches.match(fetchEvent.request).then(res => {
                    return res || fetch(fetchEvent.request)
                    })
                )
                })';
		fwrite( $serviceworkerfile, $serviceworkerfilecontent );
		fclose( $serviceworkerfile );
	}
	public function wp_travel_disable_pwa() {
		if ( file_exists( WP_TRAVEL_ABSPATH . 'app/assets/manifest.json' ) ) {
			unlink( WP_TRAVEL_ABSPATH . 'app/assets/manifest.json' );
		}
		if ( file_exists( ABSPATH . 'sw.js' ) ) {
			unlink( ABSPATH . 'sw.js' );
		}
	}
}
new WP_Travel_Pwa();
function wp_travel_pwa_head() {
	?>
		<link rel="manifest" href="<?php echo esc_url( plugins_url() ) . '/wp-travel/app/assets/manifest.json'; ?>" />
		<!-- ios support -->
		<link rel="apple-touch-icon" href="<?php echo esc_url( plugins_url() ) . '/wp-travel/app/assets/images/logo1.png'; ?>" />
		<meta name="apple-mobile-web-app-status-bar" content="#DB4938" />
		<meta name="theme-color" content="#DB4938" />
	<?php
}
if ( wptravel_get_settings()['enable_pwa'] == 'yes' ) {
	add_action( 'wp_head', 'wp_travel_pwa_head' );
}
