<?php
/**
 * Functions.
 *
 * @package checkout-core/inc/admin/
 */


/**
 * Save settings for v4.
 *
 * @param Array $settings List of settings.
 * @param Array $settings_data List of settings data.
 */
function wp_travel_settings_paystack_savev4( $settings, $settings_data ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_paystack  = ( isset( $settings_data['payment_option_paystack'] ) && '' !== $settings_data['payment_option_paystack'] ) ? $settings_data['payment_option_paystack'] : 'no';
	$paystack_test_public_key = ( isset( $settings_data['paystack_test_public_key'] ) && '' !== $settings_data['paystack_test_public_key'] ) ? $settings_data['paystack_test_public_key'] : '';
	$paystack_public_key      = ( isset( $settings_data['paystack_public_key'] ) && '' !== $settings_data['paystack_public_key'] ) ? $settings_data['paystack_public_key'] : '';

	$settings['payment_option_paystack']  = $payment_option_paystack;
	$settings['paystack_test_public_key'] = $paystack_test_public_key;
	$settings['paystack_public_key']      = $paystack_public_key;

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_settings_paystack_savev4', 10, 2 );

function wp_travel_settings_paystack_save( $settings ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_paystack = ( isset( $_POST['payment_option_paystack'] ) && '' !== $_POST['payment_option_paystack'] ) ? $_POST['payment_option_paystack'] : 'no';
	$paystack_test_public_key = ( isset( $_POST['paystack_test_public_key'] ) && '' !== $_POST['paystack_test_public_key'] ) ? $_POST['paystack_test_public_key'] : '';
	$paystack_public_key      = ( isset( $_POST['paystack_public_key'] ) && '' !== $_POST['paystack_public_key'] ) ? $_POST['paystack_public_key'] : '';
	$settings['payment_option_paystack']  = $payment_option_paystack;
	$settings['paystack_test_public_key'] = $paystack_test_public_key;
	$settings['paystack_public_key']      = $paystack_public_key;

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_settings_paystack_save' );
