"use strict";

jQuery(function ($) {
  var parsley = $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();

  var payWithPaystack = function payWithPaystack(e) {
    e.preventDefault();

    var getFormattedAmount = function getFormattedAmount() {
      var amount = $('select[name=wp_travel_payment_mode]').val() == 'partial' ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
      return parseInt(amount) * 100;
    };

    var handler = PaystackPop.setup({
      key: wp_travel.payment.paystack_public_key,
      email: $('input[name^=wp_travel_email_traveller]').val(),
      amount: getFormattedAmount(),
      currency: "NGN",
      ref: '' + Math.floor(Math.random() * 1000000000 + 1),
      // generates a pseudo-unique reference. Please replace with a reference you generated. Or remove the line entirely so our API will generate one for you
      firstname: $('input[name^=wp_travel_fname_traveller]').val(),
      lastname: $('input[name^=wp_travel_lname_traveller]').val(),
      // label: "Optional string that replaces customer email"
      metadata: {
        custom_fields: [{
          display_name: "Mobile Number",
          variable_name: "mobile_number",
          value: $('input[name^=wp_travel_phone_traveller]').val()
        }]
      },
      callback: function callback(response) {
        var form_id = 'wp-travel-booking'; // Default payment form id

        var payment_form_id = $('#wp-travel-payment-form-id').val();

        if (payment_form_id) {
          form_id = payment_form_id;
        }

        response.amount = getFormattedAmount() / 100;
        $('.loader-active').show();
        $('[name=payment_details]').remove();
        $('#wp-travel-book-now').off('click', doStack);
        $('form#' + form_id).append($("<input type='hidden' name='payment_details' />").attr("value", JSON.stringify(response))).find("input[type=submit]").click();
      },
      onClose: function onClose() {
        alert('window closed');
      }
    });
    handler.openIframe();
  };

  var togglePaymentBtn = function togglePaymentBtn() {
    var bookNowBtn = $('#wp-travel-book-now');
    if ('paystack' === $('#wp-travel-payment-paystack:checked').val()) bookNowBtn.show();
  };

  var doStack = function doStack(e) {
    if (!parsley.isValid()) return;
    if ($('[name=wp_travel_booking_option]').val() == 'booking_only') return;

    if ('paystack' === $('#wp-travel-payment-paystack:checked').val() && 'NGN' !== wp_travel.payment.currency_code) {
      e.preventDefault();
      alert('Paystack checkout only support NGN.');
      return;
    }

    'paystack' === $('#wp-travel-payment-paystack:checked').val() && payWithPaystack(e);
  };

  $('#wp-travel-book-now').on('click', doStack);
  $(document).on("change keyup", "form#wp-travel-booking", togglePaymentBtn);
});
//# sourceMappingURL=paystack-checkout-views.js.map
