jQuery(function($){

	var parsley = $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
	var supportedCurency = ['LKR','USD']
	var isPayHere = function(){
		return parsley.isValid() && $('[name=wp_travel_booking_option]').val() == 'booking_with_payment' && 'payhere' === $('#wp-travel-payment-payhere:checked').val()
	}

	$('#wp-travel-book-now').on('click', function(e){
		if(isPayHere()){
			if ( supportedCurency.indexOf( wp_travel.payment.currency_code ) < 0 ) {
				e.preventDefault();
				alert('PayHere checkout only support Sri Lankan Rupee (LKR) and US Dollar(USD).');
				return;
			}
		}
	});
	// For Partial Payment.
	$('#wp-travel-complete-partial-payment').on('click', function(e){
		var isPayHere = $('[name=wp_travel_booking_option]').val() == 'booking_with_payment' && 'payhere' === $('#wp-travel-payment-payhere:checked').val()
		if(isPayHere){
			if ( supportedCurency.indexOf( wp_travel.payment.currency_code ) < 0 ) {
				e.preventDefault();
				alert('PayHere checkout only support Sri Lankan Rupee (LKR) and US Dollar(USD).');
				return;
			}
		}
	});

	$('#wp-travel-booking').on('change keyup', function(){
		'payhere' === $('#wp-travel-payment-payhere:checked').val() && $('#wp-travel-book-now').show().siblings().hide();
	})

	var paymentForm = $('#wp_travel_payhere_payment_form');
	paymentForm && paymentForm.find('input[type=submit]').click();
});
