<?php
/**
 * Settings class
 */


/**
 * WP_Travel_PayFast_Settings.
 */
class WP_Travel_PayFast_Settings {

	/**
	 * Default Settings.
	 *
	 * @var array
	 */
	private $default_settings;

	/**
	 * Instance.
	 *
	 * @var object
	 */
	protected static $_instance = null;

	/**
	 * Return Instance.
	 *
	 * @return object
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		self::$_instance        = $this;
		$this->default_settings = array(
			'payment_option_payfast' => 'no',
			'merchant_key'           => '',
			'merchant_id'            => '',
			'passphrase'             => '',
		);
		add_filter( 'wp_travel_block_before_save_settings', array( $this, 'save_settings_v4' ), 10, 2 );
		add_filter( 'wp_travel_before_save_settings', array( $this, 'save_settings' ) );
	}


	/**
	 * Save Settings v4.
	 *
	 * @param Array $settings List of settings.
	 * @param Array $settings_data List of settings data.
	 */
	public function save_settings_v4( $settings, $settings_data ) {
		$defaults = $this->get_default_settings();
		if ( isset( $settings_data['wp_travel_payfast_settings'] ) ) {
			$payfast_settings = $settings_data['wp_travel_payfast_settings'];
			foreach ( $defaults as $key => $value ) {
				if ( isset( $payfast_settings[ $key ] ) ) {
					$settings['wp_travel_payfast_settings'][ $key ] = $payfast_settings[ $key ];
					if ( 'payment_option_payfast' === $key ) {
						$settings['payment_option_payfast'] = $payfast_settings[ $key ];
					}
					continue;
				}
				$settings['wp_travel_payfast_settings'][ $key ] = $value;
			}
		}
		if ( ! isset( $payfast_settings['payment_option_payfast'] ) ) {
			$settings['payment_option_payfast'] = 'no';
		}
		return $settings;
	}

	/**
	 * Save Gallery Settings.
	 *
	 * @return void
	 */
	public function save_settings( $settings ) {
		$defaults = $this->get_default_settings();
		if ( isset( $_POST['wp_travel_payfast_settings'] ) ) {
			$payfast_settings = $_POST['wp_travel_payfast_settings'];
			foreach ( $defaults as $key => $value ) {
				if ( isset( $payfast_settings[ $key ] ) ) {
					$settings['wp_travel_payfast_settings'][ $key ] = $payfast_settings[ $key ];
					if ( 'payment_option_payfast' === $key ) {
						$settings['payment_option_payfast'] = $payfast_settings[ $key ];
					}
					continue;
				}
				$settings['wp_travel_payfast_settings'][ $key ] = $value;
			}
		}
		if ( ! isset( $payfast_settings['payment_option_payfast'] ) ) {
			$settings['payment_option_payfast'] = 'no';
		}
		return $settings;
	}

	/**
	 * Gallery Settings.
	 *
	 * @return void
	 */
	public function get_settings() {
		$wp_travel_settings = array();
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$wp_travel_settings = wptravel_get_settings();
		}
		$settings = $this->get_default_settings();
		if ( isset( $wp_travel_settings['wp_travel_payfast_settings'] ) && is_array( $wp_travel_settings['wp_travel_payfast_settings'] ) ) {
			$settings = $this->parse_args( $wp_travel_settings['wp_travel_payfast_settings'] );
		}
		return $settings;
	}

	/**
	 * Parse Arguments.
	 *
	 * @param [type] $args
	 * @return void
	 */
	private function parse_args( $args ) {
		$defaults = $this->get_default_settings();
		return wp_parse_args( $args, $defaults );
	}

	/**
	 * Default Settings.
	 *
	 * @return void
	 */
	private function get_default_settings() {
		return $this->default_settings;
	}
}

new WP_Travel_PayFast_Settings();
