<?php
/**
 * Functions.
 *
 * @package wp-travel-partial-payment/inc/
 */

 /**
  * Booking Details.
  */
function wp_travel_get_booking_detail() {

	if ( ! isset( $_REQUEST['detail_id'] ) ) {
		return;
	}
	global $wp;
	$thankyou_page = home_url( $wp->request );

	$booking_id = sanitize_text_field( wp_unslash( $_REQUEST['detail_id'] ) );

	include_once WP_TRAVEL_ABSPATH . 'inc/framework/form/class.form.php';

	if ( function_exists( 'wptravel_booking_data' ) ) {
		$details     = wptravel_booking_data( $booking_id );
	} else {
		$details     = wp_travel_booking_data( $booking_id );
	}
	$booking_option        = $details['booking_option'];
	$details['due_amount'] = apply_filters( 'wp_travel_partial_payment_due_amount', $details['due_amount'] );

	if ( $details['due_amount'] > 0 ) {
		if ( function_exists( 'wptravel_get_active_gateways' ) ) {
			$gateway_list        = wptravel_get_active_gateways();
		} else {
			$gateway_list        = wp_travel_get_active_gateways();
		}
		$active_gateway_list = isset( $gateway_list['active'] ) ? $gateway_list['active'] : array();
		unset( $active_gateway_list['squareup_checkout'] );

		$selected_gateway = isset( $gateway_list['selected'] ) ? $gateway_list['selected'] : '';
		$payment_fields   = array();

		if ( is_array( $active_gateway_list ) && count( $active_gateway_list ) > 0 ) {
			if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
				$default_price = wptravel_get_formated_price_currency( $details['due_amount'], false, '', $booking_id ); // @since 1.0.5
			} else {
				$default_price = wp_travel_get_formated_price_currency( $details['due_amount'], false, '', $booking_id ); // @since 1.0.5
			}

			include_once WP_TRAVEL_ABSPATH . 'inc/framework/form/class.form.php';

			$form_options = array(
				'id'            => 'wp-travel-partial-payment',
				'class'         => 'wp-travel-partial-payment',
				'wrapper_class' => 'wp-travel-partial-payment-form-wrapper',
				'submit_button' => array(
					'name'  => 'complete_partial_payment',
					'id'    => 'wp-travel-complete-partial-payment',
					'value' => __( 'Complete Payment', 'wp-travel-pro' ),
				),
				'nonce'         => array(
					'action' => 'wp_travel_security_action',
					'field'  => 'wp_travel_security',
				),
				'hook_prefix'   => 'wp_travel_partial_payment',

			);
			$form_options = apply_filters( 'wp_travel_partial_payment_forms_options', $form_options );

			$selected_gateway = apply_filters( 'wp_travel_checkout_default_gateway', $selected_gateway );

			$payment_fields['amount_info'] = array(
				'type'          => 'text_info',
				'label'         => __( 'Amount', 'wp-travel-pro' ),
				'name'          => 'amount_info',
				'id'            => 'wp-travel-amount-info',
				'wrapper_class' => '',
				// 'before_field'  => wptravel_get_currency_symbol(), // @since 1.0.5
				'default'       => $default_price,
				'priority'      => 100,
			);

			$payment_fields['payment_gateway'] = array(
				'type'          => 'radio',
				'label'         => __( 'Payment Gateway', 'wp-travel-pro' ),
				'name'          => 'wp_travel_payment_gateway',
				'id'            => 'wp-travel-payment-gateway',
				'wrapper_class' => 'wp-travel-radio-group',
				'validations'   => array(
					'required' => true,
				),
				'options'       => $active_gateway_list,
				'default'       => $selected_gateway,
				'priority'      => 101,
			);

			$payment_fields['booking_option'] = array(
				'type'          => 'hidden',
				'name'          => 'wp_travel_booking_option',
				'id'            => 'wp-travel-booking-option',
				'wrapper_class' => '',
				'default'       => 'booking_with_payment',
			);
			$payment_fields['amount']         = array(
				'type'          => 'hidden',
				'label'         => __( 'Amount', 'wp-travel-pro' ),
				'name'          => 'amount',
				'id'            => 'wp-travel-amount',
				'wrapper_class' => '',
				'default'       => $details['due_amount'],
			);
			$payment_fields['form_id']        = array(
				'type'          => 'hidden',
				'name'          => 'wp_travel_payment_form_id',
				'id'            => 'wp-travel-payment-form-id',
				'wrapper_class' => '',
				'default'       => 'wp-travel-partial-payment',
			);
			$payment_fields['booking_id']     = array(
				'type'    => 'hidden',
				'name'    => 'wp_travel_booking_id',
				'id'      => 'wp-travel-booking-id',
				'default' => $booking_id,
			);
			$payment_fields['thankyou_page']  = array(
				'type'    => 'hidden',
				'name'    => 'thankyou_page',
				'id'      => 'wp-travel-thankyou-page',
				'default' => $thankyou_page,
			);
			$payment_fields['payment_email']  = array(
				'type'    => 'hidden',
				'name'    => 'payment_email',
				'id'      => 'wp-travel-payment-email',
				'default' => wp_get_current_user()->user_email,
			);

			$payment_fields = apply_filters( 'partial_payment_form_fields', $payment_fields, $booking_id );

			// Fields for tables.
			$total = isset( $details['total'] ) ? $details['total'] : 0;
			$partial_payment_data = get_post_meta( $booking_id, 'wp_travel_partial_payment_array_structure', true );
			$global_payouts       = $partial_payment_data['partial_payments'];
			$custom_payouts       = ! empty( $partial_payment_data['custom_payouts'] ) ? $partial_payment_data['custom_payouts'] : array();
			$result = array();
			foreach ( $global_payouts as $key => $val ) {
				$new_val        = isset( $custom_payouts[ $key ] ) && $custom_payouts[ $key ] ? $custom_payouts[ $key ] : $val; // Get the values from the other array
				$result[ $key ] = $new_val;
			}
			$custom_payouts = $result;

			// Partial payment.
			$payment_data     = wptravel_payment_data( $booking_id ); // Need to use this function to get payment data.
			$payment_ids      = get_post_meta( $booking_id, 'wp_travel_payment_id', true );
			$payment_ids      = ! is_array( $payment_ids ) ? array( $payment_ids ) : $payment_ids;
			$count_payments   = count( $payment_data );
			if ( 'booking_only' === $booking_option ) {
				// To support partial payment in case of booking only.
				$count_payments = 0; 
			} 
			$partial_payments = ! empty( $partial_payment_data['use_global'] ) ? $partial_payment_data['partial_payments'] : $custom_payouts;
			// error_log( print_r($partial_payments , true ) );
			if (  wptravel_get_settings()['partial_payment_amount'] == 'no' && is_array( $partial_payments ) && count( $partial_payments ) > 0 ) { ?>
				
				
				<div class="view-partial-info-wrapper">
					<a href="" class="view-partial-info" ><?php esc_html_e( 'View info', 'wp-travel-pro' ); ?></a>
					<table class="partial-payment-info">
						
						<tr>
							<th><?php esc_html_e( 'SN', 'wp-travel-pro' ); ?></th>
							<th><?php esc_html_e( 'Partial %', 'wp-travel-pro' ); ?></th>
							<th><?php esc_html_e( 'Amount', 'wp-travel-pro' ); ?></th>
						</tr>
						
						<?php
						$temp_total_percent = 0; // To exit if total % greater than 100. if 1st installment set as 100 % then 2nd installment will fetch from global.
						foreach ( $partial_payments as $i => $partial_percent ) :
							$amount       = ( $total * $partial_percent ) / 100;
							$row_class    = $i <  $count_payments ? 'payment-row paid-row ' : 'payment-row unpaid-row';
							$amount_title = $i <  $count_payments ? __( 'Paid', 'wp-travel-pro' ) : __( 'Due', 'wp-travel-pro' );
							if ( $i === $count_payments ) {
								$row_class = 'payment-row ongoing-row';
								$amount_title  = __( 'Ongoing', 'wp-travel-pro' );
							}
							?>
							<tr class="<?php echo esc_attr( $row_class ); ?>">
								<td title="paid"><?php echo esc_html( $i+1 ); ?></td>
								<td><?php echo esc_html( $partial_percent ); ?>%</td>
								<td title="<?php echo esc_attr( $amount_title ); ?>">
									<?php 
									if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
										echo wptravel_get_formated_price_currency( $amount ); // @phpcs:ignore
									} else {
										echo wp_travel_get_formated_price_currency( $amount ); // @phpcs:ignore
									}
									?>
									<i class="wt-icon wt-icon-check-circle"></i>
								</td>
							</tr>
							<?php
							$temp_total_percent += (float) $partial_percent;
							if ( $temp_total_percent >= 100 ) {
								break;
							}
						endforeach;
						?>
						<tr class="separator" ></tr>
						<tr class="trip-total">
							<th colspan="2"><?php esc_html_e( 'Trip total', 'wp-travel-pro' ); ?></th>
							<th><?php
							if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
								echo wptravel_get_formated_price_currency( $total ); // @phpcs:ignore
							} else {
								echo wp_travel_get_formated_price_currency( $total ); // @phpcs:ignore
							}
							?></th>
						</tr>
					</table>
				</div>
				
				<?php
			}
			?>
			<?php
			$form = new WP_Travel_FW_Form();
			$form->init( $form_options )->fields( $payment_fields )->template();
		}
	}
}
// Load Popup Content.
add_action( 'wp_travel_dashboard_booking_after_detail', 'wp_travel_get_booking_detail' );

/**
 * Complete Partial payment.
 */
function wp_travel_complete_parital_payment() {
	if ( ! isset( $_POST['complete_partial_payment'] ) ) {
		return;
	}

	if ( ! isset( $_POST['wp_travel_booking_id'] ) ) {
		return;
	}

	if ( ! isset( $_POST['wp_travel_security'] ) ) {
		return;
	}

	if ( ! wp_verify_nonce( $_POST['wp_travel_security'], 'wp_travel_security_action' ) ) {
		return;
	}

	$thankyou_page = $_POST['thankyou_page'];
	$booking_id    = isset( $_POST['wp_travel_booking_id'] ) ? sanitize_text_field( wp_unslash( $_POST['wp_travel_booking_id'] ) ) : 0;

	do_action( 'wp_travel_before_partial_payment_complete', $booking_id, $complete_partial_payment = true ); // For Standard Paypal.

	if ( isset( $_POST['payment_details'] ) && '' !== $_POST['payment_details'] ) {
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		if ( function_exists( 'wptravel_booking_data' ) ) {
			$details     = wptravel_booking_data( $booking_id );
		} else {
			$details     = wp_travel_booking_data( $booking_id );
		}
		$booking_option = $details['booking_option'];

		// Need to update payment meta here.
		do_action( 'wp_travel_after_partial_payment_complete' );

		// Added since 4.3.4, if the trip is book only first, then if user pay it in next time, this divert to full payment mode and full pay email will be sent. ( This needs enhancement ).
		if ( 'booking_only' === $booking_option ) {
			wptravel_send_email_payment( $booking_id );
			return;
		}
		// Send Partial Payment Complete email here.
		$send_email_to_admin = ( isset( $settings['send_booking_email_to_admin'] ) && '' !== $settings['send_booking_email_to_admin'] ) ? $settings['send_booking_email_to_admin'] : 'yes';

		$current_user = wp_get_current_user();

		$client_email = $current_user->user_email;
		$admin_email  = get_option( 'admin_email' );

		// Email Variables.
		if ( is_multisite() ) {
			$sitename = get_network()->site_name;
		} else {
			$sitename = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
		}

		$amount = isset( $_POST['amount'] ) ? sanitize_text_field( wp_unslash( $_POST['amount'] ) ) : 0;

		$email_tags = array(
			'{sitename}'      => $sitename,
			'{booking_id}'    => $booking_id,
			'{customer_name}' => $current_user->display_name,
			// '{amount}'        => wptravel_get_currency_symbol() . ' ' . $amount,
			'{amount}'        => wptravel_get_formated_price_currency( $amount, false, '', $booking_id ), // @since 1.0.5,
		);

		$email = new WP_Travel_Emails();

		$admin_template = $email->wptravel_get_email_template( 'partial_payment', 'admin' );

		$admin_message_data  = $admin_template['mail_header'];
		$admin_message_data .= $admin_template['mail_content'];
		$admin_message_data .= $admin_template['mail_footer'];
		// Admin message.
		$admin_message = str_replace( array_keys( $email_tags ), $email_tags, $admin_message_data );
		// Admin Subject.
		$admin_subject = $admin_template['subject'];

		// Client Template.
		$client_template = $email->wptravel_get_email_template( 'partial_payment', 'client' );

		$client_message_data  = $client_template['mail_header'];
		$client_message_data .= $client_template['mail_content'];
		$client_message_data .= $client_template['mail_footer'];

		// Client message.
		$client_message = str_replace( array_keys( $email_tags ), $email_tags, $client_message_data );

		// Client Subject.
		$client_subject = $client_template['subject'];

		$reply_to_email = isset( $settings['wp_travel_from_email'] ) ? $settings['wp_travel_from_email'] : $admin_email;

		// Send mail to admin if booking email is set to yes.
		if ( 'yes' === $send_email_to_admin ) {

			// To send HTML mail, the Content-type header must be set.
			$headers = $email->email_headers( $reply_to_email, $client_email );

			if ( ! wp_mail( $admin_email, $admin_subject, $admin_message, $headers ) ) {
				WP_Travel()->notices->add( '<strong>' . __( 'Error:', 'wp-travel-pro' ) . '</strong> ' . __( 'Email could not be sent.', 'wp-travel-pro' ), 'error' );
			}
		}

		// Send email to client.
		// To send HTML mail, the Content-type header must be set.
		$headers = $email->email_headers( $reply_to_email, $reply_to_email );

		if ( ! wp_mail( $client_email, $client_subject, $client_message, $headers ) ) {
			WP_Travel()->notices->add( '<strong>' . __( 'Error:', 'wp-travel-pro' ) . '</strong> ' . __( 'Email could not be sent.', 'wp-travel-pro' ), 'error' );
		}

		WP_Travel()->notices->add( __( 'Partial Payment Success.', 'wp-travel-pro' ), 'success' );

		wp_redirect( $thankyou_page );
		die;
	}

}
add_action( 'init', 'wp_travel_complete_parital_payment', 20 );

/**
 * This will update payment meta or insert payment post.
 */
function wptravel_update_payment_post( $payment_id, $booking_id, $payment_gateway ) {
	$booking_option = get_post_meta( $booking_id, 'wp_travel_booking_option', true ); // New since WP Travel 5.0.2
	
	$payment_ids = array();
	if ( is_array( $payment_id ) ) {
		$payment_ids = $payment_id;
	} else {
		$payment_ids[] = $payment_id;
	}

	// insert new payment id and update meta.
	$title          = 'Payment - #' . $booking_id;
	$post_array     = array(
		'post_title'   => $title,
		'post_content' => '',
		'post_status'  => 'publish',
		'post_slug'    => uniqid(),
		'post_type'    => 'wp-travel-payment',
	);
	$new_payment_id = wp_insert_post( $post_array );
	$payment_ids[]  = $new_payment_id;

	$payment_id = $new_payment_id; // update new payment id as payment id and also return this new payment id.

	// Update Required Metas.
	update_post_meta( $booking_id, 'wp_travel_booking_option', 'booking_with_payment' );
	update_post_meta( $booking_id, 'wp_travel_payment_id', $payment_ids );
	update_post_meta( $booking_id, 'wp_travel_payment_status', 'paid' ); // Since WP Travel 5.0.2
	update_post_meta( $booking_id, 'wp_travel_payment_mode', 'partial' );  // Since WP Travel 5.0.2

	update_post_meta( $payment_id, 'wp_travel_payment_gateway', $payment_gateway );
	update_post_meta( $payment_id, 'wp_travel_payment_amount', $_POST['amount'] ); // fallback amount. Amount value will be override by return value from respective payment gateway.
	update_post_meta( $payment_id, 'wp_travel_payment_status', 'partially_paid' ); // Note. this value must be in booking rather than payment. because we have multiple payment ids. so added this meta in booking as well since WP Travel 5.0.2. Need to remove this latter.
	update_post_meta( $payment_id, 'wp_travel_payment_mode', 'partial' ); // Note. this value must be in booking rather than payment. because we have multiple payment ids. so added this meta in booking as well since WP Travel 5.0.2 Need to remove this latter.
	return $payment_id;
}

/**
 * Insert payment post to add payment meta for the payment as per payment method.
 */
add_filter( 'wptravel_before_insert_partial_payment', 'wptravel_update_payment_post', 10 , 3 );
