<?php

/**
 * Payment Default Email Admin Content.
 *
 * @return HTML
 */
function wp_travel_partial_payment_admin_default_email_content() {
	ob_start();
	?>
	<table class="wp-travel-wrapper" width="100%" cellpadding="0" cellspacing="0" style="color: #5d5d5d;font-family: Roboto, sans-serif;margin: auto;">
		<tr class="wp-travel-content" style="background: #fff;">
			<td colspan="2" align="left" class="wp-travel-content-top" style="background: #fff;box-sizing: border-box;margin: 0;padding: 20px 25px;">
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Hello', 'wp-travel-pro' ); ?> {sitename} <?php esc_html_e( 'Admin', 'wp-travel-pro' ); ?>,</p>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'You have received partial payment of {amount} from', 'wp-travel-pro' ); ?> {customer_name}:</p>
				<p style="line-height: 1.55;font-size: 14px;"><b><?php esc_html_e( 'Booking ID', 'wp-travel-pro' ); ?>: <a href="{booking_edit_link}" target="_blank" style="color: #5a418b;text-decoration: none;">#{booking_id}</a> </b></p>
			</td>
		</tr>
	</table>
	<?php
	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}

/**
 * Payment default client email template.
 *
 * @return HTML
 */
function wp_travel_partial_payment_client_default_email_content() {
	ob_start();
	?>
	<table class="wp-travel-wrapper" width="100%" cellpadding="0" cellspacing="0" style="color: #5d5d5d;font-family: Roboto, sans-serif;margin: auto;">
		<tr class="wp-travel-content" style="background: #fff;">
			<td colspan="2" align="left" class="wp-travel-content-top" style="background: #fff;box-sizing: border-box;margin: 0;padding: 20px 25px;">
			<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Hello', 'wp-travel-pro' ); ?> {customer_name},</p>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Your partial payment of {amount} has been received.', 'wp-travel-pro' ); ?></p>
				<p style="line-height: 1.55;font-size: 14px;"><b><?php esc_html_e( 'Booking ID', 'wp-travel-pro' ); ?>: <a href="{booking_edit_link}" target="_blank" style="color: #5a418b;text-decoration: none;">#{booking_id}</a></b></p>
			</td>
		</tr>

	</table>

	<?php
	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}

/**
 * Payment default client email template.
 *
 * @return HTML
 */
function wp_travel_partial_payment_reminder_email_content() {
	ob_start();
	?>
	<table class="wp-travel-wrapper" width="100%" cellpadding="0" cellspacing="0" style="color: #5d5d5d;font-family: Roboto, sans-serif;margin: auto;">
		<tr class="wp-travel-content" style="background: #fff;">
			<td colspan="2" align="left" class="wp-travel-content-top" style="background: #fff;box-sizing: border-box;margin: 0;padding: 20px 25px;">
			<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Hello', 'wp-travel-pro' ); ?> {customer_name},</p>
			<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Your partial payment of trip {itinerary_title} ', 'wp-travel-pro' ); ?> <a href="{booking_edit_link}" target="_blank" style="color: #5a418b;text-decoration: none;">#{booking_id}</a> <?php esc_html_e( ' is remaining.', 'wp-travel-pro' ); ?></p>
			<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Please visit {booking_edit_link} to do the payment.', 'wp-travel-pro' ); ?></p>
				<p style="line-height: 1.55;font-size: 14px;"><b><?php esc_html_e( 'Booking ID', 'wp-travel-pro' ); ?>: <a href="{booking_edit_link}" target="_blank" style="color: #5a418b;text-decoration: none;">#{booking_id}</a></b></p>
			</td>
		</tr>

	</table>

	<?php
	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}

/**
 * Email Template Data for partial payment.
 *
 * @param array  $email_data Array of email data.
 * @param string $type       Type of email template(partial payment).
 * @param string $sent_to    Send to client or admin.
 * @return array
 */
function wp_travel_partial_payment_email_template( $email_data, $type, $sent_to ) {
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	if ( 'partial_payment' === $type ) {
		if ( 'admin' === $sent_to ) {
			// Set Headings.
			$email_data['header_details'] = array(
				'header_title' => isset( $settings['partial_payment_admin_template']['admin_title'] ) && '' !== $settings['partial_payment_admin_template']['admin_title'] ? $settings['partial_payment_admin_template']['admin_title'] : __( 'Partial Payment', 'wp-travel-pro' ),
				'header_color' => isset( $settings['partial_payment_admin_template']['admin_header_color'] ) && '' !== $settings['partial_payment_admin_template']['admin_header_color'] ? $settings['partial_payment_admin_template']['admin_header_color'] : '#dd402e',
			);

			$email_data['subject'] = isset( $settings['partial_payment_admin_template']['admin_subject'] ) && '' !== $settings['partial_payment_admin_template']['admin_subject'] ? $settings['partial_payment_admin_template']['admin_subject'] : __( 'Partial Payment', 'wp-travel-pro' );
			// Set Contents.
			$email_data['email_content'] = isset( $settings['partial_payment_admin_template']['email_content'] ) && '' !== $settings['partial_payment_admin_template']['email_content'] ? $settings['partial_payment_admin_template']['email_content'] : wp_travel_partial_payment_admin_default_email_content();

		} elseif ( 'client' === $sent_to ) {
			// Set Headings.
			$email_data['header_details'] = array(
				'header_title' => isset( $settings['partial_payment_client_template']['client_title'] ) && '' !== $settings['partial_payment_client_template']['client_title'] ? $settings['partial_payment_client_template']['client_title'] : __( 'Partial Payment Received', 'wp-travel-pro' ),
				'header_color' => isset( $settings['partial_payment_client_template']['client_header_color'] ) && '' !== $settings['partial_payment_client_template']['client_header_color'] ? $settings['partial_payment_client_template']['client_header_color'] : '#dd402e',
			);

			$email_data['subject'] = isset( $settings['partial_payment_client_template']['client_subject'] ) && '' !== $settings['partial_payment_client_template']['client_subject'] ? $settings['partial_payment_client_template']['client_subject'] : __( 'Partial Payment Received', 'wp-travel-pro' );
			// Set Contents.
			$email_data['email_content'] = isset( $settings['partial_payment_client_template']['email_content'] ) && '' !== $settings['partial_payment_client_template']['email_content'] ? $settings['partial_payment_client_template']['email_content'] : wp_travel_partial_payment_client_default_email_content();
		}
	}
	return $email_data;
}

add_filter( 'wp_travel_email_template_type', 'wp_travel_partial_payment_email_template', 10, 3 );
