jQuery(document).ready(function ($) {

	/**
	 * Settings payment tab scripts.
	 */
	/**
	 * Add class at initial loading to the default field for counting the dynamic generated fields.
	 */
	$('#wp-travel-minimum-partial-payout').addClass('wp-travel-multiple-partial-payment-payouts');

	/**
	 * Hide or display the fields on toggle change.
	 */
	$('#partial_payment').change(function () {
		if ($(this).is(':checked')) {
			$('.wp-travel-partial-payment-payouts-row').show();
		} else {
			$('.wp-travel-partial-payment-payouts-row').hide();
		}
	});
	$('#partial_payment').trigger('change');

	/**
	 * Create table row for partial payments options.
	 */
	$("#btn_add_partial_payment").click(function () {
		var trRow = document.createElement('tr'); // create row node
		var columnTh = document.createElement('th'); // create column node
		var columnTd = document.createElement('td'); // create second column node
		var table = document.getElementById('wp_travel_partial_payment_table'); // find table to append to

		trRow.appendChild(columnTh); // append first column to row
		trRow.appendChild(columnTd); // append second column to row

		var countTableRow = $('.wp-travel-multiple-partial-payment-payouts').length;
		var rowIndex = countTableRow + 1;
		var partialPaymentLabel = 'Partial Payout ' + (rowIndex) + ' (%)';

		trRow.id = 'wp_travel_partial_payment_tr_' + (rowIndex); // change id or other attributes/contents
		$(trRow).addClass('wp-travel-multiple-partial-payment-payouts wp-travel-partial-payment-payouts-row');

		columnTh.innerHTML = "<label for='multiple_partial_payment_payouts_output_" + (rowIndex) + "'>" + partialPaymentLabel + "</label>"; // put data in first column
		columnTd.innerHTML = "<td><input type='range' min='1' max='100' step='0.01' value='' data-input-id='multiple_partial_payment_payouts_output_" + (rowIndex) + "' id='multiple_partial_payment_payouts_" + (rowIndex) + "' class='wt-slider multiple-partial-payment-payouts-slider' /><label><input type='number' min='1' max='100' step='0.01' value='' class='multiple-partial-payment-payouts-output-field' name='minimum_partial_payout[" + countTableRow + "]' data-slider-id='multiple_partial_payment_payouts_" + (rowIndex) + "' id='multiple_partial_payment_payouts_output_" + (rowIndex) + "' />%</label><p class='description'></p></td>"; // put data in second column

		if (countTableRow < 4) {
			var rowToModify = document.getElementById("wp-travel-minimum-partial-payout"); // find tr to modify its th
			$(rowToModify).find('th > label').text('Partial Payout 1 (%)'); // Change the header name.
			table.appendChild(trRow); // add new trRow to end of table
		}
	});

	/**
	 * Delete the last partial payment row.
	 */
	$("#btn_delete_partial_payment").click(function () {
		var table = document.getElementById("wp_travel_partial_payment_table");

		// count the number of tr
		var countTableRow = $('.wp-travel-multiple-partial-payment-payouts').length;

		// revert the table head name
		if (countTableRow < 3) {
			var rowToModify = document.getElementById("wp-travel-minimum-partial-payout"); // find tr to modify its th
			$(rowToModify).find('th > label').text('Minimum Payout (%)');
		}

		// if tr is greater than 1 then only del the last row
		if (countTableRow > 1) {
			table.deleteRow(-1);
		}
	});

	/**
	 * Sync slider with input field value.
	 */
	$(document).on('input', '.multiple-partial-payment-payouts-output-field', function () {
		var sliderID = $(this).data('slider-id');
		var fieldVal = $(this).val();
		$('#' + sliderID).val(fieldVal);
	});

	/**
	 * Sync input field slider value.
	 */
	$(document).on('input', '.multiple-partial-payment-payouts-slider', function () {
		var inputID = $(this).data('input-id');
		var sliderVal = $(this).val();
		$('#' + inputID).val(sliderVal);
	});

	/**
	 * Price.php scripts.
	 */
	/**
	 * Hide/Show custom partial payout rows.
	 */
	$('#wp-travel-minimum-partial-payout-percent-use-global').change(function () {
		if ($(this).is(':checked')) {
			$('.multiple-custom-partial-payment-row').hide();
		} else {
			$('.multiple-custom-partial-payment-row').show();
		}
	});
	$('#wp-travel-minimum-partial-payout-percent-use-global').trigger('change');

    /**
     * Hide/Show remaining partial payment row.
     */
    $('#remaining_partial_payment_reminder_send_remaining_payment_notification').change(function() {
        if ($(this).is(':checked')) {
            $('.wp-travel-remaining-partial-partial-email-row').show();
        } else {
            $('.wp-travel-remaining-partial-partial-email-row').hide();
        }
    });
    $('#remaining_partial_payment_reminder_send_remaining_payment_notification').trigger('change');
});
