<?php
/**
 * WP Travel Multiple Currency functions.
 *
 * @package multiple-currency-core/inc/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Fixer supported currency symbols to display currency names.
 * Currently it only supports 167 currencies.
 *
 * @return array $currencies_name Currency names with symbols.
 */
function wp_travel_multiple_currency_currencies_name() {
	$currencies_name = array(
		'AED' => __( 'United Arab Emirates Dirham', 'wp-travel-pro' ),
		'AFN' => __( 'Afghan Afghani', 'wp-travel-pro' ),
		'ALL' => __( 'Albanian Lek', 'wp-travel-pro' ),
		'AMD' => __( 'Armenian Dram', 'wp-travel-pro' ),
		'ANG' => __( 'Netherlands Antillean Guilder', 'wp-travel-pro' ),
		'AOA' => __( 'Angolan Kwanza', 'wp-travel-pro' ),
		'ARS' => __( 'Argentine Peso', 'wp-travel-pro' ),
		'AUD' => __( 'Australian Dollar', 'wp-travel-pro' ),
		'AWG' => __( 'Aruban Florin', 'wp-travel-pro' ),
		'AZN' => __( 'Azerbaijani Manat', 'wp-travel-pro' ),
		'BAM' => __( 'Bosnia-Herzegovina Convertible Mark', 'wp-travel-pro' ),
		'BBD' => __( 'Barbadian Dollar', 'wp-travel-pro' ),
		'BDT' => __( 'Bangladeshi Taka', 'wp-travel-pro' ),
		'BGN' => __( 'Bulgarian Lev', 'wp-travel-pro' ),
		'BHD' => __( 'Bahraini Dinar', 'wp-travel-pro' ),
		'BIF' => __( 'Burundian Franc', 'wp-travel-pro' ),
		'BMD' => __( 'Bermudan Dollar', 'wp-travel-pro' ),
		'BND' => __( 'Brunei Dollar', 'wp-travel-pro' ),
		'BOB' => __( 'Bolivian Boliviano', 'wp-travel-pro' ),
		'BRL' => __( 'Brazilian Real', 'wp-travel-pro' ),
		'BSD' => __( 'Bahamian Dollar', 'wp-travel-pro' ),
		'BTC' => __( 'Bitcoin', 'wp-travel-pro' ),
		'BTN' => __( 'Bhutanese Ngultrum', 'wp-travel-pro' ),
		'BWP' => __( 'Botswanan Pula', 'wp-travel-pro' ),
		'BYR' => __( 'Belarusian Ruble', 'wp-travel-pro' ),
		'BYN' => __( 'New Belarusian Ruble', 'wp-travel-pro' ),
		'BZD' => __( 'Belize Dollar', 'wp-travel-pro' ),
		'CAD' => __( 'Canadian Dollar', 'wp-travel-pro' ),
		'CDF' => __( 'Congolese Franc', 'wp-travel-pro' ),
		'CHF' => __( 'Swiss Franc', 'wp-travel-pro' ),
		'CLF' => __( 'Chilean Unit of Account (UF)', 'wp-travel-pro' ),
		'CLP' => __( 'Chilean Peso', 'wp-travel-pro' ),
		'CNY' => __( 'Chinese Yuan', 'wp-travel-pro' ),
		'COP' => __( 'Colombian Peso', 'wp-travel-pro' ),
		'CRC' => __( 'Costa Rican Colón', 'wp-travel-pro' ),
		'CUC' => __( 'Cuban Convertible Peso', 'wp-travel-pro' ),
		'CUP' => __( 'Cuban Peso', 'wp-travel-pro' ),
		'CVE' => __( 'Cape Verdean Escudo', 'wp-travel-pro' ),
		'CZK' => __( 'Czech Republic Koruna', 'wp-travel-pro' ),
		'DJF' => __( 'Djiboutian Franc', 'wp-travel-pro' ),
		'DKK' => __( 'Danish Krone', 'wp-travel-pro' ),
		'DOP' => __( 'Dominican Peso', 'wp-travel-pro' ),
		'DZD' => __( 'Algerian Dinar', 'wp-travel-pro' ),
		'EGP' => __( 'Egyptian Pound', 'wp-travel-pro' ),
		'ERN' => __( 'Eritrean Nakfa', 'wp-travel-pro' ),
		'ETB' => __( 'Ethiopian Birr', 'wp-travel-pro' ),
		'EUR' => __( 'Euro', 'wp-travel-pro' ),
		'FJD' => __( 'Fijian Dollar', 'wp-travel-pro' ),
		'FKP' => __( 'Falkland Islands Pound', 'wp-travel-pro' ),
		'GBP' => __( 'British Pound Sterling', 'wp-travel-pro' ),
		'GEL' => __( 'Georgian Lari', 'wp-travel-pro' ),
		'GGP' => __( 'Guernsey Pound', 'wp-travel-pro' ),
		'GHS' => __( 'Ghanaian Cedi', 'wp-travel-pro' ),
		'GIP' => __( 'Gibraltar Pound', 'wp-travel-pro' ),
		'GMD' => __( 'Gambian Dalasi', 'wp-travel-pro' ),
		'GNF' => __( 'Guinean Franc', 'wp-travel-pro' ),
		'GTQ' => __( 'Guatemalan Quetzal', 'wp-travel-pro' ),
		'GYD' => __( 'Guyanaese Dollar', 'wp-travel-pro' ),
		'HKD' => __( 'Hong Kong Dollar', 'wp-travel-pro' ),
		'HNL' => __( 'Honduran Lempira', 'wp-travel-pro' ),
		'HRK' => __( 'Croatian Kuna', 'wp-travel-pro' ),
		'HTG' => __( 'Haitian Gourde', 'wp-travel-pro' ),
		'HUF' => __( 'Hungarian Forint', 'wp-travel-pro' ),
		'IDR' => __( 'Indonesian Rupiah', 'wp-travel-pro' ),
		'ILS' => __( 'Israeli New Sheqel', 'wp-travel-pro' ),
		'IMP' => __( 'Manx pound', 'wp-travel-pro' ),
		'INR' => __( 'Indian Rupee', 'wp-travel-pro' ),
		'IQD' => __( 'Iraqi Dinar', 'wp-travel-pro' ),
		'IRR' => __( 'Iranian Rial', 'wp-travel-pro' ),
		'ISK' => __( 'Icelandic Króna', 'wp-travel-pro' ),
		'JEP' => __( 'Jersey Pound', 'wp-travel-pro' ),
		'JMD' => __( 'Jamaican Dollar', 'wp-travel-pro' ),
		'JOD' => __( 'Jordanian Dinar', 'wp-travel-pro' ),
		'JPY' => __( 'Japanese Yen', 'wp-travel-pro' ),
		'KES' => __( 'Kenyan Shilling', 'wp-travel-pro' ),
		'KGS' => __( 'Kyrgystani Som', 'wp-travel-pro' ),
		'KHR' => __( 'Cambodian Riel', 'wp-travel-pro' ),
		'KMF' => __( 'Comorian Franc', 'wp-travel-pro' ),
		'KPW' => __( 'North Korean Won', 'wp-travel-pro' ),
		'KRW' => __( 'South Korean Won', 'wp-travel-pro' ),
		'KWD' => __( 'Kuwaiti Dinar', 'wp-travel-pro' ),
		'KYD' => __( 'Cayman Islands Dollar', 'wp-travel-pro' ),
		'KZT' => __( 'Kazakhstani Tenge', 'wp-travel-pro' ),
		'LAK' => __( 'Laotian Kip', 'wp-travel-pro' ),
		'LBP' => __( 'Lebanese Pound', 'wp-travel-pro' ),
		'LKR' => __( 'Sri Lankan Rupee', 'wp-travel-pro' ),
		'LRD' => __( 'Liberian Dollar', 'wp-travel-pro' ),
		'LSL' => __( 'Lesotho Loti', 'wp-travel-pro' ),
		'LTL' => __( 'Lithuanian Litas', 'wp-travel-pro' ),
		'LVL' => __( 'Latvian Lats', 'wp-travel-pro' ),
		'LYD' => __( 'Libyan Dinar', 'wp-travel-pro' ),
		'MAD' => __( 'Moroccan Dirham', 'wp-travel-pro' ),
		'MDL' => __( 'Moldovan Leu', 'wp-travel-pro' ),
		'MGA' => __( 'Malagasy Ariary', 'wp-travel-pro' ),
		'MKD' => __( 'Macedonian Denar', 'wp-travel-pro' ),
		'MMK' => __( 'Myanma Kyat', 'wp-travel-pro' ),
		'MNT' => __( 'Mongolian Tugrik', 'wp-travel-pro' ),
		'MOP' => __( 'Macanese Pataca', 'wp-travel-pro' ),
		'MRO' => __( 'Mauritanian Ouguiya', 'wp-travel-pro' ),
		'MUR' => __( 'Mauritian Rupee', 'wp-travel-pro' ),
		'MVR' => __( 'Maldivian Rufiyaa', 'wp-travel-pro' ),
		'MWK' => __( 'Malawian Kwacha', 'wp-travel-pro' ),
		'MXN' => __( 'Mexican Peso', 'wp-travel-pro' ),
		'MYR' => __( 'Malaysian Ringgit', 'wp-travel-pro' ),
		'MZN' => __( 'Mozambican Metical', 'wp-travel-pro' ),
		'NAD' => __( 'Namibian Dollar', 'wp-travel-pro' ),
		'NGN' => __( 'Nigerian Naira', 'wp-travel-pro' ),
		'NIO' => __( 'Nicaraguan Córdoba', 'wp-travel-pro' ),
		'NOK' => __( 'Norwegian Krone', 'wp-travel-pro' ),
		'NPR' => __( 'Nepalese Rupee', 'wp-travel-pro' ),
		'NZD' => __( 'New Zealand Dollar', 'wp-travel-pro' ),
		'OMR' => __( 'Omani Rial', 'wp-travel-pro' ),
		'PAB' => __( 'Panamanian Balboa', 'wp-travel-pro' ),
		'PEN' => __( 'Peruvian Nuevo Sol', 'wp-travel-pro' ),
		'PGK' => __( 'Papua New Guinean Kina', 'wp-travel-pro' ),
		'PHP' => __( 'Philippine Peso', 'wp-travel-pro' ),
		'PKR' => __( 'Pakistani Rupee', 'wp-travel-pro' ),
		'PLN' => __( 'Polish Zloty', 'wp-travel-pro' ),
		'PYG' => __( 'Paraguayan Guarani', 'wp-travel-pro' ),
		'QAR' => __( 'Qatari Rial', 'wp-travel-pro' ),
		'RON' => __( 'Romanian Leu', 'wp-travel-pro' ),
		'RSD' => __( 'Serbian Dinar', 'wp-travel-pro' ),
		'RUB' => __( 'Russian Ruble', 'wp-travel-pro' ),
		'RWF' => __( 'Rwandan Franc', 'wp-travel-pro' ),
		'SAR' => __( 'Saudi Riyal', 'wp-travel-pro' ),
		'SBD' => __( 'Solomon Islands Dollar', 'wp-travel-pro' ),
		'SCR' => __( 'Seychellois Rupee', 'wp-travel-pro' ),
		'SDG' => __( 'Sudanese Pound', 'wp-travel-pro' ),
		'SEK' => __( 'Swedish Krona', 'wp-travel-pro' ),
		'SGD' => __( 'Singapore Dollar', 'wp-travel-pro' ),
		'SHP' => __( 'Saint Helena Pound', 'wp-travel-pro' ),
		'SLL' => __( 'Sierra Leonean Leone', 'wp-travel-pro' ),
		'SOS' => __( 'Somali Shilling', 'wp-travel-pro' ),
		'SRD' => __( 'Surinamese Dollar', 'wp-travel-pro' ),
		'STD' => __( 'São Tomé and Príncipe Dobra', 'wp-travel-pro' ),
		'SVC' => __( 'Salvadoran Colón', 'wp-travel-pro' ),
		'SYP' => __( 'Syrian Pound', 'wp-travel-pro' ),
		'SZL' => __( 'Swazi Lilangeni', 'wp-travel-pro' ),
		'THB' => __( 'Thai Baht', 'wp-travel-pro' ),
		'TJS' => __( 'Tajikistani Somoni', 'wp-travel-pro' ),
		'TMT' => __( 'Turkmenistani Manat', 'wp-travel-pro' ),
		'TND' => __( 'Tunisian Dinar', 'wp-travel-pro' ),
		'TOP' => __( 'Tongan Paʻanga', 'wp-travel-pro' ),
		'TRY' => __( 'Turkish Lira', 'wp-travel-pro' ),
		'TTD' => __( 'Trinidad and Tobago Dollar', 'wp-travel-pro' ),
		'TWD' => __( 'New Taiwan Dollar', 'wp-travel-pro' ),
		'TZS' => __( 'Tanzanian Shilling', 'wp-travel-pro' ),
		'UAH' => __( 'Ukrainian Hryvnia', 'wp-travel-pro' ),
		'UGX' => __( 'Ugandan Shilling', 'wp-travel-pro' ),
		'USD' => __( 'United States Dollar', 'wp-travel-pro' ),
		'UYU' => __( 'Uruguayan Peso', 'wp-travel-pro' ),
		'UZS' => __( 'Uzbekistan Som', 'wp-travel-pro' ),
		'VEF' => __( 'Venezuelan Bolívar Fuerte', 'wp-travel-pro' ),
		'VND' => __( 'Vietnamese Dong', 'wp-travel-pro' ),
		'VUV' => __( 'Vanuatu Vatu', 'wp-travel-pro' ),
		'WST' => __( 'Samoan Tala', 'wp-travel-pro' ),
		'XAF' => __( 'CFA Franc BEAC', 'wp-travel-pro' ),
		'XAG' => __( 'Silver (troy ounce)', 'wp-travel-pro' ),
		'XAU' => __( 'Gold (troy ounce)', 'wp-travel-pro' ),
		'XCD' => __( 'East Caribbean Dollar', 'wp-travel-pro' ),
		'XDR' => __( 'Special Drawing Rights', 'wp-travel-pro' ),
		'XOF' => __( 'CFA Franc BCEAO', 'wp-travel-pro' ),
		'XPF' => __( 'CFP Franc', 'wp-travel-pro' ),
		'YER' => __( 'Yemeni Rial', 'wp-travel-pro' ),
		'ZAR' => __( 'South African Rand', 'wp-travel-pro' ),
		'ZMK' => __( 'Zambian Kwacha (pre-2013)', 'wp-travel-pro' ),
		'ZMW' => __( 'Zambian Kwacha', 'wp-travel-pro' ),
		'ZWL' => __( 'Zimbabwean Dollar', 'wp-travel-pro' ),
	);

	return $currencies_name;
}


/**
 * Checks if use geo location feature or not.
 *
 * @return boolean
 */
function wp_travel_multiple_currency_use_geo_location() {
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$enable_geo_location = ! empty( $settings['enable_geo_location'] ) && isset( $settings['enable_geo_location'] ) ? $settings['enable_geo_location'] : '';
	$enable_geo_location = 'yes' === $enable_geo_location ? true : false;
	$use_geo_location    = apply_filters( 'wp_trave_multiple_currency_use_geo_location', $enable_geo_location );
	return $use_geo_location;
}

/**
 * Returns only rates according to the Currency symbols.
 *
 * @param string  $currency_symbol    Customer selected currency.
 * @param boolean $merge_custom_rates
 * @return void
 */
function wp_travel_multiple_currency_get_rates( $currency_symbol, $merge_custom_rates = true ) {
	if ( empty( $currency_symbol ) ) {
		return;
	}
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	// API provided rates according to selected base currency.
	$exchange_rates_data = WP_Travel_Multiple_Currency_Base_Currency::exchange_rates();
	// error_log( print_r( $exchange_rates_data, true ) );
	$exchange_rates = isset( $exchange_rates_data['rates'] ) && ! empty( $exchange_rates_data['rates'] ) ? $exchange_rates_data['rates'] : array();

	// User entered rates.
	$custom_added_rates          = ! empty( $settings['custom_conversions_values'] ) && isset( $settings['custom_conversions_values'] ) ? $settings['custom_conversions_values'] : array();
	$use_custom_conversion_rates = ! empty( $settings['use_custom_conversion_rates'] ) && isset( $settings['use_custom_conversion_rates'] ) ? $settings['use_custom_conversion_rates'] : '';

	if ( 'yes' === $use_custom_conversion_rates && ! empty( $custom_added_rates ) && count( $custom_added_rates ) > 0 ) {
		if ( $merge_custom_rates ) {
			if ( is_array( $exchange_rates ) && count( $exchange_rates ) > 0 ) {
				foreach ( $exchange_rates as $symbols => $exchange_rate ) {
					if ( isset( $custom_added_rates[ $symbols ] ) && ! empty( $custom_added_rates[ $symbols ] ) ) {
						$rates[ $symbols ] = $custom_added_rates[ $symbols ];
					} else {
						$rates[ $symbols ] = $exchange_rate;
					}
				}
				return isset( $rates[ $currency_symbol ] ) && ! empty( $rates[ $currency_symbol ] ) ? $rates[ $currency_symbol ] : '';
			}
		} else {
			return isset( $exchange_rates[ $currency_symbol ] ) && ! empty( $exchange_rates[ $currency_symbol ] ) ? $exchange_rates[ $currency_symbol ] : '';
		}
	} else {
		return isset( $exchange_rates[ $currency_symbol ] ) && ! empty( $exchange_rates[ $currency_symbol ] ) ? $exchange_rates[ $currency_symbol ] : '';
	}
}


/**
 * Converts the provided price according to the user selected currency.
 *
 * @since WP-Travel-Pro 3.0.4
 * @param float|int|string $price
 */
function wp_travel_multiple_currency_convert_price( $price ) {
	$rate = wtmc_get_conversion_rate();
	return (float)$price * $rate;
}

function wtmc_get_conversion_rate() {
	$selected_currency = WP_Travel_Multiple_Currency_Selector_Dropdown::get_customer_selected_currency();
	$rate              = wp_travel_multiple_currency_get_rates( $selected_currency );
	// $rate              = $rate ? $rate : 1;
	// $rate              = number_format( $rate, 2, '.', ''  );
	return $rate ? $rate : 1;
}

/**
 * Returns the array of currency codes(s) with their symbols attached.
 *
 * @param array|string $currency_code Currency code array or string.
 *                                    If array is passed then it should be the non associative array,
 *                                    were array value must be the currency code.
 * @param array        $args Arguments for manipulating the result.
 *
 * @uses wptravel_currency_symbols() from wp-travel
 * @since WP Travel Pro 3.0.4
 */
function wp_travel_multiple_currency_parse_symbols( $currency_code, $args = array() ) {

	if ( ! function_exists( 'wp_travel_currency_symbols' ) ) {
		return $currency_code;
	}

	if ( empty( $currency_code ) ) {
		return $currency_code;
	}

	$parsed = '';

	$default = array(
		'before_symbol'   => '(',
		'after_symbol'    => ')',
		'symbol_position' => 'left',
		'separator'       => '&nbsp;',
	);

	$args = wp_parse_args( $args, $default );

	$symbols = wptravel_currency_symbols();

	if ( is_array( $currency_code ) ) {

		$parsed = array();

		foreach ( $currency_code as $index => $code ) {

			$symbol = isset( $symbols[ $code ] ) ? $symbols[ $code ] : '';

			if ( $symbol ) {
				if ( 'left' === $args['symbol_position'] ) {
					$parsed[ $index ] = sprintf(
						'%1$s%2$s%3$s%4$s%5$s',
						$args['before_symbol'],
						$symbol,
						$args['after_symbol'],
						$args['separator'],
						$code
					);
				} else {
					$parsed[ $index ] = sprintf(
						'%1$s%2$s%3$s%4$s%5$s',
						$code,
						$args['separator'],
						$args['before_symbol'],
						$symbol,
						$args['after_symbol']
					);
				}
			} else {
				$parsed[ $index ] = $code;
			}
		}
	} else {

		$symbol = isset( $symbols[ $currency_code ] ) ? $symbols[ $currency_code ] : '';

		if ( $symbol ) {
			if ( 'left' === $args['symbol_position'] ) {
				$parsed = sprintf(
					'%1$s%2$s%3$s%4$s%5$s',
					$args['before_symbol'],
					$symbol,
					$args['after_symbol'],
					$args['separator'],
					$currency_code
				);
			} else {
				$parsed = sprintf(
					'%1$s%2$s%3$s%4$s%5$s',
					$currency_code,
					$args['separator'],
					$args['before_symbol'],
					$symbol,
					$args['after_symbol']
				);
			}
		} else {
			$parsed = $currency_code;
		}
	}

	return $parsed;

}


/**
 * * All the hooked functions has been moved to ./inc/hooks.php file
 *
 *  @since 3.0.4 ( WP Travel Pro )
 */


