<?php
/**
 * This file has all the required code for transient related work.
 *
 * @package multiple-currency-core/inc/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Multiple_Currency_API_Transient' ) ) {
	/**
	 * Class which store the data in transient and manipulate it.
	 */
	class WP_Travel_Multiple_Currency_API_Transient {

		/**
		 * Set the real time API data to transient and purge it automatically after 4 hours.
		 *
		 * @return void
		 */
		public static function set_api_data_to_transient() {
			$transient_api_data    = get_transient( 'wp_travel_multiple_currency_cached_api_data' );
			// Set api data to transient.
			if ( ! $transient_api_data ) {
				$api_data              = WP_Travel_Multiple_Currency_API_Data::get_api_data();
				$api_reset_time        = 4; // In hours.
				$transient_reset_timer = ( $api_reset_time * 60 ) * 60; // Convert into seconds ( 1 hours = 3600 sec ).
				// Run this if no transient is set.
				$transient_api_data = $api_data;
				set_transient( 'wp_travel_multiple_currency_cached_api_data', $transient_api_data, $transient_reset_timer );
			}
		}

		/**
		 * Gets the cached API data from transient.
		 * Sets the transient again if the transient is not set.
		 *
		 * @return array $transient_api_data API data of transient.
		 */
		public static function get_transient_api_data() {
			$transient_api_data = get_transient( 'wp_travel_multiple_currency_cached_api_data' );
			// If transient is empty or not set, call the API function to set the API data in transient.
			if ( ! $transient_api_data ) {
				self::set_api_data_to_transient();
			}

			return $transient_api_data;
		}

		/**
		 * Purge/Delete the transient
		 *
		 * @return void
		 */
		public static function transient_reset() {
			// phpcs:disable
			if ( isset( $_POST['multiple_currency_reset_transient'] ) ) {
				delete_transient( 'wp_travel_multiple_currency_cached_api_data' );
			}
			// phpcs:enable
		}
	}
}
