<?php
/**
 * This file has all the required code for selecting and changing base currency.
 *
 * @package multiple-currency-core/inc/
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Multiple_Currency_Base_Currency' ) ) {
	/**
	 * Class which get the selected currency, set that as base currency and display the value accordingly.
	 */
	class WP_Travel_Multiple_Currency_Base_Currency {

		/**
		 * Returns the selected general currency.
		 *
		 * @return string $general_selected_currency Returns the selected currency.
		 */
		public static function get_selected_currency() {
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}
			$general_selected_currency = isset( $settings['currency'] ) && ! empty( $settings['currency'] ) ? $settings['currency'] : '';

			return $general_selected_currency;
		}

		/**
		 * Returns the new exchange rates according to the selected base currency.
		 * Ignores the bitcoin
		 *
		 * @return array  $converted_rates.
		 */
		public static function converted_rates() {
			// phpcs:disable
			$converted_rates = array();
			$api_datas       = WP_Travel_Multiple_Currency_API_Transient::get_transient_api_data();
			// Has error on api.
			if ( $api_datas && is_array( $api_datas ) && ( ! isset( $api_datas['success'] ) || ( isset( $api_datas['success'] ) && ! $api_datas['success'] ) ) ) {
				if ( isset( $api_datas['error'] ) && isset( $api_datas['error']['code'] ) ) {
					$error_code = $api_datas['error']['code'];
					$error_type = $api_datas['error']['type'];
					$error_info = $api_datas['error']['info'];
					// @todo : Need to send email to admin about fixer api error. and also need to set transient for notification sent status check.
				}
			}
			$base_currency               = self::get_selected_currency();
			$api_datas                   = isset( $api_datas['rates'] ) && ! empty( $api_datas['rates'] ) ? $api_datas['rates'] : '';
			$default_base_currency_value = isset( $api_datas['EUR'] ) && ! empty( $api_datas['EUR'] ) ? $api_datas['EUR'] : ''; // Default base currency.
			$new_base_currency_value     = isset( $api_datas[ $base_currency ] ) && ! empty( $api_datas[ $base_currency ] ) ? $api_datas[ $base_currency ] : ''; // User selected currency.
			$base_exchange               = ! empty( $new_base_currency_value ) && ( $new_base_currency_value > 0 ) ? $default_base_currency_value / $new_base_currency_value : '';

			if ( ! empty( $base_exchange ) ) {
				if ( is_array( $api_datas ) && count( $api_datas ) > 0 ) {
					foreach( $api_datas as $currency_symbols => $exchange_rates ) {
						if ( 'BTC' != $currency_symbols ) {
							$converted_rates[ $currency_symbols ] = ( $exchange_rates * $base_exchange );
						}
					}
				}
			}
			// phpcs:enable
			return $converted_rates;
		}

		/**
		 * Returns the exchange rates according to the selected base currency.
		 *
		 * @return array $api_datas New exchange data
		 */
		public static function exchange_rates() {
			$converted_rates = self::converted_rates();
			if ( ! empty( $converted_rates ) ) {
				$exchange_rates_datas          = WP_Travel_Multiple_Currency_API_Transient::get_transient_api_data();
				$exchange_rates_datas['base']  = self::get_selected_currency();
				$exchange_rates_datas['rates'] = $converted_rates;

				return $exchange_rates_datas;
			}
		}
	}
}
