"use strict";

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

jQuery(function ($) {
  var optIn = $('#mailchimp_opt_in');
  var loader = $('#mc_lists_loader');
  optIn.on('change', function () {
    document.getElementById('mailchimp_opt_in').checked && $('.mc_opt_in').hide() || $('.mc_opt_in').show();
  });
  $(document).on('click', '#mc_lists_loader', function (e) {
    e.preventDefault();
    loader.removeClass('dashicons dashicons-image-rotate').addClass('spinner is-active');
    $.ajax({
      method: 'post',
      url: wp_travel_mailchimp.ajaxUrl,
      data: {
        action: 'mc_lists'
      }
    }).done(function (res) {
      loader.removeClass('spinner is-active').addClass('dashicons dashicons-image-rotate');
      var listSelector = $('#mailchimp_list_id');
      var options = listSelector.find('option');
      options = options.slice(1);
      options.each(function (option) {
        var self = this;
        $(self).remove();
      });
      var lists = typeof res.data.lists != 'undefined' ? Object.entries(res.data.lists) : [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = lists[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var _step$value = _slicedToArray(_step.value, 2),
              index = _step$value[0],
              list = _step$value[1];

          listSelector.append('<option value="' + index + '">' + list + '</option>');
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    });
  });
});
//# sourceMappingURL=wp-travel-mailchimp-script.js.map
