<?php
/**
 * Functions.
 *
 * @package wp-travel-paypal/inc/
 */


/**
 * Return Payment Gateway list.
 *
 * @param array $gateways Payment Gateways.
 */
function wp_travel_gateway_khalti( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['khalti'] = __( 'Khalti', 'wp-travel-pro' );
	return $gateways;
}

/**
 * Return Premium addons list.
 *
 * @param array $addons List of premium addons.
 */
function wp_travel_addons_khalti( $addons ) {
	$addons['khalti'] = __( 'Khalti', 'wp-travel-pro' );
	return $addons;
}

function wp_travel_add_vars_khalti( $args, $settings ) {
	if ( ! $args ) {
		return;
	}
	$publishable_key = isset( $settings['khalti_publishable_key'] ) ? $settings['khalti_publishable_key'] : '';

	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	if ( $test_mode ) {
		$publishable_key = isset( $settings['khalti_test_publishable_key'] ) ? $settings['khalti_test_publishable_key'] : '';
	}

	$args['payment']['khalti_publishable_key'] = $publishable_key;
	return $args;
}
