payments.khalti = function() {

}

jQuery(document).ready(function($) {
    var config = {
        // replace the publicKey with yours
        "publicKey": wp_travel.payment.khalti_publishable_key,
        "productIdentity": "-",
        "productName": "-",
        "productUrl": "-",
        "eventHandler": {
            onSuccess: function(payload) {
                // hit merchant api for initiating verfication
                var token = payload.token;
                var amount = payload.amount;
                if ( token ) {
                    response = JSON.stringify( payload );
                    complete(response);
                }
            },
            onError: function(error) {
                console.log(error);
            },
            onClose: function() {
                jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
                console.log('widget is closing');
            }
        }
    };

    var complete = function (response) {
        var form_id = 'wp-travel-booking'; // Default payment form id

        var payment_form_id = jQuery( '#wp-travel-payment-form-id' ).val();

        if ( payment_form_id ) {
            form_id = payment_form_id;
        }

        jQuery('.loader-active').show();
        khalti_remove();
        setTimeout(function() {
            jQuery( '[name=payment_details]' ).remove();
            jQuery( 'form#' + form_id ).append(jQuery("<input type='hidden' name='payment_details' />").attr("value", response ));
            jQuery( 'form#' + form_id ).find("[type=submit]").click();
        }, 2);
    };
    
    var khalti_trigger = function(e){
        jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
        var khalti_parsley = jQuery("#wp-travel-booking").parsley()
        e.preventDefault();
        var l = jQuery("[name=wp_travel_payment_mode]").attr("value");
        
        if ( $( '[name=complete_partial_payment]' ).length > 0 ) {
            o = $( '#wp-travel-amount' ).val(); // Added for partial payment.
        } else {
            o = "partial" == l ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
            if ( ! khalti_parsley.isValid() ) {
                return khalti_parsley.validate();
            }
        }

        var booking_option = $('[name=wp_travel_booking_option]').val();
        if ( 'booking_with_payment' === booking_option ) {
            if( o < 10) {
                alert('Khalti checkout does not accept amount less than 10.');
                return;
            }
            if ( 'NPR' !== wp_travel.payment.currency_code ) {
                alert('Khalti checkout only support NPR.');
                return;
            }
            o = parseInt( o * 100 ); // Convert Rupees to paisa.
            
            jQuery('.wp-travel-form-field.button-field').append('<i class="wt-icon wt-icon-spin wt-icon-spinner"></i>');

            fetch(wp_travel.ajaxUrl + "?action=inventory_testing"+wp_travel._nonce, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                  wp_travel_trip:
                    (typeof wp_travel.items != "undefined" && wp_travel.items) || Array(),
                  nonce: wp_travel.nonce,
                }),
                }).then(function (resp) {
                resp.json().then((responces) => {
                    if (responces.success == true) {
                        if (
                        typeof responces.data != "undefined" &&
                        typeof responces.data.code != "undefined" &&
                        typeof responces.data.inventory_available != "undefined" &&
                        responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" &&
                        responces.data.inventory_available == "no_pax"
                        ) {
                            if (confirm("Sorry your booking can't proceed, booking is full.")) {
                                fetch(
                                wp_travel.ajaxUrl + "?action=wp_travel_use_inventory_empty_cart"+ wp_travel._nonce,
                                {
                                    method: "POST",
                                    headers: { "Content-Type": "application/json" },
                                    body: JSON.stringify({
                                    wp_travel_empty_cart:
                                        (typeof wp_travel.items != "undefined" && wp_travel.items) ||
                                        Array(),
                                    }),
                                }
                                ).then((results) =>
                                results.json().then((resu) => {
                                    location.reload();
                                })
                                );
                            }
                        } else {
                            var checkout = new KhaltiCheckout(config);
                            checkout.show( { amount: o } );
                        }
                    } else {
                        var checkout = new KhaltiCheckout(config);
                        checkout.show( { amount: o } );
                    }
                });
            });      
        }
    }

    var khalti_checkout = function(){
        khalti_remove();
        var payment_gateway = jQuery('input[name=wp_travel_payment_gateway]:checked').val()
        var booking_option = jQuery('[name=wp_travel_booking_option]').val();

        if ( 'khalti' === payment_gateway && 'booking_with_payment' === booking_option ) {
            jQuery("#wp-travel-book-now, #wp-travel-complete-partial-payment").show().siblings().hide();
            jQuery(".paypal-button").remove();
            jQuery('[name=wp_travel_book_now], [name=complete_partial_payment]').click(khalti_trigger);
        }
    }

    var khalti_remove = function(){
        jQuery('[name=wp_travel_book_now]').off('click',khalti_trigger);
        jQuery('[name=complete_partial_payment]').off('click',khalti_trigger);
    }


    jQuery(document).on( 'change', '[name=wp_travel_booking_option]', function() {
        khalti_checkout();
    });
    jQuery(document).on('change', '[name=wp_travel_payment_gateway]', function(){
        if( jQuery('[name=wp_travel_payment_gateway]').length > 1  ) {
            khalti_checkout();
        }
    });

    // Khalti Checkout on load.    
    khalti_checkout();
    // Parsley validation on load.
    $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
});
