<?php
/**
 * Invoice Email Settings Functions.
 *
 * @package wp-travel-partial-payment/inc/admin/
 */

 /**
  * Settings for partial payment.
  *
  * @param String $tab   Name of tab.
  * @param Array  $args  Arguments.
  */
function wp_travel_invoice_email_templates_settings( $tab, $args ) {

	// Invoice client Defaults.
	$client_email_defaults = array(
		'client_subject' => __( 'Invoice Recieved', 'wp-travel-pro' ),
		'client_title'   => __( 'Invoice Recieved', 'wp-travel-pro' ),
		'client_header_color' => '',
		'email_content'  => wp_travel_invoice_client_default_email_content(),
		'from_email'     => get_option( 'admin_email' ),
	);

	// Invoice Client Email.
	$invoice_client_template = isset( $args['settings']['invoice_client_template'] ) && is_array( $args['settings']['invoice_client_template'] ) ? $args['settings']['invoice_client_template'] : array();

	$client_email_settings['client_subject'] = isset( $invoice_client_template['client_subject'] ) && $invoice_client_template['client_subject'] ? $invoice_client_template['client_subject'] : $client_email_defaults['client_subject'];
	$client_email_settings['client_title']   = isset( $invoice_client_template['client_title'] ) && $invoice_client_template['client_title'] ? $invoice_client_template['client_title'] : $client_email_defaults['client_title'];
	$client_email_settings['email_content']  = isset( $invoice_client_template['email_content'] ) && $invoice_client_template['email_content'] ? $invoice_client_template['email_content'] : $client_email_defaults['email_content'];
	$client_email_settings['from_email']     = isset( $invoice_client_template['from_email'] ) && $invoice_client_template['from_email'] ? $invoice_client_template['from_email'] : $client_email_defaults['from_email'];

	?>
	<div class="panel panel-default">
		<div class="panel-heading" role="tab" id="headingTwo">
			<h4 class="panel-title">
				<a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse-invoice" class="collapsed" aria-expanded="true" aria-controls="collapse-invoice">
					<?php esc_html_e( 'Invoice Email Templates', 'wp-travel-pro' ); ?>
					<span class="collapse-icon"></span>
				</a>
			</h4>
		</div>
		<div id="collapse-invoice" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
			<div class="panel-body">
				<div class="panel-wrap">
					<div class="wp-travel-email-template-options">

						<h3 class="section-heading"><?php esc_html_e( 'Client Email Template Options', 'wp-travel-pro' ); ?></h3>

						<table class="form-table">
							<tr>
								<th>
									<label for="partial-payment-client-email-sub"><?php esc_html_e( 'Invoice Email Subject', 'wp-travel-pro' ); ?></label>
								</th>
								<td>
									<input value="<?php echo $client_email_settings['client_subject']; ?>" type="text" name="invoice_client_template[client_subject]" id="partial-payment-client-email-sub">
								</td>
							</tr>
							<tr>
								<th>
									<label for="partial-payment-client-email-title"><?php esc_html_e( 'Invoice Email Title', 'wp-travel-pro' ); ?></label>
								</th>
								<td>
									<input type="text" value="<?php echo $client_email_settings['client_title']; ?>" name="invoice_client_template[client_title]" id="partial-payment-client-email-title">
								</td>
							</tr>
							
							<tr>
								<th>
									<label for="payment-client-email-content"><?php esc_html_e( 'Email Content', 'wp-travel-pro' ); ?></label>
								</th>
								<td>
									<?php
									$content = $client_email_settings['email_content'];
									wp_editor( $content, 'invoice_client_email_content', $settings = array( 'textarea_name' => 'invoice_client_template[email_content]' ) );
									?>
								</td>
							</tr>
						</table>
	
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
add_action( 'wp_travel_email_template_settings_after_enquiry', 'wp_travel_invoice_email_templates_settings', 10, 2 );

// This will add Invoice settings tab in the admin.
function wp_travel_invoice_settings_tab( $settings_fields ) {
	$settings_fields['invoice'] = array(
		'tab_label'     => __( 'Invoice', 'wp-travel-pro' ),
		'content_title' => __( 'Invoice Options', 'wp-travel-pro' ),
		'priority'      => 92,
		'callback'      => 'wp_travel_settings_callback_invoice',
		'icon'          => 'fa-file-invoice',
	);
	return $settings_fields;
}

// Invoice tab callback.
function wp_travel_settings_callback_invoice( $tab, $args ) {
	$settings          = $args['settings'];
	$enable_invoice    = isset( $settings['enable_invoice'] ) ? $settings['enable_invoice'] : 'no';
	$use_relative_path = isset( $settings['use_relative_path'] ) ? $settings['use_relative_path'] : 'yes';
	$invoice_address   = isset( $settings['invoice_address'] ) ? $settings['invoice_address'] : '';
	$invoice_contact   = isset( $settings['invoice_contact'] ) ? $settings['invoice_contact'] : '';
	$invoice_website   = isset( $settings['invoice_website'] ) ? $settings['invoice_website'] : '';

	$image_url    = '';
	$invoice_logo = isset( $settings['invoice_logo'] ) ? $settings['invoice_logo'] : '';

	$button_text = __( 'Select', 'wp-travel-pro' );
	if ( $invoice_logo ) {
		$button_text = __( 'Change', 'wp-travel-pro' );
		$image       = wp_get_attachment_image_src( $invoice_logo, 'thumbnail' );
		$image_url   = $image[0];
	}
	if ( '' === $image_url ) {
		$image_url = wptravel_get_post_placeholder_image_url();
	}
	?>
	<table class="form-table">
		<tr>
			<th>
				<label for="enable_invoice">
					<?php esc_html_e( 'Enable Invoice', 'wp-travel-pro' ); ?>
				</label>
			</th>
			<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input value="no" name="enable_invoice" type="hidden" />
						<input <?php checked( $enable_invoice, 'yes' ); ?> value="yes" name="enable_invoice" id="enable_invoice" type="checkbox" />
						<span class="switch"></span>
					</label>
				</span>
				<p class="description"><label for="enable_invoice"><?php esc_html_e( sprintf( 'This will enable %s invoice in the email.', WP_TRAVEL_POST_TITLE ), 'wp-travel', 'wp-travel-pro' ); ?></label></p>
			</td>
		</tr>
		<tr>
			<th>
				<label for="enable_invoice">
					<?php esc_html_e( 'Use Relative path', 'wp-travel-pro' ); ?>
				</label>
			</th>
			<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input value="no" name="use_relative_path" type="hidden" />
						<input <?php checked( $use_relative_path, 'yes' ); ?> value="yes" name="use_relative_path" id="use_relative_path" type="checkbox" />
						<span class="switch"></span>
					</label>
				</span>
				<p class="description"><label for="use_relative_path"><?php esc_html_e( sprintf( 'Use image path as var/www/html... instead of http to generate pdf invoice.' ), 'wp-travel-pro' ); ?></label></p>
			</td>
		</tr>
		<tr>
			<th><label for="currency"><?php echo esc_html__( 'Invoice Logo', 'wp-travel-pro' ); ?></label></th>
			<td>
				<div class="media-preview">
					<img class="img-preview" src="<?php echo esc_url( $image_url ); ?>" style="width:150px">
					<input class="wp-travel-custom-media-id" type="hidden" name="invoice_logo" value="<?php echo esc_html( $invoice_logo ); ?>">
				</div>
				<a data-button-change-text="<?php echo esc_attr( 'Change', 'wp-travel' ); ?>" data-uploader-title="<?php echo esc_attr( 'Select Image', 'wp-travel' ); ?>" data-uploader-button-text="<?php echo esc_attr( 'Choose', 'wp-travel' ); ?>" class="wp-travel-custom-media button button-primary button-large " >
					<?php echo esc_html( $button_text ); ?>
				</a>
			</td>
		</tr>

		<tr>
			<th><label for="currency"><?php echo esc_html__( 'Invoice Address', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input  value="<?php echo esc_attr( $invoice_address ); ?>" name="invoice_address" type="text" />
			</td>
		</tr>
		<tr>
			<th><label for="currency"><?php echo esc_html__( 'Invoice Contact', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input  value="<?php echo esc_attr( $invoice_contact ); ?>" name="invoice_contact" type="text" />
			</td>
		</tr>
		<tr>
			<th><label for="currency"><?php echo esc_html__( 'Invoice Website', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input  value="<?php echo esc_attr( $invoice_website ); ?>" name="invoice_website" type="text" />
			</td>
		</tr>
	</table>
	<?php
}
add_filter( 'wp_travel_settings_tabs', 'wp_travel_invoice_settings_tab', 15 );

// Save settings. email template along with invoice tab settings.
function wp_travel_invoice_settings_save( $settings ) {
	// Invoice Admin Email Settings.
	$partial_payment_admin_email_template_settings = ( isset( $_POST['partial_payment_admin_template'] ) && '' !== $_POST['partial_payment_admin_template'] ) ? stripslashes_deep( $_POST['partial_payment_admin_template'] ) : '';

	// Invoice Client Email Settings.
	$partial_payment_client_email_template_settings = ( isset( $_POST['invoice_client_template'] ) && '' !== $_POST['invoice_client_template'] ) ? stripslashes_deep( $_POST['invoice_client_template'] ) : '';

	// Remaining Invoice Reminder Email Options
	$remaining_partial_payment_reminder = ( isset( $_POST['remaining_partial_payment_reminder'] ) && '' !== $_POST['remaining_partial_payment_reminder'] ) ? stripslashes_deep( $_POST['remaining_partial_payment_reminder'] ) : '';

	$settings['partial_payment_admin_template'] = $partial_payment_admin_email_template_settings;
	$settings['invoice_client_template']        = $partial_payment_client_email_template_settings;

	$settings['remaining_partial_payment_reminder'] = $remaining_partial_payment_reminder;

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_invoice_settings_save' );

/**
 * Save data for v4.
 */
function wp_travel_invoice_email_templates_v4settings_save( $settings, $settings_data ) {

	// Invoice Client Email Settings.
	if ( isset( $settings_data['invoice_client_template'] ) && '' !== $settings_data['invoice_client_template'] ) {
		$settings['invoice_client_template'] = stripslashes_deep( $settings_data['invoice_client_template'] );
	}

	if ( isset( $settings_data['invoice_address'] ) && '' !== $settings_data['invoice_address'] ) {
		$settings['invoice_address'] = stripslashes_deep( $settings_data['invoice_address'] );
	}

	if ( isset( $settings_data['invoice_contact'] ) && '' !== $settings_data['invoice_contact'] ) {
		$settings['invoice_contact'] = stripslashes_deep( $settings_data['invoice_contact'] );
	}

	if ( isset( $settings_data['invoice_website'] ) && '' !== $settings_data['invoice_website'] ) {
		$settings['invoice_website'] = stripslashes_deep( $settings_data['invoice_website'] );
	}

	if ( isset( $settings_data['invoice_logo'] ) && '' !== $settings_data['invoice_logo'] ) {
		$settings['invoice_logo'] = stripslashes_deep( $settings_data['invoice_logo'] );
	}

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_invoice_email_templates_v4settings_save', 12, 2 );

/**
 * Settings for v4 fields.
 *
 * @param Array $settings_fields Settings data.
 * @return Array.
 */
function wp_travel_invoice_settings_fields( $settings_fields ) {

	$invoice_client_template['client_subject'] = isset( $settings_fields['invoice_client_template']['client_subject'] ) && '' !== $settings_fields['invoice_client_template']['client_subject'] ? $settings_fields['invoice_client_template']['client_subject'] : __( 'Invoice Recieved', 'wp-travel-pro' );
	$invoice_client_template['client_title']   = isset( $settings_fields['invoice_client_template']['client_title'] ) && '' !== $settings_fields['invoice_client_template']['client_title'] ? $settings_fields['invoice_client_template']['client_title'] : __( 'Invoice Recieved', 'wp-travel-pro' );
	$invoice_client_template['email_content']  = isset( $settings_fields['invoice_client_template']['email_content'] ) && '' !== $settings_fields['invoice_client_template']['email_content'] ? $settings_fields['invoice_client_template']['email_content'] : wp_travel_invoice_client_default_email_content();

	$settings_fields['invoice_client_template'] = $invoice_client_template;

	$settings_fields['enable_invoice']    = 'no';
	$settings_fields['use_relative_path'] = 'yes';

	$settings_fields['invoice_logo']    = '';
	$settings_fields['invoice_address'] = '';
	$settings_fields['invoice_contact'] = '';
	$settings_fields['invoice_website'] = '';

	return $settings_fields;
}
add_filter( 'wp_travel_settings_fields', 'wp_travel_invoice_settings_fields' );
