<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WP_Travel_Ajax_Trip_Inventory {

	/**
	 * Initialize Ajax requests.
	 */
	public static function init() {
		// Get Inventory.
		add_action( 'wp_ajax_wp_travel_get_inventory', array( __CLASS__, 'get_inventory' ) );
		add_action( 'wp_ajax_nopriv_wp_travel_get_inventory', array( __CLASS__, 'get_inventory' ) );

		// Update Inventory.
		add_action( 'wp_ajax_wp_travel_update_inventory', array( __CLASS__, 'update_inventory' ) );
		add_action( 'wp_ajax_nopriv_wp_travel_update_inventory', array( __CLASS__, 'update_inventory' ) );

	}

	public static function get_inventory() {
		$permission = self::inventory_permission_check();

		if ( is_wp_error( $permission ) ) {
			WP_Travel_Helpers_REST_API::response( $permission );
		} elseif ( false === $permission || null === $permission ) {
			$error = WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_INVALID_PERMISSION' );
			WP_Travel_Helpers_REST_API::response( $error );
		}

		$trip_id       = ! empty( $_GET['trip_id'] ) ? $_GET['trip_id'] : 0;
		$pricing_id    = ! empty( $_GET['pricing_id'] ) ? $_GET['pricing_id'] : 0;
		$selected_date = ! empty( $_GET['selected_date'] ) ? $_GET['selected_date'] : null;
		$times         = ! empty( $_GET['times'] ) ? $_GET['times'] : null;

		$args = array(
			'trip_id'       => $trip_id,
			'pricing_id'    => $pricing_id,
			'selected_date' => $selected_date,
			'times'         => $times,
		);

		$response = WP_Travel_Helpers_Inventory::get_inventory( $args );
		WP_Travel_Helpers_REST_API::response( $response );

	}

	public static function update_inventory() {
		$permission = self::inventory_permission_check();

		if ( is_wp_error( $permission ) ) {
			WP_Travel_Helpers_REST_API::response( $permission );
		} elseif ( false === $permission || null === $permission ) {
			$error = WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_INVALID_PERMISSION' );
			WP_Travel_Helpers_REST_API::response( $error );
		}

		$trip_id       = ! empty( $_GET['trip_id'] ) ? $_GET['trip_id'] : 0;
		$pricing_id    = ! empty( $_GET['pricing_id'] ) ? $_GET['pricing_id'] : 0;
		$selected_date = ! empty( $_GET['selected_date'] ) ? $_GET['selected_date'] : null;
		$time          = ! empty( $_GET['time'] ) ? $_GET['time'] : null;
		$pax           = ! empty( $_GET['pax'] ) ? $_GET['pax'] : 0;

		$args = array(
			'trip_id'       => $trip_id,
			'pricing_id'    => $pricing_id,
			'selected_date' => $selected_date,
			'time'          => $time,
			'pax'          => $pax,
		);

		$response = WP_Travel_Helpers_Inventory::update_inventory( $args );
		WP_Travel_Helpers_REST_API::response( $response );

	}


	// Security and permissions checks.
	public static function inventory_permission_check( $update_permission = false ) {

		/**
		 * Nonce Verification.
		 */
		if ( ! isset( $_REQUEST['_nonce'] ) || ! wp_verify_nonce( $_REQUEST['_nonce'], 'wp_travel_nonce' ) ) { // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash
			return WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_INVALID_NONCE' );
		}
		// Empty parameter.
		if ( empty( $_REQUEST['trip_id'] ) ) {
			return WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_NO_TRIP_ID' );
		}

		$trip = get_post( $_REQUEST['trip_id'] );
		if ( is_wp_error( $trip ) ) {
			return $trip;
		}

		if ( $trip && $update_permission ) {
			return self::check_update_permission( $trip );
		}

		if ( $trip ) {
			return self::check_read_permission( $trip );
		}

		return true;
	}

	protected static function check_read_permission( $post ) {
		$post_type = get_post_type_object( $post->post_type );

		// Is the post readable?
		if ( 'publish' === $post->post_status || current_user_can( $post_type->cap->read_post, $post->ID ) ) {
			return true;
		}

		return false;
	}

	protected static function check_update_permission( $post ) {
		$post_type = get_post_type_object( $post->post_type );
		return current_user_can( $post_type->cap->edit_post, $post->ID );
	}
}

WP_Travel_Ajax_Trip_Inventory::init();
