<?php
/**
 * Helper functions
 *
 * @package  WP-Travel-Instamojo-Checkout
 * @category Core
 * @author   WenSolutions
 */

 /**
  * Sum of amount of transaction.
  *
  * @param object $transaction A object of transaction.
  */
function wp_travel_instamojo_sum_amounts( $transaction ) {
	return $transaction->amount->total;
}

/**
 * Determine if post type is of wp travel
 */

function wp_travel_instamojo_is_itinerary(){
	if ( function_exists( 'is_itinerary' ) ) {
		return is_itinerary();
	}

	$slug = 'itinerary';
	/**
	 * Compatibility with new slug.
	 */
	$other_slug = 'trip';

	if ( defined( 'WP_TRAVEL_POST_TYPE' ) ) {
		return get_post_type() === WP_TRAVEL_POST_TYPE;
	}

	return get_post_type() === $slug || get_post_type() === $other_slug;
}
