<?php
/**
 * Functions.
 *
 * @package wp-travel-stripe/inc/admin/
 */


function wp_travel_settings_instamojo( $args ) {
	if ( ! $args ) {
		return;
	} ?>
	<table class="form-table wp-travel-instamojo-checkout-settings-form">
			<tbody class="instamojo-checkout-enable-or-disable">
				<tr>
					<th>
						<label for="enabled_instamojo_checkout"><?php esc_html_e( 'Enable instamojo checkout', 'wp-travel-pro' ); ?></label>
					</th>
					<td>
					<label for="enabled_instamojo_checkout">
						<span class="show-in-frontend checkbox-default-design">
							<label data-on="ON" data-off="OFF">
							<input value="no" name="payment_option_instamojo_checkout" type="hidden">
							<input class="enable-payment-gateway instamojo-checkout-enabled" value="yes" <?php isset( $args['settings']['payment_option_instamojo_checkout'] )  &&  checked( $args['settings']['payment_option_instamojo_checkout'],  'yes'  ); ?> type="checkbox" name="payment_option_instamojo_checkout" id="enabled_instamojo_checkout">
								<span class="switch">
								</span>
							</label>
						</span>
						<p class="description">Check to enable Instamojo Checkout.</p>
					</label>
					</td>
				</tr>
			</tbody>
			<tbody class="payment-gateway-fields">
				<tr class="wp-payment-instamojo-type wp_travel_instamojo_checkout">
					<th><label for="instamojo-checkout-client-id"><?php esc_html_e( 'Private API Key', 'wp-travel-pro' ); ?></label>
					</th>
					<td>
						<label>
						<input class="w-full" type="text" value="<?php isset($args['settings']['wp_travel_instamojo_checkout']['api_key']) && esc_attr_e($args['settings']['wp_travel_instamojo_checkout']['api_key'], 'wp-travel-pro'); ?>" name="wp_travel_instamojo_checkout[api_key]" id="wp_travel_instamojo_checkout_api_key"/></label>
						<p class="description"><?php esc_html_e( 'e.g. test_da0025f5d69d016f...', 'wp-travel-pro' ); ?></p>
					</td>
				</tr>
				<tr class="wp-payment-instamojo-type wp_travel_instamojo_checkout">
					<th><label for="instamojo-checkout-client-id"><?php esc_html_e( 'Private Auth Token', 'wp-travel-pro' ); ?>
					<p class="description">
						Get your credentials <a href="https://instamojo.com/integrations">here</a>
					</p>
				</label>
					</th>
					<td>
						<label>
						<input class="w-full" type="text" value="<?php isset($args['settings']['wp_travel_instamojo_checkout']['auth_token']) && esc_attr_e($args['settings']['wp_travel_instamojo_checkout']['auth_token'], 'wp-travel-pro'); ?>" name="wp_travel_instamojo_checkout[auth_token]" id="wp_travel_instamojo_checkout_auth_token"/></label>
						<p class="description"><?php esc_html_e( 'e.g. test_da0025f5d69d016f...', 'wp-travel-pro' ); ?></p>
					</td>
				</tr>
				<tr>
					<th colspan="2">
						<p class="description">
							Note: <em>This payment gateway works only with Indian (INR) currency.</em>
						</p>
					</th>
				</tr>
			</tbody>
	</table>
	<?php
}

add_action( 'wp_travel_payment_gateway_fields_instamojo_checkout', 'wp_travel_settings_instamojo' );

/**
 * Save settings v4.
 *
 * @param Array $settings Settings List.
 * @param Array $settings_data Settings data list.
 */
function wp_travel_settings_instamojo_save_v4( $settings, $settings_data ) {
	if ( ! $settings ) {
		return $settings;
	}
	foreach ( array( 'payment_option_instamojo_checkout', 'wp_travel_instamojo_checkout' ) as $key ) {

		if ( isset( $settings_data[ $key ] ) ) {
			$settings[ $key ] = $settings_data[ $key ];
		}
	}

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_settings_instamojo_save_v4', 10, 2 );

function wp_travel_settings_instamojo_save( $settings ) {
	if ( ! $settings ) {
		return $settings;
	}
	foreach ( array( 'payment_option_instamojo_checkout', 'wp_travel_instamojo_checkout' ) as $key ) {

		if ( isset( $_POST[ $key ] ) ) {
			$settings[ $key ] = $_POST[ $key ];
		}
	}

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_settings_instamojo_save' );
