<?php
/**
 * CSV Importer Class for WP Travel
 *
 * @package WP_Travel\inc\admin
 */
class WP_Travel_CSV_Importer {

	/**
	 * Constructor.
	 */
	public function __construct() {
	}

	/**
	 * Outputs Importer Page HTML.
	 *
	 * @return void
	 */
	public static function init() {
		?>
		<style>
		h1 {
			text-align: center;
		}

		.wptravel-dropzone {
			background: white;
			border-radius: 5px;
			border: 2px dashed rgb(0, 135, 247);
			border-image: none;
			max-width: 500px;
			margin-left: auto;
			margin-right: auto;
			padding: 25px;
		}
		#wptravel-dropzone h4 {
			margin-bottom: 10px;
		}
		#wptravel-dropzone .dz-message {
			text-align: center;
			padding-top: 20px;
		}
		</style>
		<h1><?php esc_html_e( 'WP Travel Import/Export', 'wp-travel-pro' ); ?></h1>
		<section>
			<div id="wptravel-dropzone">
				<form class="wptravel-dropzone needsclick" id="wt-csv-data-import" action="<?php echo esc_url( admin_url( 'admin-ajax.php?action=wp_travel_csv_import' ) ) ?>" method="post" accept-charset="utf-8"
					enctype="multipart/form-data">
					<h4>
						<label for="wt-import-csv-post-type"><?php esc_html_e( 'Post Type', 'wp-travel-pro' ); ?></label>
					</h4>
					<select style="width:calc(100% - 60px);" name="wt_import_csv_post_type" id="wt-import-csv-post-type">
						<?php
						$csv_supported = array(
							WP_TRAVEL_POST_TYPE   => __( 'Trips', 'wp-travel-pro' ),
							'itinerary-booking'   => __( 'Bookings', 'wp-travel-pro' ),
							'tour-extras'         => __( 'Trip Extras', 'wp-travel-pro' ),
							'wp-travel-payment'   => __( 'WP Travel Payments', 'wp-travel-pro' ),
							'itinerary-enquiries' => __( 'Enquiries', 'wp-travel-pro' ),
							'wp-travel-coupons'   => __( 'Coupons', 'wp-travel-pro' ),
						);
						foreach ( $csv_supported as $post_type => $label ) {
							?>
								<option value="<?php echo esc_attr( $post_type ); ?>"><?php echo esc_html( $label ); ?></option>
							<?php
						}
						?>
					</select>
					<span class="spinner wp_travel_importer"></span>
					<div class="dz-message needsclick">
						<?php esc_html_e( 'Drop files here or click to upload.', 'wp-travel-pro' ); ?><BR>
						<span
							class="note needsclick"><?php esc_html_e( 'Upload CSV file containing WP Travel data created by exporter. Import will start automatically.', 'wp-travel-pro' ); ?></span>
					</div>
					<input type="hidden" name="action" value="wp_travel_csv_import">
					<?php wp_nonce_field( 'wp_travel_csv_import_action', 'wp_travel_csv_import_nonce' ); ?>
				</form>
			</div>
		</section>
		<br />
		<div id="preview-template" style="display: none;">
			<div class="dz-preview dz-file-preview">
				<div class="dz-image"><IMG data-dz-thumbnail=""></div>
				<div class="dz-details">
					<div class="dz-size"><span data-dz-size=""></span></div>
					<div class="dz-filename"><span data-dz-name=""></span></div>
				</div>
			</div>
			<div class="dz-progress">
				<span class="dz-upload" data-dz-uploadprogress=""></span>
			</div>
			<div class="dz-error-message"><span data-dz-errormessage=""></span></div>
			<div class="dz-success-mark">
				<svg width="54px" height="54px" viewBox="0 0 54 54" version="1.1" xmlns="http://www.w3.org/2000/svg"
					xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
					<title><?php esc_html_e( 'Check', 'wp-travel-pro' ); ?></title>
					<desc><?php esc_html_e( 'Created with Sketch.', 'wp-travel-pro' ); ?></desc>
					<defs></defs>
					<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
						<path
							d="M23.5,31.8431458 L17.5852419,25.9283877 C16.0248253,24.3679711 13.4910294,24.366835 11.9289322,25.9289322 C10.3700136,27.4878508 10.36.6.02,30.0234455 11.9283877,31.5852419 L20.4147581,40.0716123 C20.5133999,40.1702541 20.6159315,40.2626649 20.7218615,40.3488435 C22.2835669,41.8725651 24.794234,41.8626202 26.3461564,40.3106978 L43.3106978,23.3461564 C44.8771021,21.7797521 44.8758057,19.2483887 43.3137085,17.6862915 C41.7547899,16.1273729 39.2176035,16.1255422 37.6538436,17.6893022 L23.5,31.8431458 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z"
							id="Oval-2" stroke-opacity="0.198794158" stroke="#747474" fill-opacity="0.816519475" fill="#FFFFFF"
							sketch:type="MSShapeGroup"></path>
					</g>
				</svg>
			</div>
			<div class="dz-error-mark">
				<svg width="54px" height="54px" viewBox="0 0 54 54" version="1.1" xmlns="http://www.w3.org/2000/svg"
					xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
					<title><?php esc_html_e( 'Error', 'wp-travel-pro' ); ?></title>
					<desc><?php esc_html_e( 'Created with Sketch.', 'wp-travel-pro' ); ?></desc>
					<defs></defs>
					<g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
						<g id="Check-+-Oval-2" sketch:type="MSLayerGroup" stroke="#747474" stroke-opacity="0.198794158"
							fill="#FFFFFF" fill-opacity="0.816519475">
							<path
								d="M32.6568542,29 L38.3106978,23.3461564 C39.8771021,21.7797521 39.8758057,19.2483887 38.3137085,17.6862915 C36.7547899,16.1273729 34.2176035,16.1255422 32.6538436,17.6893022 L27,23.3431458 L21.3461564,17.6893022 C19.7823965,16.1255422 17.2452101,16.1273729 15.6862915,17.6862915 C14.1241943,19.2483887 14.1228979,21.7797521 15.6893022,23.3461564 L21.3431458,29 L15.6893022,34.6538436 C14.1228979,36.2202479 14.1241943,38.7516113 15.6862915,40.3137085 C17.2452101,41.8726271 19.7823965,41.8744578 21.3461564,40.3106978 L27,34.6568542 L32.6538436,40.3106978 C34.2176035,41.8744578 36.7547899,41.8726271 38.3137085,40.3137085 C39.8758057,38.7516113 39.8771021,36.2202479 38.3106978,34.6538436 L32.6568542,29 Z M27,53 C41.3594035,53 53,41.3594035 53,27 C53,12.6405965 41.3594035,1 27,1 C12.6405965,1 1,12.6405965 1,27 C1,41.3594035 12.6405965,53 27,53 Z"
								id="Oval-2" sketch:type="MSShapeGroup"></path>
						</g>
					</g>
				</svg>
			</div>
		</div>
		<?php
	}

}
