jQuery(function ($) {
	var drop = $("input");
	drop.on('dragenter', function (e) {
		$(".wp-travel-importer-drop").css({
			"border": "4px dashed #09f",
			"background": "rgba(0, 153, 255, .05)"
		});
		$(".wp-travel-importer-cont").css({
			"color": "#09f"
		});
	}).on('dragleave dragend mouseout drop', function (e) {
		$(".wp-travel-importer-drop").css({
			"border": "3px dashed #DADFE3",
			"background": "transparent"
		});
		$(".wp-travel-importer-cont").css({
			"color": "#8E99A5"
		});
	});

	function handleFileSelect(evt) {
		var files = evt.target.files; // FileList object

		// Loop through the FileList and render image files as thumbnails.
		for (var i = 0, f; f = files[i]; i++) {

			// Only process image files.
			if (!f.type.match('image.*')) {
				continue;
			}

			var reader = new FileReader();

			// Closure to capture the file information.
			reader.onload = (function (theFile) {
				return function (e) {
					// Render thumbnail.
					var span = document.createElement('span');
					span.innerHTML = ['<img class="wp-travel-importer-thumb" src="', e.target.result,
						'" title="', escape(theFile.name), '"/>'
					].join('');
					document.getElementById('list').insertBefore(span, null);
				};
			})(f);

			// Read in the image file as a data URL.
			reader.readAsDataURL(f);
		}
	}

	$('#wp-travel-importer-files').change(handleFileSelect);

	Dropzone.autoDiscover = false;
	var dropzone = new Dropzone('#wt-csv-data-import', {
		previewTemplate: document.querySelector('#preview-template').innerHTML,
		parallelUploads: 2,
		thumbnailHeight: 120,
		thumbnailWidth: 120,
		maxFilesize: 5,
		maxFiles: 1,
		filesizeBase: 1000,
		url: wp_travel_import_export.ajaxUrl,
		acceptedFiles: '.csv',
		timeout: 15*60*1000,
		thumbnail: function (file, dataUrl) {
			if (file.previewElement) {
				file.previewElement.classList.remove("dz-file-preview");
				var images = file.previewElement.querySelectorAll("[data-dz-thumbnail]");
				for (var i = 0; i < images.length; i++) {
					var thumbnailElement = images[i];
					thumbnailElement.alt = file.name;
					thumbnailElement.src = dataUrl;
				}
				setTimeout(function () {
					file.previewElement.classList.add("dz-image-preview");
				}, 1);
			}
		},
		init: function () {
			this.on("maxfilesexceeded", function (file) {
				alert(wp_travel_import_export.limited);
				this.removeFile(file);
			});

			this.on("success", function (file, response) {
				$('.spinner.wp_travel_importer').removeClass('is-active');
				if (false === response.success) {
					swal({
						type: 'error',
						title: wp_travel_import_export.error,
						text: response.data.msg,
					})
				}
				if (true === response.success) {
					swal({
						type: 'success',
						title: wp_travel_import_export.success,
						text: response.data.msg,
					})
				}
				this.removeFile(file);
			});

			this.on('sending', function(){
				$('.spinner.wp_travel_importer').addClass('is-active');
			})
		}

	});
});
