jQuery(function ($) {
	'use strict';

	var HereMap = wp_travel_drag_drop_uploader.here_map;
	var adminMapContainer = 'wptHereMapAdmin';
	var appId = HereMap.app.id;
	var appCode = HereMap.app.code;
	var latLng = HereMap.latlng;
	var zoomlevel = parseInt(HereMap.zoomLevel);


	$(window).load(function(){

		if( appId == '' || appCode == '' ){
			return;
		}

		// Instantiate a map and platform object:
		var platform = new H.service.Platform({
			app_id: appId,
			app_code: appCode,
			useHTTPS: true
		}), marker;

		// var viewPort = new H.map.ViewPort(document.getElementById(adminMapContainer));

		// Get default map types from the platform object:
		var defaultLayers = platform.createDefaultLayers();

		// Instantiate the map:
		// var initMap  =function(){}
		var map = new H.Map(document.getElementById(adminMapContainer),
		defaultLayers.normal.map, {
			zoom: zoomlevel,
			center: latLng
		});

		map.addEventListener('mapviewchangeend', function(){
			$('.wpt-here-map-search-input-wrap').show();
		});

		var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));

		var ui = H.ui.UI.createDefault(map, defaultLayers);

		// Get an instance of the geocoding service:
		var geocoder = platform.getGeocodingService();

		/**
		 * Adds a  draggable marker to the map..
		 *
		 * @param {H.Map} map                      A HERE Map instance within the
		 *                                         application
		 * @param {H.mapevents.Behavior} behavior  Behavior implements
		 *                                         default interactions for pan/zoom
		 */
		var addDraggableMarker = function(map, behavior, latlng){
			marker = new H.map.Marker(latlng);
			// Ensure that the marker can receive drag events
			marker.draggable = true;
			map.addObject(marker);
			map.setCenter(latlng);

			// disable the default draggability of the underlying map
			// when starting to drag a marker object:
			map.addEventListener('dragstart', function(ev) {
				var target = ev.target;
				if (target instanceof H.map.Marker) {
					behavior.disable();
				}
			}, false);

			// re-enable the default draggability of the underlying map
			// when dragging has completed
			map.addEventListener('dragend', function(ev) {
				var target = ev.target,
				latInput = $('#wpt-here-map-lat'),
				lngInput = $('#wpt-here-map-lng');

				if (target instanceof mapsjs.map.Marker) {
					behavior.enable();
				}
				if( typeof target.b.lat !== 'undefined'){
					lngInput.val(target.b.lng);
					latInput.val(target.b.lat);
				}

			}, true);

			// Listen to the drag event and move the position of the marker
			// as necessary
			map.addEventListener('drag', function(ev) {
				var target = ev.target,
					pointer = ev.currentPointer;
				if (target instanceof mapsjs.map.Marker) {
					target.setPosition(map.screenToGeo(pointer.viewportX, pointer.viewportY));
				}
			}, false);
		}

		// Define a callback function to process the geocoding response:
		var onResult = function (result) {
			var locations = result.Response.View[0].Result,
				position,
				marker;
			// Add a marker for each location
			var suggestions = '<ul>';

			for (var i = 0; i < locations.length; i++) {
				position = {
					lat: locations[i].Location.DisplayPosition.Latitude,
					lng: locations[i].Location.DisplayPosition.Longitude
				};
				suggestions += '<li data-label="' + locations[i].Location.Address.Label + '" data-lat="' + position.lat + '" data-lng="' + position.lng + '">' +  locations[i].Location.Address.Label + '</li>';
				// marker = new H.map.Marker(position);
				// map.addObject(marker);
				// map.setCenter(position);
			}
			suggestions += '</ul>';
			$('#wpt-here-map-results').html(suggestions).attr('aria-expanded', 'true').show();
		};

		// Call the geocode method with the geocoding parameters,
		// the callback and an error callback function (called if a
		// communication error occurs):
		$('#wpt-here-map-search-input').on('keyup',function(){
			geocoder.geocode({searchText : this.value}, onResult, function (e) {
				alert(e);
			});
		});

		$('#wpt-here-map-search-input').on('keypress', function(e){
			if(e.keyCode == 13){
				e.preventDefault ? e.preventDefault() : (e.returnValue = false);
			}
		})

		$(document).on('click', '#wpt-here-map-results li', function(){
			var position,
			latInput = $('#wpt-here-map-lat'),
			lngInput = $('#wpt-here-map-lng');

			$('#wpt-here-map-search-input').val(this.dataset.label);
			position = {lat: this.dataset.lat, lng: this.dataset.lng};
			latInput.val(position.lat);
			lngInput.val(position.lng);
			map.removeObject(marker);
			addDraggableMarker(map, behavior, position);
		});

		$("#wpt-here-map-lat, #wpt-here-map-lng").on('change keyup', function () {
			var position = {},
			latInput = $('#wpt-here-map-lat'),
			lngInput = $('#wpt-here-map-lng');

			position['lat'] = latInput.val();
			position['lng'] = lngInput.val();
			map.removeObject(marker);
			addDraggableMarker(map, behavior, position);
		})

		$(window).click(function() {
			var mapResultsWrap = $('#wpt-here-map-results');
			if( mapResultsWrap.attr('aria-expanded') == 'true' ) {
				mapResultsWrap.html('').attr('aria-expanded', 'false');
			}
		});

		$('#wp-travel-tab-locations').click(function(){
			map.getViewPort().resize();
		});

		addDraggableMarker(map, behavior, latLng);
	});

});
