Number.prototype.format = function(n, x, s, c) {
    var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\D' : '$') + ')';
    if ( isFinite(this) ) { // check if this is number or not.
        var num = this.toFixed(Math.max(0, ~~n));
        return (c ? num.replace('.', c) : num).replace(new RegExp(re, 'g'), '$&' + (s || ','));
    }
    return;
};

jQuery(document).ready( function($) {
    $(document).on('change', 'input.paxpicker-input', function() {
        var parent = $(this).data('parent-id');

        var trip_id = $( '#' + parent ).find('input[name="trip_id"]').val();
        var price_key = $( '#' + parent ).find('input[name="price_key"]').val();
        var pax = $(this).val();
        var category_id = $(this).data('category-id');
        var pricing_id = $( '#' + parent ).find('input[name="pricing_id"]').val();

        var data = {
            action: 'wt_group_discount_price', 
            security : wp_travel.nonce,
            trip_id: trip_id,
            price_key: price_key,
            pax: pax,
            pricing_id:pricing_id,
            category_id:category_id,
        }
        $.ajax({
            type: "POST",
            url: wp_travel.ajaxUrl,
            data: data,
            beforeSend: function() {},
            success: function(data) {
                if (data.price) {
                    wp_travel_update_price_display( data.price, parent, category_id );
                }
            }
        });
    });

    function wp_travel_update_price_display( price, parent_id, category_id ) {
        if ( price ) {
            var fields = '#' + parent_id + ' .category#' + category_id + ' .wp-travel-trip-price-figure';
            price = parseFloat(price);
            var thousand_separator = ( wp_travel.thousand_separator ) ? wp_travel.thousand_separator : ',';
            var decimal_separator = ( wp_travel.decimal_separator ) ? wp_travel.decimal_separator : '.';
            var number_of_decimals = ( wp_travel.number_of_decimals ) ? wp_travel.number_of_decimals : 2;
            var formated_price = price.format( number_of_decimals, 3, thousand_separator, decimal_separator );
            $( fields ).html(formated_price);
        }
    }

    $(document).on( 'click', '.wp-travel-group-discount-view-detail', function(e) {
        // if ( ! $(this).closest('li').hasClass( 'pricing_unavailable' ) ) {
            $(this).closest('.wp-travel-see-group-discount').siblings('.wp-travel-see-group-discount-content').toggle('fast', function() {
                
            });
        // }
    } );
    $(document).on( 'click', '.wp-travel-see-group-discount-close', function() {
        $(this).closest('.wp-travel-see-group-discount-content').toggle('fast' );

    } );
} );

