jQuery(document).ready(function ($) {
    // Add Group Discount row.
    $(document).on('click', '.add-group-discount', function (e) {
        e.preventDefault();
        var parent_id = $(this).data('parent-id');
        var index = $(this).data('index');
        var category_id = $(this).data('category_id');
        if (!parent_id)
            return;

        // var row = $(this).closest('.wp-travel-group-discount').siblings('.panel-wrap ').children('.repeat-row');
        var row = $(this).closest('.panel-wrap ').children('.repeat-row');
        var max = row.find('.pricing-opt-max-pax').val(); // Max allowed pax
        var min = row.find('.pricing-opt-min-pax').val();  // default min val.
        if (!min || !max) {
            alert('Please set min and max pax');
            return;
        }
        max = parseInt(max);

        if ($('#' + parent_id + ' .pax-to input').length) {  // Not dive into loop if no element.
            var max_input_val = 1; // any value.
            $('#' + parent_id + ' .pax-to input').each(function () {
                if ($(this).val() > max_input_val) {
                    max_input_val = $(this).val(); // max value used in input fields. so next min value must be current max value + 1;
                }
            });
            min = parseInt(max_input_val) + 1;
        }
        if (min > max) {
            alert('Sorry max limit is ' + max);
            return;
        }

        var template = wp.template('wp-travel-group-discount');
        $('#' + parent_id + '.wp-travel-group-discount-content .table-row-container').append(template({ min: min, max: max, parent_id: parent_id, index: index, category_id: category_id }));
        show_group_discount_unavailable_row(parent_id);
    });

    $(document).on('click', '.remove-grop-discount', function (e) {
        e.preventDefault();
        var c = confirm('Are you sure to remove row?');
        if (c) {
            $(this).closest('.table-row').remove();
            parent_id = $(this).data('parent-id');
            show_group_discount_unavailable_row(parent_id);
        }
    });

    $(document).on('change', '.pax-from input', function (e) {

        e.preventDefault();
        var current_val = $(this).val();
        if (current_val) {
            current_val = parseInt(current_val);
        }
        // set min value of current pax to.
        var pax_to = $(this).closest('.pax-from').siblings('.pax-to').children('input');
        pax_to.attr('min', current_val);

        // set min value of next pax from.
        var next_pax_from = $(this).closest('.table-row').next('.table-row').children('.pax-from').find('input');
        if (next_pax_from.length) {
            next_pax_from.attr('min', (current_val + 1));
        }
    });

    $(document).on('change', '.pax-to input', function (e) {
        e.preventDefault();

        var current_val = $(this).val();
        var max = $(this).data('max');
        if (current_val) {
            current_val = parseInt(current_val);
        }
        if (max) {
            max = parseInt(max);
        }
        // set max value of current pax from.
        var pax_from = $(this).closest('.pax-to').siblings('.pax-from').children('input');
        pax_from.attr('max', current_val);

        // set min value of next pax from.
        var next_pax_from = $(this).closest('.table-row').next('.table-row').children('.pax-from').find('input');
        if (next_pax_from.length) {

            if (current_val >= max) {
                // Remove all row after current row if current row val set to max.
                $(this).closest('.table-row').nextAll('.table-row').remove();

                // var parent_id = $(this).closest('.wp-travel-group-discount-content').attr('id');
                // check any empty row and remove [not reqd this if all fields set to require]
                // $('#' + parent_id + ' .pax-from input').each(function () {
                //     var pax_from = $(this).val();
                //     var pax_to = $(this).closest('.table-row').children('.pax-to').find('input').val();

                //     if (!pax_from || !pax_to) {
                //         $(this).closest('.table-row').remove();
                //     }
                // });

            } else {

                next_pax_from.attr('min', (current_val + 1));
            }
        }

    });
    function show_group_discount_unavailable_row(parent_id) {
        var group_discount_row = $('#' + parent_id + '.wp-travel-group-discount-content .table-row').length;
        var unavailbale_element = $('#' + parent_id + ' .group-discount-unavailable');
        unavailbale_element.hide();
        if (!group_discount_row) {
            unavailbale_element.show();
        }
    }

    $( document ).on( 'click', '.enable_group_discount', function(e) {
        $(this).closest('.repeat-row').siblings('.group-discount-table').addClass('hidden');
        $(this).closest('.repeat-row').find('.view-group-discount-table ').addClass('hidden')

        if ( $(this).is( ':checked' ) ) {
            $(this).closest('.repeat-row').siblings('.group-discount-table').removeClass('hidden');
            $(this).closest('.repeat-row').find('.view-group-discount-table ').removeClass('hidden')
        }
    } );

    $( document ).on( 'click', '.view-group-discount-table', function(e) {
        e.preventDefault();
        if ( $(this).data('display-table') == '0' ) {
            $(this).closest('.wp-travel-group-discount').find('.wp-travel-group-discount-content').removeClass('hidden');
            $(this).data('display-table', '1').html( $(this).data('label-hide') );
        } else {
            $(this).closest('.wp-travel-group-discount').find('.wp-travel-group-discount-content').addClass('hidden')
            $(this).data('display-table', '0').html( $(this).data('label-show') );
        }
    } );
    

});
