/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./inc/modules/group-discount-core/app/src/admin/trip-edit/GroupDiscount.js":
/*!**********************************************************************************!*\
  !*** ./inc/modules/group-discount-core/app/src/admin/trip-edit/GroupDiscount.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);





/* harmony default export */ __webpack_exports__["default"] = (_ref => {
  let {
    priceIndex,
    catIndex
  } = _ref;
  const {
    pricings
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.useSelect)(select => {
    return select('WPTravel/TripEdit').getAllStore();
  }, []);
  const {
    updateTripPricing
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.dispatch)('WPTravel/TripEdit');
  let price = pricings[priceIndex];
  let priceCategory = 'undefined' === typeof pricings[priceIndex].categories[catIndex] ? [] : pricings[priceIndex].categories[catIndex];

  // let has_group_price = 'undefined' === typeof price.has_group_price ? false : price.has_group_price;
  let pricing_has_group_price = 'undefined' === typeof price.has_group_price ? false : price.has_group_price;
  let has_group_price = 'undefined' === typeof priceCategory.has_group_price ? false : priceCategory.has_group_price;
  let group_prices = 'undefined' === typeof priceCategory.group_prices ? [] : priceCategory.group_prices;
  let addGroupPrice = () => {
    let priceData = price;
    let priceCategoryData = priceCategory;
    priceCategoryData.group_prices = [...group_prices, {
      min_pax: '',
      max_pax: '',
      price: ''
    }];
    priceData.categories[catIndex] = priceCategoryData;
    updateTripPricing(priceData, priceIndex);
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, !pricing_has_group_price && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("hr", null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Enable Group Price', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-right"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
    checked: priceCategory.has_group_price,
    onChange: () => {
      let priceData = price;
      let priceCategoryData = priceCategory;
      priceCategoryData.has_group_price = !priceCategory.has_group_price;
      priceData.categories[catIndex] = priceCategoryData;
      updateTripPricing(priceData, priceIndex);
    }
  })))), has_group_price && !pricing_has_group_price && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
    className: "wp-travel-has-child-panel"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Group Prices', 'wp-travel-pro'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
    className: "wp-travel-has-child-panel"
  }, group_prices.length > 0 ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("table", {
    className: "wp-list-table widefat  striped "
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("thead", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Min Pax', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Max Pax', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Price', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tbody", null, group_prices.length > 0 ? group_prices.map((groupPrice, groupPriceIndex) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    type: "number",
    min: "0",
    autoComplete: "off",
    value: groupPrice.min_pax,
    onChange: min_pax => {
      let priceData = price;
      let priceCategoryData = priceCategory;
      priceCategoryData.group_prices[groupPriceIndex].min_pax = min_pax;
      priceData.categories[catIndex] = priceCategoryData;
      updateTripPricing(priceData, priceIndex);
    }
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    type: "number",
    min: "0",
    autoComplete: "off",
    value: groupPrice.max_pax,
    onChange: max_pax => {
      let priceData = price;
      let priceCategoryData = priceCategory;
      priceCategoryData.group_prices[groupPriceIndex].max_pax = max_pax;
      priceData.categories[catIndex] = priceCategoryData;
      updateTripPricing(priceData, priceIndex);
    }
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    value: groupPrice.price,
    onChange: gprice => {
      let priceData = price;
      let priceCategoryData = priceCategory;
      priceCategoryData.group_prices[groupPriceIndex].price = gprice;
      priceData.categories[catIndex] = priceCategoryData;
      updateTripPricing(priceData, priceIndex);
    }
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.IconButton, {
    icon: "trash",
    label: "Delete",
    onClick: () => {
      if (!confirm((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Are you sure to delete group price?', 'wp-travel-pro'))) {
        return false;
      }
      let priceData = price;
      let priceCategoryData = priceCategory;
      priceCategoryData.group_prices = group_prices.filter((groupPriceFilter, groupPriceFilterIndex) => {
        return groupPriceIndex != groupPriceFilterIndex;
      });
      priceData.categories[catIndex] = priceCategoryData;
      updateTripPricing(priceData, priceIndex);
    }
  })))) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    colSpan: "4"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('No Group Price.', 'wp-travel-pro'))))) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Notice, {
    isDismissible: false,
    actions: [{
      'label': 'Add Group Price',
      onClick: () => {
        addGroupPrice();
      },
      noDefaultClasses: true,
      className: 'is-link'
    }]
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('No Group Price found.', 'wp-travel-pro'))), group_prices.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
    className: "wp-travel-action-section has-right-padding"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    isDefault: true,
    onClick: () => addGroupPrice()
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('+ Add Group Price', 'wp-travel-pro'))), " "));
});

/***/ }),

/***/ "./inc/modules/group-discount-core/app/src/admin/trip-edit/GroupDiscountPricing.js":
/*!*****************************************************************************************!*\
  !*** ./inc/modules/group-discount-core/app/src/admin/trip-edit/GroupDiscountPricing.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/components */ "@wordpress/components");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/i18n */ "@wordpress/i18n");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);




/* harmony default export */ __webpack_exports__["default"] = (_ref => {
  let {
    allData,
    price,
    priceIndex
  } = _ref;
  const {
    has_group_price,
    group_prices
  } = price;
  const {
    updateTripPricing
  } = (0,_wordpress_data__WEBPACK_IMPORTED_MODULE_2__.dispatch)('WPTravel/TripEdit');
  let groupPricesData = 'undefined' != typeof group_prices ? group_prices : [];
  let addGroupPrice = () => {
    let priceData = price;
    priceData.group_prices = [...groupPricesData, {
      min_pax: '',
      max_pax: '',
      price: ''
    }];
    updateTripPricing(priceData, priceIndex);
  };
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Enable Group Price', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("div", {
    className: "text-right"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.ToggleControl, {
    checked: has_group_price,
    onChange: () => {
      let priceData = price;
      priceData.has_group_price = !priceData.has_group_price;
      updateTripPricing(priceData, priceIndex);
    }
  }), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("p", {
    className: "description"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("i", null, "This will enable group discount for pricing.")))), has_group_price && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
    className: "wp-travel-has-child-panel"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("label", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Group Prices', 'wp-travel-pro'))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
    className: "wp-travel-has-child-panel"
  }, 'undefined' !== typeof group_prices && group_prices.length > 0 ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("table", {
    className: "wp-list-table widefat striped "
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("thead", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Min Pax', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Max Pax', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Price', 'wp-travel-pro')), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null))), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tbody", null, group_prices.length > 0 ? group_prices.map((groupPrice, groupPriceIndex) => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    type: "number",
    min: "0" == groupPriceIndex ? 1 : parseInt(group_prices[groupPriceIndex - 1].max_pax) + 1,
    max: 'undefined' != typeof price.max_pax && price.max_pax > 0 ? price.max_pax : null,
    autoComplete: "off",
    value: groupPrice.min_pax,
    onChange: min_pax => {
      let priceData = price;
      priceData.group_prices[groupPriceIndex].min_pax = min_pax;
      updateTripPricing(priceData, priceIndex);
    }
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    type: "number",
    min: groupPrice.min_pax ? parseInt(groupPrice.min_pax) : 0,
    max: 'undefined' != typeof price.max_pax ? price.max_pax : null,
    autoComplete: "off",
    value: groupPrice.max_pax,
    onChange: max_pax => {
      let priceData = price;
      priceData.group_prices[groupPriceIndex].max_pax = max_pax;
      updateTripPricing(priceData, priceIndex);
    }
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.TextControl, {
    type: "number",
    step: "0.01",
    value: groupPrice.price,
    onChange: gprice => {
      let priceData = price;
      priceData.group_prices[groupPriceIndex].price = gprice;
      updateTripPricing(priceData, priceIndex);
    }
  })), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.IconButton, {
    icon: "trash",
    label: "Delete",
    onClick: () => {
      if (!confirm((0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('Are you sure to delete group price?', 'wp-travel-pro'))) {
        return false;
      }
      let priceData = price;
      priceData.group_prices = group_prices.filter((groupPriceFilter, groupPriceFilterIndex) => {
        return groupPriceIndex != groupPriceFilterIndex;
      });
      updateTripPricing(priceData, priceIndex);
    }
  })))) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("tr", null, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("td", {
    colSpan: "4"
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('No Group Price.', 'wp-travel-pro'))))) : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Notice, {
    isDismissible: false,
    actions: [{
      'label': 'Add Group Price',
      onClick: () => {
        addGroupPrice();
      },
      noDefaultClasses: true,
      className: 'is-link'
    }]
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('No Group Price found.', 'wp-travel-pro'))), 'undefined' !== typeof group_prices && group_prices.length > 0 && (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.PanelRow, {
    className: "wp-travel-action-section has-right-padding"
  }, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)("span", null), (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__.Button, {
    isDefault: true,
    onClick: () => addGroupPrice()
  }, (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__.__)('+ Add Group Price', 'wp-travel-pro'))), " "));
});

/***/ }),

/***/ "@wordpress/components":
/*!************************************!*\
  !*** external ["wp","components"] ***!
  \************************************/
/***/ (function(module) {

module.exports = window["wp"]["components"];

/***/ }),

/***/ "@wordpress/data":
/*!******************************!*\
  !*** external ["wp","data"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["data"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ (function(module) {

module.exports = window["wp"]["element"];

/***/ }),

/***/ "@wordpress/hooks":
/*!*******************************!*\
  !*** external ["wp","hooks"] ***!
  \*******************************/
/***/ (function(module) {

module.exports = window["wp"]["hooks"];

/***/ }),

/***/ "@wordpress/i18n":
/*!******************************!*\
  !*** external ["wp","i18n"] ***!
  \******************************/
/***/ (function(module) {

module.exports = window["wp"]["i18n"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	!function() {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = function(module) {
/******/ 			var getter = module && module.__esModule ?
/******/ 				function() { return module['default']; } :
/******/ 				function() { return module; };
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
!function() {
/*!**************************************************************************!*\
  !*** ./inc/modules/group-discount-core/app/src/admin/trip-edit/index.js ***!
  \**************************************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _GroupDiscount__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GroupDiscount */ "./inc/modules/group-discount-core/app/src/admin/trip-edit/GroupDiscount.js");
/* harmony import */ var _GroupDiscountPricing__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GroupDiscountPricing */ "./inc/modules/group-discount-core/app/src/admin/trip-edit/GroupDiscountPricing.js");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/hooks */ "@wordpress/hooks");
/* harmony import */ var _wordpress_hooks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/data */ "@wordpress/data");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_4__);






// Category Group Discount [default]
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.addFilter)('wp_travel_after_pricings_category_fields', 'wp_travel', function (content) {
  // content.splice(0, 1)
  return [...content, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_GroupDiscount__WEBPACK_IMPORTED_MODULE_1__["default"], {
    key: "group-discount",
    priceIndex: arguments.length <= 1 ? undefined : arguments[1],
    catIndex: arguments.length <= 2 ? undefined : arguments[2]
  })];
}, 15);
(0,_wordpress_hooks__WEBPACK_IMPORTED_MODULE_3__.addFilter)('wptravel_pricings_after_max_pax', 'wp_travel', function (content) {
  // content.splice(0, 1)
  return [...content, (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createElement)(_GroupDiscountPricing__WEBPACK_IMPORTED_MODULE_2__["default"], {
    key: "group-discount",
    allData: arguments.length <= 1 ? undefined : arguments[1],
    price: arguments.length <= 2 ? undefined : arguments[2],
    priceIndex: arguments.length <= 3 ? undefined : arguments[3]
  })];
}, 15);
}();
/******/ })()
;
//# sourceMappingURL=admin-group-discount.js.map