<?php
/**
 * Authenticates Google User and Creates Event of Booked Trip into Google Calendar
 */
 
class WPTravel_Google_Calendar {

	public static $auth_url;
	public static $client;
	public static $client_id;
	public static $client_secret;
	public static $token;
	public static $first_name;
	public static $last_name;
	public static $trip_title;
	public static $trip_total;
	public static $trip_pax;
	public static $trip_edit_url;
	public static $trip_duration;
	public static $trip_id;
	public static $date_id;
	public static $trip_time;
	public static $trip_location;
	public static $timezone;
	public static $mail;
	public static $number;
	public static $departure_date;
	public static $arrival_date;
	public static $refresh_token;
	public static $booking_info;
	public static $url = 'https://oauth2.googleapis.com/token';


	/**
	 * Init Method.
	 * Client Id,Client Secret,Redirect Url is used from wptravel_get_settings.
	 * Goole Client is used to generate Auth url and get refresh token from the google.
	 * Refresh Token is saved into WP Travel Settings.
	 */
	public static function init() {
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings(); // Backward Compatibility.
		}
		if ( ! $settings['google_api_client_id'] || ! $settings['google_api_client_secret'] ) {
			return;
		}
		self::$client_id     = $settings['google_api_client_id'];
		self::$client_secret = $settings['google_api_client_secret'];
		$redirect_url        = WpTravel_Google_Calendar_Core::get_redirect_url();

		$client = new Google\Client();
		$client->setClientId( self::$client_id );
		$client->setClientSecret( self::$client_secret );
		$client->setRedirectUri( $redirect_url );
		$client->addScope( 'https://www.googleapis.com/auth/calendar.events' );
		$client->setAccessType( 'offline' );
		$client->setPrompt( 'consent' );
		self::$client = $client;
		$authUrl      = $client->createAuthUrl();

		self::$auth_url = $authUrl;
		if ( isset( $_GET['code'] ) ) {
			$token       = $client->fetchAccessTokenWithAuthCode( $_GET['code'] );
			self::$token = $token;
			$client->setAccessToken( $token );
			$settings['google_calendar_refresh_token'] = $token['refresh_token'];
			update_option( 'wp_travel_settings', $settings );
		}
		self::$refresh_token = isset( $settings['google_calendar_refresh_token'] ) ? $settings['google_calendar_refresh_token'] : '';

		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'load_scripts' ) );
		add_action( 'wp_travel_after_frontend_booking_save', array( __CLASS__, 'wp_travel_after_frontend_booking' ), 12, 2 );
	}


	/**
	 * Access Token is Generated from refresh token.
	 */
	public static function getAccessTokenByRefreshToken( $refresh_token, $oauths ) {
		$data = array(
			'client_id'     => $oauths['client_id'],
			'client_secret' => $oauths['client_secret'],
			'refresh_token' => $refresh_token,
			'grant_type'    => 'refresh_token',
		);

		$res = self::send_http_post( $oauths['token_uri'], $data );

		return $res;
	}

	public static function send_http_post( $url, $data ) {

		$options = array(
			'http' => array(
				'header'  => "Content-Type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query( $data ),
			),
		);
		$context = stream_context_create( $options );
		$result  = file_get_contents( $url, false, $context );

		return $result;
	}

	/**
	 * Method is triggered after the trip is booked in frontend.
	 * Gets the information about the booked trip.
	 */
	public static function wp_travel_after_frontend_booking( $booking_id, $first_key ) {
		if ( ! self::$client_id || ! self::$client_secret || ! self::$refresh_token ) {
			return;
		}
		$token = self::getAccessTokenByRefreshToken(
			self::$refresh_token,
			array(
				'client_id'     => self::$client_id,
				'client_secret' => self::$client_secret,
				'token_uri'     => self::$url,
			)
		);

		$array_token = json_decode( $token, true );

		self::$token = $array_token;
		self::$client->setAccessToken( $array_token );
		global $wt_cart;
		$cart_items = $wt_cart->getItems();
		$cart       = WP_Travel_Helpers_Cart::get_cart(); // New Method.
		// error_log( print_r( $cart, true ) );
		$total = $cart['cart']['total']['total'] > 0 ? $cart['cart']['total']['total'] : 0;
		foreach ( $cart_items as $cart_item ) {
			if ( $cart_item['trip_time'] ) {
				self::$trip_time = $cart_item['trip_time'];
			}
			self::$arrival_date = $cart_item['trip_start_date'];

			self::$departure_date = self::$arrival_date;

			if( !empty( WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['trip_duration']  ) ){
				self::$departure_date = WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['trip_duration']['duration_format'] == 'day_night' ? date('Y-m-d', strtotime(self::$arrival_date . ' +' . WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['trip_duration']['days'] . ' days')) : self::$arrival_date;
			}

			self::$trip_pax     = $cart_item['trip'][2]['pax'];
			self::$date_id = $cart_item['date_id'];
	        


			if( WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['is_fixed_departure'] ){
	            
			    foreach(WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['dates'] as $date){
			        if( $date['id'] == self::$date_id && $date['is_recurring'] == false ){




			            if( self::$departure_date == '0000-00-00' ){
			                self::$departure_date = WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['trip_duration']['duration_format'] == 'day_night' ? date('Y-m-d', strtotime(self::$arrival_date . ' +' . WpTravel_Helpers_Trips::get_trip( $cart_item['trip_id'] )['trip']['trip_duration']['days'] . ' days')) : self::$arrival_date;
			            }
			        }
			    }

	
			}
		}

		$booking_info       = get_post_meta( $booking_id, 'order_data', true );
		self::$booking_info = $booking_info;

		$trip_details     = get_post_meta( $booking_id, 'order_items_data', true );
		$fname            = $booking_info['wp_travel_fname_traveller'];
		$lname            = $booking_info['wp_travel_lname_traveller'];
		$number           = $booking_info['wp_travel_phone_traveller'];
		$email            = $booking_info['wp_travel_email_traveller'];
		self::$first_name = $fname[ $first_key ][0];
		self::$last_name  = $lname[ $first_key ][0];
		self::$mail       = $email[ $first_key ][0];
		self::$number     = $number[ $first_key ][0];
		foreach ( $trip_details   as $trip_detail ) {
			$trip_id             = $trip_detail['trip_id'];
			self::$trip_id             = $trip_detail['trip_id'];
			self::$trip_edit_url = get_edit_post_link( $trip_id, '' );
		}
		self::$trip_total = $total;
		// $get_map = WP_Travel_Helpers_Map::get( $trip_id );
		$trip_data = WpTravel_Helpers_Trips::get_trip( $trip_id );

		$trip = array();
		if ( is_array( $trip_data ) && ! is_wp_error( $trip_data ) && isset( $trip_data['code'] ) && 'WP_TRAVEL_TRIP_INFO' === $trip_data['code'] ) {
			$trip                = $trip_data['trip'];
			self::$trip_title    = $trip['title'];
			self::$trip_location = $trip['map_data']['loc'];
		}
		
		if( isset( $trip_data['trip']['trip_duration'] ) && $trip_data['trip']['trip_duration']['duration_format'] == 'hour_minute'){
		    self::$trip_duration = 0;
		    self::$trip_duration += !empty( $trip_data['trip']['trip_duration']['hours'] ) ? (float) $trip_data['trip']['trip_duration']['hours'] * 60 : 0;
		    self::$trip_duration += !empty( $trip_data['trip']['trip_duration']['minutes'] ) ? (float) $trip_data['trip']['trip_duration']['minutes'] : 0;
		}
        

		self::$timezone = wp_timezone_string();

		self::create_event();
	}


	/**
	 * Google Service Calendar is used to auth the user.
	 * Google Calendar Event is used to insert trip infos into calendar
	 *
	 * @return void
	 */
	public static function create_event() {
		if ( ! self::$token ) {
			return;
		}
		if ( ! class_exists( 'Google\Service\CALENDAR' ) ) {

			include_once dirname( __FILE__ ) . '/' . 'vendor/autoload.php';
		}
		$service     = new Google\Service\Calendar( self::$client );
		$calendar_dd = 'primary';
		$description = '<b>Phone Number :</b> ' . self::$number . "<b>\nEmail :</b>" . self::$mail . "<b>\nTrip Edit :</b>" . self::$trip_edit_url . "<b>\nTrip Pax : </b>" . self::$trip_pax;
		if ( 'booking_only' != self::$booking_info['wp_travel_booking_option'] ) {
			$description .= "<b>\nTrip Total : </b>" . wptravel_get_currency_symbol() . ' ' . self::$trip_total;
		}
		if ( self::$trip_time ) {
			$start_time = self::$arrival_date . 'T' . self::$trip_time . ':00';
            $trip_data = WpTravel_Helpers_Trips::get_trip( self::$trip_id );
         
			if( isset( $trip_data['trip']['trip_duration'] ) && $trip_data['trip']['trip_duration']['duration_format'] == 'hour_minute' && $trip_data['trip']['is_fixed_departure']){ 
             
                foreach($trip_data['trip']['dates'] as $date ){
                    
                    if( $date['id'] == self::$date_id && $date['is_recurring'] == true ){ 
                       
                        $end_time = new DateTime($start_time);
                    	$end_time->add(new DateInterval('PT'.self::$trip_duration.'M'))->date;
                    	$end_time = (array) $end_time;
                        $end_time = str_replace(' ', 'T', $end_time['date']);
                    }else{
                        
                        $end_time = self::$departure_date . 'T23:59:00';
                    }
                }
			
            
			}else{
			    
				$end_time = self::$departure_date . 'T23:59:00';
			}
			
	     
            $event_arg = array(
                'summary'     => self::$trip_title . ': Booked By ' . self::$first_name . ' ' . self::$last_name,
                'location'    => self::$trip_location ? 'Trip : ' . self::$trip_location : '',
                'description' => $description,
                'start'       => array(
                    'dateTime' => $start_time,
                    'timeZone' => self::$timezone,
                ),
                'end'         => array(
                    'dateTime' => $end_time,
                    'timeZone' => self::$timezone,
                ),
            );

		} else {
    
		    
			$event_arg = array(
				'summary'     => self::$trip_title . ': Booked By ' . self::$first_name . ' ' . self::$last_name,
				'location'    => self::$trip_location ? '<b>Trip : </b>' . self::$trip_location : '',
				'description' => $description,
				'start'       => array(
					'date' => self::$arrival_date,
				),
				'end'         => array(
				    'date' => self::$departure_date,
				// 	'date' => date('Y-m-d', strtotime(self::$departure_date . ' +1 days')),
				),
			);
		}
		

		$event = new Google\Service\Calendar\Event( $event_arg );
		$service->events->insert( $calendar_dd, $event );
	}

	/**
	 * Removes the refresh token from wptravel_get_settings.
	 *
	 * @return void
	 */
	public static function google_logout() {
		$logout = ! empty( $_GET['logout'] ) ? $_GET['logout'] : '';
		if ( 'gcalendar' !== $logout ) {
			return;
		}
		$settings                                  = wptravel_get_settings();
		$settings['google_calendar_refresh_token'] = '';
		update_option( 'wp_travel_settings', $settings );
		if ( wp_safe_redirect( admin_url( '/edit.php?post_type=itinerary-booking&page=settings' ) ) ) {
			exit;
		}
	}

		/**
		 * Localized the Auth Url and Setting Url for Google Login and Google Logout
		 *
		 * @return void
		 */
	public static function load_scripts() {
		$data = array(
			'auth_url'    => self::$auth_url,
			'setting_url' => home_url( $_SERVER['REQUEST_URI'] ),

		);
		wp_localize_script(
			'wptravel_google_calendar_admin-settings',
			'wpTravelGoogleCalendar',
			$data
		);
	}

}
WPTravel_Google_Calendar::init();
WPTravel_Google_Calendar::google_logout();