<?php
class WP_Travel_FW_Field_Recaptcha_V2 {
	protected $field;
	protected $field_type = 'grecaptcha_v2';
	function init( $field ) {
		$this->field = $field;
		return $this;
	}

	function render( $display = true ) {
		$validations = '';
		if ( isset( $this->field['validations'] ) ) {
			foreach ( $this->field['validations'] as $key => $attr ) {
				$validations .= sprintf( ' %s="%s" data-parsley-%s="%s"', $key, $attr, $key, $attr );
			}
		}
		$attributes = '';
		if ( isset( $this->field['attributes'] ) ) {
			foreach ( $this->field['attributes'] as $attribute => $attribute_val ) {
				$attributes .= sprintf( ' %s="%s" ', $attribute, $attribute_val );
			}
		}


		$before_field = '';
		if ( isset( $this->field['before_field'] ) ) {
			$before_field_class = isset( $this->field['before_field_class'] ) ? $this->field['before_field_class'] : '';
			$before_field = sprintf( '<span class="wp-travel-field-before %s">%s</span>', $before_field_class, $this->field['before_field'] );
		}
		$output = '';
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		$gcaptcha_site_key = ! empty( $settings['recaptcha_v2_site_key'] ) ? esc_attr( $settings['recaptcha_v2_site_key'] ) : '';
		if ( ! empty( $gcaptcha_site_key ) ) {
			$output = sprintf( '%s<div id="%s" %s class="%s" %s data-sitekey="%s" data-callback="wp_travel_add_grecaptcha_token"></div>', $before_field, $this->field['id'], $validations, $this->field['class'] . 'g-recaptcha', $attributes, $gcaptcha_site_key );
		}
		if ( ! $display ) {
			return $output;
		}

		echo wp_kses_post( $output );
	}
}
