<?php
/**
 * Settings Helper.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Default settings keys. This will automatically save for normal input key value pair.
 *
 * @param array $fields All settings fields.
 * @since WP Travel 4.0.7
 */
function wp_travel_field_editor_settings_fields( $fields ) {
	$fields['thank_you_page_id']                     = wptravel_get_page_id( 'booking-thank-you' );
	$fields['enable_custom_trip_code_option']        = 'yes';
	$fields['disable_email_powered_by_text']         = 'no';
	$fields['email_template_powered_by_text']        = __( '{sitename} - Powered By: ', 'wp-travel-pro' ) . '<a href="http://wptravel.io/" target="_blank" style="color: #5a418b;text-decoration: none;">WP Travel.</a>';
	$fields['wp_travel_booking_notif_emails']        = '';
	$fields['force_cart_checkout_process_for_trips'] = 'no';
	$fields['skip_cart_page_booking']                = 'no';
	$fields['price_unavailable_text']                = '';

	// Addons Settings
	$fields['show_wp_travel_utilities'] = 'yes';

	return $fields;
}
// add_filter( 'wp_travel_settings_fields', 'wp_travel_field_editor_settings_fields', 15 );

/**
 * Mapped settings values for React Block. [get settings]
 *
 * @param array $settings All settings.
 * @since WP Travel 4.0.7
 */
function wp_travel_field_editor_settings_vlaues( $settings ) {

	$enquiry_fields   = WP_Travel_Field_Editor_Core::load_field();
	$billing_fields   = WP_Travel_Field_Editor_Core::load_field( 'billing' );
	$traveller_fields = WP_Travel_Field_Editor_Core::load_field( 'traveller' );

	$enquiry_defaults = WP_Travel_Field_Editor_Core::load_field( 'enquiry', true );
	$billing_defaults = WP_Travel_Field_Editor_Core::load_field( 'billing', true );
	$traveller_defaults = WP_Travel_Field_Editor_Core::load_field( 'traveller', true );

	// Enquiry Fields.
	$mapped_enquiry_fields = array();
	$mapped_enquiry_default_fields = array();
	foreach ( $enquiry_fields as $key => $enquiry_field ) {
		$enquiry_field['key'] = $key;

		if ( isset( $enquiry_field['options'] ) && is_array( $enquiry_field['options'] ) ) {
			$enquiry_field['options'] = array_values( $enquiry_field['options'] );
		}
		$mapped_enquiry_fields[] = $enquiry_field;
	}
	foreach ( $enquiry_defaults as $key => $enquiry_field ) {
		$enquiry_field['key'] = $key;

		if ( isset( $enquiry_field['options'] ) && is_array( $enquiry_field['options'] ) ) {
			$enquiry_field['options'] = array_values( $enquiry_field['options'] );
		}
		$mapped_enquiry_default_fields[] = $enquiry_field;
	}


	$mapped_billing_fields = array();
	$mapped_billing_default_fields = array();
	foreach ( $billing_fields as $key => $billing_field ) {
		$billing_field['key']    = $key;
		$mapped_billing_fields[] = $billing_field;
	}
	foreach ( $billing_defaults as $key => $billing_field ) {
		$billing_field['key']    = $key;
		$mapped_billing_default_fields[] = $billing_field;
	}

	$mapped_traveller_fields = array();
	$mapped_traveller_default_fields = array();
	foreach ( $traveller_fields as $key => $traveller_field ) {
		$traveller_field['key']    = $key;
		$mapped_traveller_fields[] = $traveller_field;
	}
	foreach ( $traveller_defaults as $key => $traveller_field ) {
		$traveller_field['key']    = $key;
		$mapped_traveller_default_fields[] = $traveller_field;
	}

	$field_editors = array(
		'enquiry'           => $mapped_enquiry_fields,
		'enquiry_default'   => $mapped_enquiry_default_fields,
		'billing'           => $mapped_billing_fields,
		'billing_default'   => $mapped_billing_default_fields,
		'traveller'         => $mapped_traveller_fields,
		'traveller_default' => $mapped_traveller_default_fields,
	);

	$settings['field_editors']  = $field_editors;
	$settings['enquiry_fields'] = $mapped_enquiry_fields;
	$settings['billing_fields'] = $mapped_billing_fields;
	$settings['traveller_fields'] = $mapped_traveller_fields;

	return $settings;
}
add_filter( 'wp_travel_settings_values', 'wp_travel_field_editor_settings_vlaues', 15 );

function wp_travel_field_editor_settings_options( $options, $settings ) {
	$fields_options          = WP_Travel_Field_Editor_Core::fields_options(); // Type.
	$heading_tags            = WP_Travel_Field_Editor_Core::heading_tags(); // heading tag.
	$trip_types_options      = WP_Travel_Field_Editor_Core::wp_travel_trip_types(); //Trip Type.
	$trip_activities_options = WP_Travel_Field_Editor_Core::wp_travel_trip_activities(); //Trip Activities.	

	$mapped_fields_options = array();
	foreach ( $fields_options as $value => $label ) {
		$mapped_fields_options[] = array(
			'label' => $label,
			'value' => $value,
		);
	}

	$mapped_heading_tags = array();
	foreach ( $heading_tags as $value => $label ) {
		$mapped_heading_tags[] = array(
			'label' => $label,
			'value' => $value,
		);
	}

	$mapped_trip_type_options = array();
	foreach ( $trip_types_options as $value => $label ) {
		$mapped_trip_type_options[] = array(
			'label' => $label,
			'value' => $value,
		);
	}

	$mapped_trip_activities_options = array();
	foreach ( $trip_activities_options as $value => $label ) {
		$mapped_trip_activities_options[] = array(
			'label' => $label,
			'value' => $value,
		);
	}
	$field_editors = array(
		'fields_options'          => $mapped_fields_options,
		'heading_tags'            => $mapped_heading_tags,
		'trip_type_options'       => $mapped_trip_type_options,
		'trip_activities_options' => $mapped_trip_activities_options,
	);

	$options['field_editors'] = $field_editors;
	return $options;

}

add_filter( 'wp_travel_settings_options', 'wp_travel_field_editor_settings_options', 15, 2 );



/**
 * Save Mapped settings values for React Block. [update settings]
 *
 * @param array $settings All settings.
 * @param array $settings_data All post datas.
 * @since WP Travel 4.0.7
 */
function wp_travel_field_editor_save_settings_vlaues( $settings, $settings_data ) {

	$form_fields     = array();
	$form_old_fields = get_option( 'wp_travel_forms_properties', array() );
	$locale          = wp_travel_field_editor_get_locale();
	
	/**
	 * Support for translation.
	 *
	 * @since 1.0.9
	 */
	if ( isset( $form_old_fields[ $locale ] ) ) {
		$form_old_fields[ $locale ] = get_option( 'wp_travel_forms_properties', array() );
		$form_old_fields            = ! empty( $form_old_fields[ $locale ] ) ? $form_old_fields[ $locale ] : array();
	}

	if ( ! empty( $settings_data['field_editors'] ) ) :
		$field_property = $settings_data['field_editors'];
		foreach ( $field_property as $form => $fields ) {
			if ( ! empty( $fields ) ) {
				foreach ( $fields as  $field ) {
					$name = isset( $field['key'] ) && ! empty($field['key']) ? $field['key'] : $field['name'];
					// unset( $field['name'] );
					// $form_fields[ $form ][ $name ] = (array) ( stripslashes_deep( $field ) );
					$form_fields[ $form ][ $name ] = (array) ( ( $field ) );
					if ( ! empty( $form_fields[ $form ][ $name ] ) ) {
						foreach ( $form_fields[ $form ][ $name ] as $property => $value ) {
							$form_fields[ $form ][ $name ][ $property ] = is_object( $value ) ? (array) $value : $value;
						}
					}
				}
				if ( isset( $form_old_fields[ $locale ] ) ) {
					$form_old_fields[ $locale ][ $form ] = $form_fields[ $form ];
				} else {
					$form_old_fields[ $form ] = $form_fields[ $form ];
				}
			}
		}
	endif;

	/**
	 * Support for translation.
	 *
	 * @since 1.0.9
	 */
	if ( ! isset( $form_old_fields[ $locale ] ) ) {
		$form_old_fields[ $locale ] = $form_old_fields;
	}
	// error_log( print_r( $form_old_fields, true ) );
	
	update_option( 'wp_travel_forms_properties', $form_old_fields );

	$settings['recaptcha_v2_site_key'] = ! empty( $settings_data['recaptcha_v2_site_key'] ) ? sanitize_text_field( $settings_data['recaptcha_v2_site_key'] ) : '';
	$settings['recaptcha_v2_secret_key'] = ! empty( $settings_data['recaptcha_v2_secret_key'] ) ? sanitize_text_field( $settings_data['recaptcha_v2_secret_key'] ) : '';
	$settings['field_pattern_multiple_traveler'] = ! empty( $settings_data['field_pattern_multiple_traveler'] ) ? 1 : 0;
	return $settings;

}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_field_editor_save_settings_vlaues', 15, 2 );
