"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var WPTravelFieldEditor =
/*#__PURE__*/
function () {
  function WPTravelFieldEditor() {
    _classCallCheck(this, WPTravelFieldEditor);

    // this.changes_is_saved = true;
    window.wp_travel_field_editor_is_saved = true;
    this.init();
  }

  _createClass(WPTravelFieldEditor, [{
    key: "init",
    value: function init() {
      var form = jQuery('.wp-travel-settings-section-tabs a:first-child').data('form');
      this.load_lists(form);
      jQuery(window).bind('beforeunload', function () {
        if (!window.wp_travel_field_editor_is_saved) {
          return 'Are you sure you want to leave?';
        }
      });
    }
  }, {
    key: "load_lists",
    value: function load_lists(form) {
      var reset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      jQuery.post(ajaxurl, {
        action: 'wp_travel_field_editor_get_fields',
        form: form,
        reset: reset
      }, function (response) {
        jQuery('#wp-travel-settings-section-tab-content').html(WPTravelFormEditorViews.create_table({
          form: form,
          fields: response.data
        }));
        fieldEditor.open_editor();
        fieldEditor.init_sortable();
        fieldEditor.bind_delete();
      });
    }
  }, {
    key: "create",
    value: function create() {
      var $this = this;
      jQuery('.field-add-mode form#wp-travel-field-editor-form').parsley().on('form:submit', function () {

        var form = jQuery('#field_editor_popup input[name=form_name]').val();
        var name = jQuery('#field_editor_popup input[name=field_name]').val();
        var field = $this.generate_property();
        var content = WPTravelFormEditorViews.tr_content({
          name: name,
          field: field,
          form: form
        });
        var row = WPTravelFormEditorViews.create_tr({
          name: name,
          content: content
        });
        jQuery('table.wp-travel-field-lists[data-form=' + form + '] tbody').append(row);
        $this.update_property();
        $this.close_popup();
        $this.open_editor();
        $this.bind_delete();
        return false;
      });
    }
  }, {
    key: "bind_update",
    value: function bind_update() {
      var $this = this;
      jQuery('.field-edit-mode form#wp-travel-field-editor-form').parsley().on('form:submit', function () {

        var form = jQuery('#field_editor_popup input[name=form_name]').val();
        var name = jQuery('#field_editor_popup input[name=field_name]').val();
        var property_field = jQuery('textarea[name="field_property[' + form + '][' + name + ']"]');
        var property = jQuery.parseJSON(property_field.val());
        var field = $this.generate_property(property);
        property_field.val(JSON.stringify(property));
        jQuery('tr[data-name="' + name + '"]').html(WPTravelFormEditorViews.tr_content({
          name: name,
          field: field,
          form: form
        }));
        $this.close_popup();
        $this.open_editor();
        $this.bind_delete();
      });
    }
  }, {
    key: "bind_delete",
    value: function bind_delete() {
      var $this = this;
      jQuery('.remove_field').unbind().click(function () {
        if (!confirm(wp_travel_field_editor.delete_field_message)) {
          return false;
        }

        var form = jQuery(this).data('form');
        var field = jQuery(this).data('field');
        jQuery('table[data-form=' + form + '] tr[data-name=' + field + ']').remove();
        $this.changes_notification();
      });
    }
  }, {
    key: "read",
    value: function read() {}
  }, {
    key: "open_editor",
    value: function open_editor() {
      var $this = this;
      jQuery('.edit_field').unbind().click(function (event) {
        event.preventDefault();
        var form_name = jQuery(this).data('form');
        var field_name = jQuery(this).data('field');
        jQuery('textarea.field_property').removeClass('current-edited-field');
        jQuery('textarea[name="field_property[' + form_name + '][' + field_name + ']"]').addClass('current-edited-field');
        var property = jQuery.parseJSON(jQuery('textarea[name="field_property[' + form_name + '][' + field_name + ']"]').val());
        var placeholder = '';

        if ('undefined' !== typeof property.attributes) {
          if ('undefined' !== typeof property.attributes.placeholder) {
            placeholder = property.attributes.placeholder;
          }
        } else if ('undefined' !== typeof property.placeholder) {
          placeholder = property.placeholder;
        }

        $this.load_popup();
        'traveller' != form_name && jQuery('#field_editor_popup .required_for_all').remove(); // added to control required_for_all field.

        jQuery('#field_editor_popup input[name=form_name]').val(form_name);
        jQuery('#field_editor_popup input[name=field_name]').val(field_name);
        jQuery('#field_editor_popup input[name=editor_label]').val(property.label);
        jQuery('#field_editor_popup input[name=editor_name]').val(property.name);
        jQuery('#field_editor_popup select[name=editor_type]').val(property.type);
        jQuery('#field_editor_popup input[name=editor_id]').val(property.id);
        jQuery('#field_editor_popup input[name=editor_class]').val(property.wrapper_class);
        jQuery('#field_editor_popup input[name=editor_placeholder]').val(placeholder);
        jQuery('#field_editor_popup input[name=editor_type]').val(property.type); // disable for default fields.

        if (true === property._default) {
          jQuery('#field_editor_popup input[name=editor_name]').prop('disabled', true);
          jQuery('#field_editor_popup input[name=editor_id]').prop('disabled', true);
          jQuery('#field_editor_popup [name=editor_type]').prop('disabled', true);
        }

        if ('undefined' !== typeof property.validations && Object.keys(property.validations).length > 0) {
          _.each(property.validations, function (option, key) {
            jQuery('.validation_field input[value=' + key + ']').prop('checked', option);
          });
        }

        if ('select' === property.type || 'radio' === property.type || 'checkbox' === property.type) {
          var options = [];

          if (Object.keys(property.options).length > 0) {
            _.each(property.options, function (option, key) {
              options.push(option);
            });

            jQuery('#field_editor_popup [name=editor_select_options]').val(options.join('\n').trim());
          }
        }

        if ('heading' === property.type) {
          jQuery('#field_editor_popup [name=editor_heading_tag]').val(property.heading_tag);
        }

        if ('date' === property.type) {
          var datePosition = 'any';

          if ('undefined' !== typeof property.attributes) {
            console.log(_typeof(property.attributes['data-max-today']));
          }

          if ('undefined' !== typeof property.attributes && 'undefined' !== typeof property.attributes['data-max-today']) {
            datePosition = true === property.attributes['data-max-today'] ? 'past' : 'future';
          }

          jQuery("#field_editor_popup [name=editor_date_position][value=" + datePosition + "]").prop("checked", true);
        }

        jQuery('#field_editor_popup').removeClass('field-add-mode').addClass('field-edit-mode');
        $this.bind_update();
        $this.toggle_options_field(property.type);
        $this.open_popup();
        return false;
      });
    }
    /**
     * Slugify the text string.
     * There is function in wp-travel-backend.js but we had to load whole file for just one function.
     *
     * @param  {string} text String.
     * @return {String}      Slug.
     */

  }, {
    key: "slugify",
    value: function slugify(text) {
      return text.toString().toLowerCase().replace(/\s+/g, '-') // Replace spaces with -
      .replace(/[^\w\-]+/g, '') // Remove all non-word chars
      .replace(/\-\-+/g, '-') // Replace multiple - with single -
      .replace(/^-+/, '') // Trim - from start of text
      .replace(/-+$/, ''); // Trim - from end of text
    }
  }, {
    key: "changes_notification",
    value: function changes_notification() {
      var show = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      if (show) {
        window.wp_travel_field_editor_is_saved = false;
        var notice_text = 'Changes has been made in form. Please save settings.';
        var notice = "<em class=\"field-editor-save-notification\"><span class=\"dashicons dashicons-info\"></span> ".concat(notice_text, "</em>");

        if (jQuery('em.field-editor-save-notification').length < 1) {
          jQuery('.wp-travel-setting-buttons').prepend(notice);
        }
      } else if (!show) {
        window.wp_travel_field_editor_is_saved = true;

        if (jQuery('em.field-editor-save-notification').length > 0) {
          jQuery('em.field-editor-save-notification').remove();
        }
      }
    }
  }, {
    key: "toggle_options_field",
    value: function toggle_options_field() {
      var selected = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var select_editor_type = jQuery('select[name=editor_type]');

      if ('' === selected) {
        selected = select_editor_type.val();
      } 


      var togglefields = select_editor_type.data('togglefields');

      for (var field in togglefields) {
        if (togglefields.hasOwnProperty(field)) {
          if (togglefields[field].hasOwnProperty('hide') && togglefields[field]['hide'].length > 0 && togglefields[field]['hide'].includes(selected)) {
            jQuery('.' + field).removeClass('editor-display-field').addClass('editor-hide-field');
          } else if (togglefields[field].hasOwnProperty('show') && togglefields[field]['show'].length > 0 && togglefields[field]['show'].includes(selected)) {
            jQuery('.' + field).removeClass('editor-hide-field').addClass('editor-display-field');
          } else {
            var state = jQuery('.' + field + ' [data-ishidden]');

            if (true === state.data('ishidden')) {
              jQuery('.' + field).removeClass('editor-display-field').addClass('editor-hide-field');
            } else {
              jQuery('.' + field).removeClass('editor-hide-field').addClass('editor-display-field');
            }
          }
        }
      } 

    }
  }, {
    key: "generate_property",
    value: function generate_property() {
      var property = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var form_name = jQuery('#field_editor_popup input[name=form_name]').val();
      var field_name = jQuery('#field_editor_popup input[name=field_name]').val();
      var label = jQuery('#field_editor_popup input[name=editor_label]').val();
      var name = jQuery('#field_editor_popup input[name=editor_name]').val();
      var field_type = jQuery('#field_editor_popup select[name=editor_type]').val();
      var id = jQuery('#field_editor_popup input[name=editor_id]').val();
      var wrapper_class = jQuery('#field_editor_popup input[name=editor_class]').val();
      var placeholder = jQuery('#field_editor_popup input[name=editor_placeholder]').val();
      var date_position = jQuery('#field_editor_popup input[name=editor_date_position]:checked').val();
      property.label = label;
      property.name = name;
      property.type = field_type;
      property.id = id;
      property.wrapper_class = wrapper_class;
      property.attributes = {
        placeholder: placeholder
      };

      if (jQuery('.validation_field input').length > 0) {
        property.validations = 'undefined' !== typeof property.validations && Object.keys(property.validations).length > 0 ? property.validations : {};
        var validation_label = '';
        jQuery('.validation_field input').each(function () {
          validation_label = jQuery(this).val();
          property.validations[validation_label] = jQuery(this).is(":checked");
        });
      }

      if ('select' === field_type || 'radio' === field_type || 'checkbox' === field_type) {
        var select_options = jQuery('#field_editor_popup [name=editor_select_options]').val().trim();
        var items = select_options.split("\n");
        var options = {};
        items = items.map(function (x) {
          x = x.trim();
          options[x] = x;
          return x;
        });
        property.options = options;
      }

      if ('heading' === field_type) {
        var heading_tag = jQuery('#field_editor_popup [name=editor_heading_tag]').val().trim();
        property.heading_tag = heading_tag;
      }

      if ('date' === field_type) {
        property.attributes['data-parsley-dateformat'] = 'YYYY-MM-DD';

        if ('past' == date_position || 'future' == date_position) {
          property.attributes['data-max-today'] = 'past' === date_position ? true : false;
        }
      } // Lagacy code starts.


      if ("placeholder" in property) {
        delete property.placeholder;
      } // Changes are made to nofiy.


      this.changes_notification();

      return property;
    }
  }, {
    key: "update_property",
    value: function update_property() {
      var field_property = jQuery('textarea.field_property');
      var priority = 10;
      field_property.each(function () {
        var property = jQuery.parseJSON(jQuery(this).val());
        property.priority = priority;
        priority += 10;
        jQuery(this).val(JSON.stringify(property));
      });
    }
  }, {
    key: "init_sortable",
    value: function init_sortable() {
      var $this = this;
      jQuery("#wp-travel-field-editor-field-list").sortable({
        handle: ".handle",
        update: function update(event, ui) {
          $this.update_property();
          $this.changes_notification();
        }
      });
    }
    /** popups **/

  }, {
    key: "open_popup",
    value: function open_popup() {
      jQuery.magnificPopup.open({
        items: {
          src: '#field_editor_popup'
        },
        type: 'inline',
        callbacks: {
          open: function open() {
            if ('enquiry' !== jQuery('.wp-travel-settings-section-tabs a.active').data('form')) {
              jQuery('select#editor_type option[value=recaptcha_v2]').remove();
            }
          },
          close: function close() {
            jQuery('textarea.field_property').removeClass('current-edited-field');
          }
        }
      });
    }
  }, {
    key: "load_popup",
    value: function load_popup() {
      var template = wp.template('wp-travel-field-editor-form');
      jQuery('#field_editor_popup').html(template());
      jQuery(document).on('change', 'select[name=editor_type]', function () {
        fieldEditor.toggle_options_field();
      });
    }
  }, {
    key: "close_popup",
    value: function close_popup() {
      jQuery('#field_editor_popup').html('');
      jQuery.magnificPopup.instance.close();
    }
  }]);

  return WPTravelFieldEditor;
}();

var fieldEditor = new WPTravelFieldEditor();
jQuery(function ($) {
  window.ParsleyValidator.addValidator("validname", function (value, requirement) {
    var field_property = jQuery('textarea.field_property');
    var status = true;
    field_property.each(function () {
      var property = jQuery.parseJSON(jQuery(this).val());

      if (property.name === value && !jQuery(this).hasClass('current-edited-field')) {
        status = false;
        return false;
      }
    });
    return status;
  }, 32).addMessage('en', 'validname', wp_travel_field_editor.validation_messages.validname);
  window.ParsleyValidator.addValidator("validid", function (value, requirement) {
    var field_property = jQuery('textarea.field_property');
    var status = true;
    field_property.each(function () {
      var property = jQuery.parseJSON(jQuery(this).val());

      if (property.id === value && !jQuery(this).hasClass('current-edited-field')) {
        status = false;
        return false;
      }
    });
    return status;
  }, 32).addMessage('en', 'validid', wp_travel_field_editor.validation_messages.validid);
  jQuery(document).on('click', '.open-new-field-form', function () {
    var form_name = jQuery(this).data('form');
    fieldEditor.load_popup();
    'traveller' != form_name && jQuery('#field_editor_popup .required_for_all').remove(); // added to control required_for_all field.

    jQuery('#field_editor_popup input[name=form_name]').val(form_name);
    jQuery('#field_editor_popup').removeClass('field-edit-mode').addClass('field-add-mode');
    fieldEditor.create();
    fieldEditor.open_popup();
  });
  jQuery(document).on('change', '.field-add-mode input[name=editor_label]', function () {
    var label = jQuery(this).val();
    var form = jQuery('.field-add-mode input[name=form_name]').val();
    var id = jQuery('.field-add-mode input[name=editor_id]').val();
    var name = jQuery('.field-add-mode input[name=editor_name]').val();
    var slug = form + '-' + fieldEditor.slugify(label);
    var name_slug = slug.replace(/-/g, '_');

    if ('' === name) {
      jQuery('.field-add-mode input[name=editor_name]').val(name_slug);
      jQuery('.field-add-mode input[name=field_name]').val(name_slug);
    }

    if ('' === id) {
      jQuery('.field-add-mode input[name=editor_id]').val(slug);
    }
  });
  jQuery(document).on('change', '.field-add-mode input[name=editor_name]', function () {
    var name = jQuery(this).val();
    jQuery('.field-add-mode input[name=field_name]').val(name);
  }); // Reset fields to default.

  jQuery(document).on('click', 'button[name=reset_fields]', function () {
    if (confirm(wp_travel_field_editor.reset_message)) {
      var form = jQuery('table.wp-travel-field-lists').data('form');
      fieldEditor.load_lists(form, true);
      fieldEditor.changes_notification();
    }

    return false;
  });
  jQuery(document).on('click', '.wp-travel-settings-section-tabs a', function (event) {
    event.preventDefault();

    if (!window.wp_travel_field_editor_is_saved) {
      if (!confirm('Changes are not saved. Are you sure to switch form?')) {
        return;
      }
    }

    var form = jQuery(this).data('form');
    jQuery('.wp-travel-settings-section-tabs a').removeClass('active');
    jQuery(this).addClass('active');
    fieldEditor.load_lists(form);
    fieldEditor.changes_notification(false);
    return false;
  });
  jQuery(document).on('submit', '.wp-trave-settings-form-warp form', function () {
    fieldEditor.changes_notification(false);
  });
  jQuery(document).on('click', '.required_for_all input[type="checkbox"]', function () {
    if (jQuery(this).is(':checked')) {
      jQuery(this).closest('.wp-travel-form-field').siblings('.validation_required').find('input[type="checkbox"]').prop("checked", true);
    }
  });
  jQuery(document).on('click', '.validation_required input[type="checkbox"]', function () {
    if (jQuery(this).closest('.wp-travel-form-field').siblings('.required_for_all').find('input[type="checkbox"]').is(':checked')) {
      jQuery(this).prop("checked", true);
    }
  });
});
//# sourceMappingURL=field-editor.js.map
