<?php

if( class_exists( 'WP_Travel' ) ) {

	/**
	 * Callback function for wp_travel_download_addons_metabox.
	 */
	function wp_travel_downloads_tab_callback_contents( $post ) {
		$post_id = $post->ID;
		$siteurl = get_site_url();
		$args    = array(
			'post_type'      => 'wp_travel_downloads',
			'posts_per_page' => -1,
			'post_status'    => 'publish',
			'orderby'        => 'title',
			'order'          => 'ASC',
		);

		$downloads_cpt_title          = '';
		$list_all_downloads_cpt_title = '';

		$loop = new WP_Query( $args );
		if ( $loop->have_posts() ) {
			$count_downloads_list = ! empty( count( $loop->posts ) ) ? count( $loop->posts ) : 'N/A'; // @Since v1.0.4
			while ( $loop->have_posts() ) :
				$loop->the_post();
				$key                 = get_the_ID();
				$selected            = '';
				$downloads_cpt_title = get_the_title();
				$selected_downloads  = get_post_meta( $post_id, 'wpt_itineraries_select_downloads', true );

				$new_downloads_data  = get_post_meta( $post_id, 'wp_travel_downloads', true );
				if ( $new_downloads_data && is_array( $new_downloads_data ) && isset( $new_downloads_data['downloads'] ) ) {
					$selected_downloads = $new_downloads_data['downloads'];
				}
				// To keep the selected options selected after update or Publish.
				if ( is_array( $selected_downloads ) ) {
					$selected = in_array( $key, $selected_downloads ) ? 'selected' : '';
				}
				$list_all_downloads_cpt_title .= "<option value='{$key}' {$selected}>" . esc_html( $downloads_cpt_title ) . "</option>";
			endwhile;

			echo '<p class="count-downloads-lists"><h4>' . esc_attr__( 'Total downloads available', 'wp-travel-pro' ) . ' = ' . esc_attr( $count_downloads_list ) . '</h4></p>'; // @Since v1.0.4
			echo '<select name="downloads[]" class="wp_travel_select_downloads_select2" multiple>' . wp_kses_post( $list_all_downloads_cpt_title ) . '</select>';
		} else {
			echo ( '<p class="wp-travel-no-detail-found-msg howto">No Downloads Found. "<a href="' . esc_url( $siteurl ). '/wp-admin/post-new.php?post_type=wp_travel_downloads" target="_blank">Click here</a>" to add new.</p>' );
		}
		wp_reset_postdata();
	}

	/**
	 * Function to save selected option to wp_postmeta database.
	 */
	function wp_travel_downloads_save_selected_downloads( $post_id ) {
		if ( isset( $_POST['downloads'] ) ) {
			update_post_meta( $post_id, 'wpt_itineraries_select_downloads', $_POST['downloads'] );
		} elseif ( wp_is_post_revision( $post_id ) && isset( $_POST['downloads'] ) ) {
			update_post_meta( $post_id, 'wpt_itineraries_select_downloads', $_POST['downloads'] );
		} else {
			$_POST['downloads'] = '';
			update_post_meta( $post_id, 'wpt_itineraries_select_downloads', $_POST['downloads'] );
		}
	}
	add_action( 'save_post', 'wp_travel_downloads_save_selected_downloads' );

	// Downloads Tabs Content callback.
	function wp_travel_downloads_tab_callback( $tab_downloads ) {
		global $post;
		wp_travel_downloads_tab_callback_contents( $post );
	}
	add_action( 'wp_travel_trip_downloads_tab_content', 'wp_travel_downloads_tab_callback', 10, 2 );
}