<?php
/**
 * Registers the custom post type Downloads
 */
function wp_travel_downloads_register_post_type() {

	$labels = array(
		'name'                  => __( 'Downloads', 'wp-travel-pro' ),
		'singular_name'         => __( 'Download', 'wp-travel-pro' ),
		'add_new'               => __( 'Add New download', 'wp-travel-pro' ),
		'add_new_item'          => __( 'Add New download', 'wp-travel-pro' ),
		'edit_item'             => __( 'Edit download', 'wp-travel-pro' ),
		'new_item'              => __( 'Add New download', 'wp-travel-pro' ),
		'search_items'          => __( 'Search download', 'wp-travel-pro' ),
		'not_found'             => __( 'No downloads found', 'wp-travel-pro' ),
		'not_found_in_trash'    => __( 'No downloads found in trash', 'wp-travel-pro' ),
		'featured_image'        => __( 'Downloads Preview', 'wp-travel-pro' ),
		'set_featured_image'    => __( 'Set Downloads Preview', 'wp-travel-pro' ),
		'remove_featured_image' => __( 'Remove Downloads Preview', 'wp-travel-pro' ),
		'use_featured_image'    => __( 'Use Downloads Preview', 'wp-travel-pro' ),
	);
	$supports = array(
		'title',
		'thumbnail',
	);
	$args = array(
		'labels'               => $labels,
		'supports'             => $supports,
		'public'               => true,
		'capability_type'      => 'post',
		'rewrite'              => array( 'slug' => 'wp_travel_downloads' ),
		'has_archive'          => true,
		'description'          => __( 'If you delete a post from here, please update your <a href="/wp-admin/edit.php?post_type=itineraries" target="_blank">Trips</a> to make changes.', 'wp-travel-pro' ),
		'menu_position'        => 30,
		'menu_icon'            => 'dashicons-download',
		'show_in_menu'         => 'edit.php?post_type=itinerary-booking', // Displays this cpt under "WP-Travel" as Downloads.
		'register_meta_box_cb' => 'wp_travel_downloads_add_download_metabox',
	);
	register_post_type( 'wp_travel_downloads', $args );
}
$priority = 10;
if ( function_exists( 'wptravel_get_submenu' ) ) {
	$sbumenus = wptravel_get_submenu();
	$priority = isset( $sbumenus['bookings']['downloads']['priority'] ) ? $sbumenus['bookings']['downloads']['priority'] : $priority;
}
add_action( 'init', 'wp_travel_downloads_register_post_type', $priority );

/**
 * Adds a metabox to Custom post type Downloads
 */
function wp_travel_downloads_add_download_metabox() {
	add_meta_box(
		'wpt_cpt_downloads_metabox',
		'Upload content',
		'wp_travel_downloads_cpt_downloads_metabox_callback', // Callback function from below function.
		'wp_travel_downloads', // Cpt Downloads slug.
		'normal',
		'default'
	);
}

/**
 * Removes links and customize text from "Post Update" messsages
 */
function wp_travel_downloads_add_download_edit_update_messages( $messages ) {
	global $post, $post_ID;

	$post_types = get_post_types( array( 'show_ui' => true, '_builtin' => false ), 'objects' );

	$post_type = 'wp_travel_downloads';
	foreach( $post_types as $post_object ) {

		$messages[ $post_type ] = array(

			// 0  => '', // Unused. Messages start at index 1.
			// 1  => sprintf( __( '%s updated.', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ) ),
			// 2  => __( 'Updated.', 'wp-travel-pro' ),
			// 3  => __( 'Deleted.', 'wp-travel-pro' ),
			// 4  => sprintf( __( '%s updated.', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ) ),
			// 5  => isset( $_GET['revision']) ? sprintf( __( '%s restored to revision from %s', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ), esc_html( wp_post_revision_title( (int) $_GET['revision'], false ) ) ) : false,
			// 6  => sprintf( __( '%s added.', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ) ),
			// 7  => sprintf( __( '%s saved.', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ) ),
			// 8  => sprintf( __( '%s submitted.', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ) ),
			// 9  => sprintf( __( '%s scheduled for: <strong>%1$s</strong>.', 'wp-travel-pro'), esc_html( $post_object->labels->singular_name ), date_i18n( __( 'M j, Y @ G:i', 'wp-travel-pro' ), strtotime( $post->post_date ) ) ),
			// 10 => sprintf( __( '%s draft updated.', 'wp-travel-pro' ), esc_html( $post_object->labels->singular_name ) ),

			0  => '', // Unused. Messages start at index 1.
			1  => esc_html( $post_object->labels->singular_name ) . __( ' updated.', 'wp-travel-pro' ),
			2  => __( 'Updated.', 'wp-travel-pro' ),
			3  => __( 'Deleted.', 'wp-travel-pro' ),
			4  => esc_html( $post_object->labels->singular_name ) . __( ' updated.', 'wp-travel-pro' ),
			5  => isset( $_GET['revision'] ) ? esc_html( $post_object->labels->singular_name ) . __( ' restored to revision from ', 'wp-travel-pro' ). esc_html( wp_post_revision_title( (int) $_GET['revision'], false ) )  : false,
			6  => esc_html( $post_object->labels->singular_name ) . __( ' added.', 'wp-travel-pro' ),
			7  => esc_html( $post_object->labels->singular_name ) . __( ' saved.', 'wp-travel-pro' ),
			8  => esc_html( $post_object->labels->singular_name ) . __( ' submitted.', 'wp-travel-pro' ),
			9  => esc_html( $post_object->labels->singular_name ) . __( ' scheduled for: ', 'wp-travel-pro' ) . '<strong>'.date_i18n( __( 'M j, Y @ G:i', 'wp-travel-pro' ), strtotime( $post->post_date ) ).'</strong>.' ,
			10 => esc_html( $post_object->labels->singular_name ) . __( ' draft updated.', 'wp-travel-pro' ),
		);
	}
	return $messages;

}
add_filter( 'post_updated_messages', 'wp_travel_downloads_add_download_edit_update_messages' );

/**
 * Update array to database wp_postmeta
 */
function wp_travel_downloads_save_downloads_metabox_data( $post_id ) {

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return;
	}
	// If this is just a revision, don't send the email.
	if ( wp_is_post_revision( $post_id ) ) {
		return;
	}
	if ( ! is_admin() ) {
		return;
	}
	if ( isset( $_POST['action'] ) && 'elementor_ajax' === $_POST['action'] ) {
		return; // Return if action is elementor ajax.
	}
	if ( ! function_exists( 'get_current_screen' ) ) {
		return;
	}
	$screen    = get_current_screen();

	if ( '' == $screen ) {
		return;
	}

	if ( isset( $_POST['action'] ) ) {
		if ( 'inline-save' === $_POST['action'] ) {
			return; // Return if action is quick edit.
		}
		if ( 'elementor_ajax' === $_POST['action'] ) {
			return; // Return if action is elementor ajax.
		}
	}

	if ( isset( $_POST['project'] ) ) {
		$projects = array();
		$projects['media_id'] = $_POST['project']['media_id'];
		$projects['caption'] = $_POST['project']['caption'];
		update_post_meta( $post_id, 'wpt_downloads_cpt_meta', $projects );
	}
}
add_action( 'save_post', 'wp_travel_downloads_save_downloads_metabox_data' );

/**
 * Function to display description above downloads lists.
 */
function wp_travel_downloads_display_description_above_title( $views ) {
	$screen    = get_current_screen();
	$post_type = get_post_type_object( $screen->post_type );
	$notice    = $post_type->description;
	if ( $notice ) {
		echo wp_kses_post( '<div class="notice notice-info is-dismissible"><p><strong>' . $notice . '</strong></p></div>' ); // Echo description.
	}
	return $views; // return original input unchanged.
}
add_filter( 'views_edit-wp_travel_downloads', 'wp_travel_downloads_display_description_above_title' );


/**
 * Callback function for above metabox wp_travel_downloads_add_download_metabox()
 */
function wp_travel_downloads_cpt_downloads_metabox_callback() {
	global $post;
	$projects = get_post_meta( $post->ID, 'wpt_downloads_cpt_meta', true );
	$media_id = isset( $projects['media_id'] ) ? $projects['media_id'] : '';
	$src      = wp_get_attachment_url( $media_id );
	$caption  = isset( $projects['caption'] ) ? $projects['caption'] : '';
	?>
	<div class="content">
		<div class="element-wrapper">
			<div class="element-wrapper-grid">
				<div class="element-wrapper-grid-item img-wrap">
					<img width="50px" id="wp_img_media_uploader" src="<?php echo esc_url( $src ); ?>" />
					<input type="hidden" name="project[media_id]" value="<?php echo esc_attr( $media_id ); ?>" />
					<div class="element-wrapper-btn-group"> <button class="upload_image_button"><i class="fas fa-pencil-alt"></i></button></div>
				</div>
				<div class="element-wrapper-grid-item">
					<label for="wpt_downloads_caption"><span><?php echo esc_html__( 'Caption:', 'wp-travel-pro' ); ?></span>
						<textarea type="text" name="project[caption]" id="wpt_downloads_caption" required><?php echo esc_html( $caption ); ?></textarea>
					</label>
				</div>
			</div>
		</div>
	</div>
<?php }
