<?php
/**
 * This file has the required code for functionality to include certain downloads in booking email.
 * 
 * @since v1.0.4
 */

/**
 * Function to generate email tag for downloads.
 * 
 * @return string $downloads_email_tag Email tag to include in email template.
 */
function wp_travel_downloads_generate_email_tag() {
	$post_id             = get_the_ID();
	$download_datas      = get_post_meta( $post_id, 'wpt_downloads_cpt_meta', true );
	$media_id            = ! empty( $download_datas['media_id'] ) ? $download_datas['media_id'] : '';
	$downloads_url       = ! empty( $media_id ) ? wp_get_attachment_url( $media_id ) : '';
	$downloads_email_tag = ! empty( $downloads_url ) ? '{download_content_' . $post_id . '}' : __( 'Tag not available', 'wp-travel-pro' );
	return $downloads_email_tag;
}

/**
 * Create email tag generator metabox.
 */
function wp_travel_downloads_email_tag_generator_metabox() {

	// Add meta box functionality.
	add_meta_box(
		'wp_travel_downloads_email_tag_generator_metabox_id',
		__( 'Email Tag For Download', 'wp-travel-pro' ),
		'wp_travel_downloads_email_tag_generator_metabox_callback',
		'wp_travel_downloads',
		'side',
		'low'
	);
}
add_action( 'add_meta_boxes', 'wp_travel_downloads_email_tag_generator_metabox' );

/**
 * Callback function for the metabox.
 *
 * @return void
 */
function wp_travel_downloads_email_tag_generator_metabox_callback() {
	$generated_email_tag = wp_travel_downloads_generate_email_tag();
	?>
		<input type="text" value="<?php echo esc_attr( $generated_email_tag ); ?>" class="downloads-email-tag" disabled>
		<p class="description"><?php esc_html_e( 'To include this download in email, copy the above tag with {} and paste it in your email template.', 'wp-travel-pro' ); ?></p>
	<?php
}

/**
 * Function to create and set the email tag.
 *
 * @param array $email_tags
 * @return array $email_tags
 */
function wp_travel_downloads_return_email_tag( $email_tags ) {
	$args = array(
		'post_type'   => 'wp_travel_downloads',
		'numberposts' => -1,
	);

	$download_post_datas = get_posts( $args );
	if ( is_array( $download_post_datas ) && count( $download_post_datas ) > 0 ) {
		foreach ( $download_post_datas as $download_post_data ) {
			$post_id              = $download_post_data->ID;
			$post_title           = $download_post_data->post_title;
			$download_datas       = get_post_meta( $post_id, 'wpt_downloads_cpt_meta', true );
			$media_id             = ! empty( $download_datas['media_id'] ) ? $download_datas['media_id'] : '';
			$downloads_url        = ! empty( $media_id ) ? wp_get_attachment_url( $media_id ) : '';
			$downloads_email_tag  = ! empty( $downloads_url ) ? '{download_content_' . $post_id . '}' : '';
			$download_email_title = ! empty( $downloads_email_tag ) ? '<a href="' . $downloads_url . '">' . $post_title . '</a>' : 'Downloads not available';

			$email_tags[ $downloads_email_tag ] = $download_email_title;
		}
	}
	return $email_tags;
}
// add_filter( 'wp_travel_admin_email_tags', 'wp_travel_downloads_return_email_tag' ); // Deprecated @since 1.0.8.
add_filter( 'wp_travel_admin_booking_email_tags', 'wp_travel_downloads_return_email_tag' );
